/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.DexElement;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.DexGenerator;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationReader;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class DexElementImpl
implements DexElement {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final int CLASSES_PER_DEX_FILE = 100;
    private final ApplicationReader ar;
    private final File cacheDir;
    private final DexGenerator dexGenerator;
    private final DexFileLoader fileLoader;
    private final List<String> unloadedClassNames;
    private final List<DexFile> dexFiles = new ArrayList<DexFile>();

    DexElementImpl(ApplicationReader ar, Collection<String> classNames, File cacheDir, DexGenerator dexGenerator, DexFileLoader fileLoader) {
        this.ar = ar;
        this.cacheDir = cacheDir;
        this.dexGenerator = dexGenerator;
        this.unloadedClassNames = new ArrayList<String>(classNames);
        this.fileLoader = fileLoader;
    }

    @Override
    public Class loadClass(String name, ClassLoader classLoader) {
        DexFile dexFile;
        for (DexFile d : this.dexFiles) {
            Class c = d.loadClass(name, classLoader);
            if (c == null) continue;
            return c;
        }
        String[] classesToVisit = DexElementImpl.findClassesToVisit(name, this.unloadedClassNames);
        if (classesToVisit.length == 0) {
            return null;
        }
        try {
            File source = this.dexGenerator.generateDexFile(this.ar, this.cacheDir, classesToVisit);
            File output = new File(this.cacheDir, source.getName() + ".dex");
            dexFile = this.fileLoader.load(source.getCanonicalPath(), output.getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.dexFiles.add(dexFile);
        return dexFile.loadClass(name, classLoader);
    }

    private static String[] findClassesToVisit(String name, Collection<String> unloadedClassNames) {
        String className = 'L' + name.replace('.', '/') + ';';
        if (!unloadedClassNames.contains(className)) {
            return EMPTY_STRINGS;
        }
        HashSet<String> names = new HashSet<String>();
        names.add(className);
        int slash = className.lastIndexOf(47);
        String pkg = slash == -1 ? null : className.substring(0, slash) + '/';
        Iterator<String> it = unloadedClassNames.iterator();
        while (it.hasNext()) {
            String s = it.next();
            if (pkg != null && !s.startsWith(pkg)) continue;
            names.add(s);
            it.remove();
            if (names.size() <= 100) continue;
            break;
        }
        return names.toArray(new String[names.size()]);
    }
}

