/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.DexDataWriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.StringSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.TypeSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;
import java.io.IOException;

public class DebugWriter<StringKey extends CharSequence, TypeKey extends CharSequence> {
    private final StringSection<StringKey, ?> stringSection;
    private final TypeSection<StringKey, TypeKey, ?> typeSection;
    private final DexDataWriter writer;
    private int currentAddress;
    private int currentLine;

    DebugWriter(StringSection<StringKey, ?> stringSection, TypeSection<StringKey, TypeKey, ?> typeSection, DexDataWriter dexDataWriter) {
        this.stringSection = stringSection;
        this.typeSection = typeSection;
        this.writer = dexDataWriter;
    }

    void reset(int n) {
        this.currentAddress = 0;
        this.currentLine = n;
    }

    public void writeStartLocal(int n, int n2, StringKey StringKey, TypeKey TypeKey, StringKey StringKey2) throws IOException {
        int n3 = this.stringSection.getNullableItemIndex(StringKey);
        int n4 = this.typeSection.getNullableItemIndex(TypeKey);
        int n5 = this.stringSection.getNullableItemIndex(StringKey2);
        this.writeAdvancePC(n);
        if (n5 == -1) {
            this.writer.write(3);
            this.writer.writeUleb128(n2);
            this.writer.writeUleb128(n3 + 1);
            this.writer.writeUleb128(n4 + 1);
        } else {
            this.writer.write(4);
            this.writer.writeUleb128(n2);
            this.writer.writeUleb128(n3 + 1);
            this.writer.writeUleb128(n4 + 1);
            this.writer.writeUleb128(n5 + 1);
        }
    }

    public void writeEndLocal(int n, int n2) throws IOException {
        this.writeAdvancePC(n);
        this.writer.write(5);
        this.writer.writeUleb128(n2);
    }

    public void writeRestartLocal(int n, int n2) throws IOException {
        this.writeAdvancePC(n);
        this.writer.write(6);
        this.writer.writeUleb128(n2);
    }

    public void writePrologueEnd(int n) throws IOException {
        this.writeAdvancePC(n);
        this.writer.write(7);
    }

    public void writeEpilogueBegin(int n) throws IOException {
        this.writeAdvancePC(n);
        this.writer.write(8);
    }

    public void writeLineNumber(int n, int n2) throws IOException {
        int n3 = n2 - this.currentLine;
        int n4 = n - this.currentAddress;
        if (n4 < 0) {
            throw new ExceptionWithContext("debug info items must have non-decreasing code addresses", new Object[0]);
        }
        if (n3 < -4 || n3 > 10) {
            this.writeAdvanceLine(n2);
            n3 = 0;
        }
        if (n3 < 2 && n4 > 16 || n3 > 1 && n4 > 15) {
            this.writeAdvancePC(n);
            n4 = 0;
        }
        this.writeSpecialOpcode(n3, n4);
    }

    public void writeSetSourceFile(int n, StringKey StringKey) throws IOException {
        this.writeAdvancePC(n);
        this.writer.write(9);
        this.writer.writeUleb128(this.stringSection.getNullableItemIndex(StringKey) + 1);
    }

    private void writeAdvancePC(int n) throws IOException {
        int n2 = n - this.currentAddress;
        if (n2 > 0) {
            this.writer.write(1);
            this.writer.writeUleb128(n2);
            this.currentAddress = n;
        }
    }

    private void writeAdvanceLine(int n) throws IOException {
        int n2 = n - this.currentLine;
        if (n2 != 0) {
            this.writer.write(2);
            this.writer.writeSleb128(n2);
            this.currentLine = n;
        }
    }

    private void writeSpecialOpcode(int n, int n2) throws IOException {
        this.writer.write((byte)(10 + n2 * 15 + (n - -4)));
        this.currentLine += n;
        this.currentAddress += n2;
    }
}

