/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.raw.HeaderItem;

public class DexUtil {
    public static void verifyDexHeader(byte[] byArray, int n) {
        int n2 = HeaderItem.getVersion(byArray, n);
        if (n2 == -1) {
            StringBuilder stringBuilder = new StringBuilder("Not a valid dex magic value:");
            for (int i = 0; i < 8; ++i) {
                stringBuilder.append(String.format(" %02x", byArray[i]));
            }
            throw new DexBackedDexFile.NotADexFile(stringBuilder.toString());
        }
        if (!HeaderItem.isSupportedDexVersion(n2)) {
            throw new UnsupportedFile(String.format("Dex version %03d is not supported", n2));
        }
        int n3 = HeaderItem.getEndian(byArray, n);
        if (n3 == 2018915346) {
            throw new UnsupportedFile("Big endian dex files are not supported");
        }
        if (n3 != 305419896) {
            throw new InvalidFile(String.format("Invalid endian tag: 0x%x", n3));
        }
    }

    public static class UnsupportedFile
    extends RuntimeException {
        public UnsupportedFile() {
        }

        public UnsupportedFile(String string) {
            super(string);
        }
    }

    public static class InvalidFile
    extends RuntimeException {
        public InvalidFile() {
        }

        public InvalidFile(String string) {
            super(string);
        }
    }
}

