/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Format;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.ArrayPayload;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction.ImmutableInstruction;
import java.util.List;

public class ImmutableArrayPayload
extends ImmutableInstruction
implements ArrayPayload {
    public static final Opcode OPCODE = Opcode.ARRAY_PAYLOAD;
    protected final int elementWidth;
    protected final ImmutableList<Number> arrayElements;

    public ImmutableArrayPayload(int n, List<Number> list) {
        super(OPCODE);
        this.elementWidth = n;
        this.arrayElements = list == null ? ImmutableList.of() : ImmutableList.copyOf(list);
    }

    public static ImmutableArrayPayload of(ArrayPayload arrayPayload) {
        if (arrayPayload instanceof ImmutableArrayPayload) {
            return (ImmutableArrayPayload)arrayPayload;
        }
        return new ImmutableArrayPayload(arrayPayload.getElementWidth(), arrayPayload.getArrayElements());
    }

    @Override
    public int getElementWidth() {
        return this.elementWidth;
    }

    @Override
    public List<Number> getArrayElements() {
        return this.arrayElements;
    }

    @Override
    public int getCodeUnits() {
        return 4 + (this.elementWidth * this.arrayElements.size() + 1) / 2;
    }

    @Override
    public Format getFormat() {
        return ImmutableArrayPayload.OPCODE.format;
    }
}

