/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.BaseExceptionHandler;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ExceptionHandler;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ImmutableConverter;

public class ImmutableExceptionHandler
extends BaseExceptionHandler
implements ExceptionHandler {
    protected final String exceptionType;
    protected final int handlerCodeAddress;
    private static final ImmutableConverter<ImmutableExceptionHandler, ExceptionHandler> CONVERTER = new ImmutableConverter<ImmutableExceptionHandler, ExceptionHandler>(){

        @Override
        protected boolean isImmutable(ExceptionHandler exceptionHandler) {
            return exceptionHandler instanceof ImmutableExceptionHandler;
        }

        @Override
        protected ImmutableExceptionHandler makeImmutable(ExceptionHandler exceptionHandler) {
            return ImmutableExceptionHandler.of(exceptionHandler);
        }
    };

    public ImmutableExceptionHandler(String string, int n) {
        this.exceptionType = string;
        this.handlerCodeAddress = n;
    }

    public static ImmutableExceptionHandler of(ExceptionHandler exceptionHandler) {
        if (exceptionHandler instanceof ImmutableExceptionHandler) {
            return (ImmutableExceptionHandler)exceptionHandler;
        }
        return new ImmutableExceptionHandler(exceptionHandler.getExceptionType(), exceptionHandler.getHandlerCodeAddress());
    }

    @Override
    public String getExceptionType() {
        return this.exceptionType;
    }

    @Override
    public int getHandlerCodeAddress() {
        return this.handlerCodeAddress;
    }

    public static ImmutableList<ImmutableExceptionHandler> immutableListOf(Iterable<? extends ExceptionHandler> iterable) {
        return CONVERTER.toList(iterable);
    }
}

