/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSet;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSortedSet;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Iterables;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Iterators;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.reference.BaseTypeReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Annotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Field;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Method;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableAnnotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableField;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableMethod;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.FieldUtil;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.MethodUtil;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ImmutableConverter;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

public class ImmutableClassDef
extends BaseTypeReference
implements ClassDef {
    protected final String type;
    protected final int accessFlags;
    protected final String superclass;
    protected final ImmutableList<String> interfaces;
    protected final String sourceFile;
    protected final ImmutableSet<? extends ImmutableAnnotation> annotations;
    protected final ImmutableSortedSet<? extends ImmutableField> staticFields;
    protected final ImmutableSortedSet<? extends ImmutableField> instanceFields;
    protected final ImmutableSortedSet<? extends ImmutableMethod> directMethods;
    protected final ImmutableSortedSet<? extends ImmutableMethod> virtualMethods;
    private static final ImmutableConverter<ImmutableClassDef, ClassDef> CONVERTER = new ImmutableConverter<ImmutableClassDef, ClassDef>(){

        @Override
        protected boolean isImmutable(ClassDef classDef) {
            return classDef instanceof ImmutableClassDef;
        }

        @Override
        protected ImmutableClassDef makeImmutable(ClassDef classDef) {
            return ImmutableClassDef.of(classDef);
        }
    };

    public ImmutableClassDef(String string, int n, String string2, Collection<String> collection, String string3, Collection<? extends Annotation> collection2, Iterable<? extends Field> iterable, Iterable<? extends Method> iterable2) {
        if (iterable == null) {
            iterable = ImmutableList.of();
        }
        if (iterable2 == null) {
            iterable2 = ImmutableList.of();
        }
        this.type = string;
        this.accessFlags = n;
        this.superclass = string2;
        this.interfaces = collection == null ? ImmutableList.of() : ImmutableList.copyOf(collection);
        this.sourceFile = string3;
        this.annotations = ImmutableAnnotation.immutableSetOf(collection2);
        this.staticFields = ImmutableField.immutableSetOf(Iterables.filter(iterable, FieldUtil.FIELD_IS_STATIC));
        this.instanceFields = ImmutableField.immutableSetOf(Iterables.filter(iterable, FieldUtil.FIELD_IS_INSTANCE));
        this.directMethods = ImmutableMethod.immutableSetOf(Iterables.filter(iterable2, MethodUtil.METHOD_IS_DIRECT));
        this.virtualMethods = ImmutableMethod.immutableSetOf(Iterables.filter(iterable2, MethodUtil.METHOD_IS_VIRTUAL));
    }

    public ImmutableClassDef(String string, int n, String string2, Collection<String> collection, String string3, Collection<? extends Annotation> collection2, Iterable<? extends Field> iterable, Iterable<? extends Field> iterable2, Iterable<? extends Method> iterable3, Iterable<? extends Method> iterable4) {
        this.type = string;
        this.accessFlags = n;
        this.superclass = string2;
        this.interfaces = collection == null ? ImmutableList.of() : ImmutableList.copyOf(collection);
        this.sourceFile = string3;
        this.annotations = ImmutableAnnotation.immutableSetOf(collection2);
        this.staticFields = ImmutableField.immutableSetOf(iterable);
        this.instanceFields = ImmutableField.immutableSetOf(iterable2);
        this.directMethods = ImmutableMethod.immutableSetOf(iterable3);
        this.virtualMethods = ImmutableMethod.immutableSetOf(iterable4);
    }

    public static ImmutableClassDef of(ClassDef classDef) {
        if (classDef instanceof ImmutableClassDef) {
            return (ImmutableClassDef)classDef;
        }
        return new ImmutableClassDef(classDef.getType(), classDef.getAccessFlags(), classDef.getSuperclass(), classDef.getInterfaces(), classDef.getSourceFile(), classDef.getAnnotations(), classDef.getStaticFields(), classDef.getInstanceFields(), classDef.getDirectMethods(), classDef.getVirtualMethods());
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    public String getSuperclass() {
        return this.superclass;
    }

    public ImmutableList<String> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public String getSourceFile() {
        return this.sourceFile;
    }

    public ImmutableSet<? extends ImmutableAnnotation> getAnnotations() {
        return this.annotations;
    }

    public ImmutableSet<? extends ImmutableField> getStaticFields() {
        return this.staticFields;
    }

    public ImmutableSet<? extends ImmutableField> getInstanceFields() {
        return this.instanceFields;
    }

    public ImmutableSet<? extends ImmutableMethod> getDirectMethods() {
        return this.directMethods;
    }

    public ImmutableSet<? extends ImmutableMethod> getVirtualMethods() {
        return this.virtualMethods;
    }

    public Collection<? extends ImmutableField> getFields() {
        return new AbstractCollection<ImmutableField>(){

            @Override
            public Iterator<ImmutableField> iterator() {
                return Iterators.concat(ImmutableClassDef.this.staticFields.iterator(), ImmutableClassDef.this.instanceFields.iterator());
            }

            @Override
            public int size() {
                return ImmutableClassDef.this.staticFields.size() + ImmutableClassDef.this.instanceFields.size();
            }
        };
    }

    public Collection<? extends ImmutableMethod> getMethods() {
        return new AbstractCollection<ImmutableMethod>(){

            @Override
            public Iterator<ImmutableMethod> iterator() {
                return Iterators.concat(ImmutableClassDef.this.directMethods.iterator(), ImmutableClassDef.this.virtualMethods.iterator());
            }

            @Override
            public int size() {
                return ImmutableClassDef.this.directMethods.size() + ImmutableClassDef.this.virtualMethods.size();
            }
        };
    }
}

