/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSet;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.BaseAnnotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Annotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.AnnotationElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableAnnotationElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ImmutableConverter;
import java.util.Collection;

public class ImmutableAnnotation
extends BaseAnnotation {
    protected final int visibility;
    protected final String type;
    protected final ImmutableSet<? extends ImmutableAnnotationElement> elements;
    private static final ImmutableConverter<ImmutableAnnotation, Annotation> CONVERTER = new ImmutableConverter<ImmutableAnnotation, Annotation>(){

        @Override
        protected boolean isImmutable(Annotation annotation) {
            return annotation instanceof ImmutableAnnotation;
        }

        @Override
        protected ImmutableAnnotation makeImmutable(Annotation annotation) {
            return ImmutableAnnotation.of(annotation);
        }
    };

    public ImmutableAnnotation(int n, String string, Collection<? extends AnnotationElement> collection) {
        this.visibility = n;
        this.type = string;
        this.elements = ImmutableAnnotationElement.immutableSetOf(collection);
    }

    public static ImmutableAnnotation of(Annotation annotation) {
        if (annotation instanceof ImmutableAnnotation) {
            return (ImmutableAnnotation)annotation;
        }
        return new ImmutableAnnotation(annotation.getVisibility(), annotation.getType(), annotation.getElements());
    }

    @Override
    public int getVisibility() {
        return this.visibility;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public ImmutableSet<? extends ImmutableAnnotationElement> getElements() {
        return this.elements;
    }

    public static ImmutableSet<ImmutableAnnotation> immutableSetOf(Iterable<? extends Annotation> iterable) {
        return CONVERTER.toSet(iterable);
    }
}

