/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.value;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexReader;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.value.DexBackedAnnotationEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.value.DexBackedArrayEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.value.DexBackedEnumEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.value.DexBackedFieldEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.value.DexBackedMethodEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.value.DexBackedStringEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.value.DexBackedTypeEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableBooleanEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableByteEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableCharEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableDoubleEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableFloatEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableIntEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableLongEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableNullEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableShortEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.Preconditions;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;

public abstract class DexBackedEncodedValue {
    public static EncodedValue readFrom(DexReader dexReader) {
        int n = dexReader.getOffset();
        try {
            int n2 = dexReader.readUbyte();
            int n3 = n2 & 0x1F;
            int n4 = n2 >>> 5;
            switch (n3) {
                case 0: {
                    Preconditions.checkValueArg(n4, 0);
                    return new ImmutableByteEncodedValue((byte)dexReader.readByte());
                }
                case 2: {
                    Preconditions.checkValueArg(n4, 1);
                    return new ImmutableShortEncodedValue((short)dexReader.readSizedInt(n4 + 1));
                }
                case 3: {
                    Preconditions.checkValueArg(n4, 1);
                    return new ImmutableCharEncodedValue((char)dexReader.readSizedSmallUint(n4 + 1));
                }
                case 4: {
                    Preconditions.checkValueArg(n4, 3);
                    return new ImmutableIntEncodedValue(dexReader.readSizedInt(n4 + 1));
                }
                case 6: {
                    Preconditions.checkValueArg(n4, 7);
                    return new ImmutableLongEncodedValue(dexReader.readSizedLong(n4 + 1));
                }
                case 16: {
                    Preconditions.checkValueArg(n4, 3);
                    return new ImmutableFloatEncodedValue(Float.intBitsToFloat(dexReader.readSizedRightExtendedInt(n4 + 1)));
                }
                case 17: {
                    Preconditions.checkValueArg(n4, 7);
                    return new ImmutableDoubleEncodedValue(Double.longBitsToDouble(dexReader.readSizedRightExtendedLong(n4 + 1)));
                }
                case 23: {
                    Preconditions.checkValueArg(n4, 3);
                    return new DexBackedStringEncodedValue(dexReader, n4);
                }
                case 24: {
                    Preconditions.checkValueArg(n4, 3);
                    return new DexBackedTypeEncodedValue(dexReader, n4);
                }
                case 25: {
                    Preconditions.checkValueArg(n4, 3);
                    return new DexBackedFieldEncodedValue(dexReader, n4);
                }
                case 26: {
                    Preconditions.checkValueArg(n4, 3);
                    return new DexBackedMethodEncodedValue(dexReader, n4);
                }
                case 27: {
                    Preconditions.checkValueArg(n4, 3);
                    return new DexBackedEnumEncodedValue(dexReader, n4);
                }
                case 28: {
                    Preconditions.checkValueArg(n4, 0);
                    return new DexBackedArrayEncodedValue(dexReader);
                }
                case 29: {
                    Preconditions.checkValueArg(n4, 0);
                    return new DexBackedAnnotationEncodedValue(dexReader);
                }
                case 30: {
                    Preconditions.checkValueArg(n4, 0);
                    return ImmutableNullEncodedValue.INSTANCE;
                }
                case 31: {
                    Preconditions.checkValueArg(n4, 1);
                    return ImmutableBooleanEncodedValue.forBoolean(n4 == 1);
                }
            }
            throw new ExceptionWithContext("Invalid encoded_value type: 0x%x", n3);
        }
        catch (Exception exception) {
            throw ExceptionWithContext.withContext(exception, "Error while reading encoded value at offset 0x%x", n);
        }
    }

    public static void skipFrom(DexReader dexReader) {
        int n = dexReader.getOffset();
        try {
            int n2 = dexReader.readUbyte();
            int n3 = n2 & 0x1F;
            switch (n3) {
                case 0: {
                    dexReader.skipByte();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 16: 
                case 17: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    int n4 = n2 >>> 5;
                    dexReader.moveRelative(n4 + 1);
                    break;
                }
                case 28: {
                    DexBackedArrayEncodedValue.skipFrom(dexReader);
                    break;
                }
                case 29: {
                    DexBackedAnnotationEncodedValue.skipFrom(dexReader);
                    break;
                }
                case 30: 
                case 31: {
                    break;
                }
                default: {
                    throw new ExceptionWithContext("Invalid encoded_value type: 0x%x", n3);
                }
            }
        }
        catch (Exception exception) {
            throw ExceptionWithContext.withContext(exception, "Error while skipping encoded value at offset 0x%x", n);
        }
    }
}

