/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.google.common.collect;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Function;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Objects;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Preconditions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Predicate;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Predicates;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.AbstractIndexedListIterator;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.AbstractIterator;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.CollectPreconditions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Collections2;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.PeekingIterator;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.TransformedIterator;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.UnmodifiableIterator;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.UnmodifiableListIterator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Queue;

public final class Iterators {
    static final UnmodifiableListIterator<Object> EMPTY_LIST_ITERATOR = new UnmodifiableListIterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public Object previous() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }
    };
    private static final Iterator<Object> EMPTY_MODIFIABLE_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            CollectPreconditions.checkRemove(false);
        }
    };

    public static <T> UnmodifiableIterator<T> emptyIterator() {
        return Iterators.emptyListIterator();
    }

    static <T> UnmodifiableListIterator<T> emptyListIterator() {
        return EMPTY_LIST_ITERATOR;
    }

    public static int size(Iterator<?> iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    public static boolean contains(Iterator<?> iterator, Object object) {
        return Iterators.any(iterator, Predicates.equalTo(object));
    }

    public static boolean removeAll(Iterator<?> iterator, Collection<?> collection) {
        return Iterators.removeIf(iterator, Predicates.in(collection));
    }

    public static <T> boolean removeIf(Iterator<T> iterator, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        boolean bl = false;
        while (iterator.hasNext()) {
            if (!predicate.apply(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public static boolean elementsEqual(Iterator<?> iterator, Iterator<?> iterator2) {
        while (iterator.hasNext()) {
            Object obj;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object obj2 = iterator.next();
            if (Objects.equal(obj2, obj = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static String toString(Iterator<?> iterator) {
        return Collections2.STANDARD_JOINER.appendTo(new StringBuilder().append('['), iterator).append(']').toString();
    }

    public static <T> boolean addAll(Collection<T> collection, Iterator<? extends T> iterator) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkNotNull(iterator);
        boolean bl = false;
        while (iterator.hasNext()) {
            bl |= collection.add(iterator.next());
        }
        return bl;
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> iterator, Iterator<? extends T> iterator2) {
        return Iterators.concat(ImmutableList.of(iterator, iterator2).iterator());
    }

    public static <T> Iterator<T> concat(final Iterator<? extends Iterator<? extends T>> iterator) {
        Preconditions.checkNotNull(iterator);
        return new Iterator<T>(){
            Iterator<? extends T> current = Iterators.emptyIterator();
            Iterator<? extends T> removeFrom;

            @Override
            public boolean hasNext() {
                boolean bl;
                while (!(bl = Preconditions.checkNotNull(this.current).hasNext()) && iterator.hasNext()) {
                    this.current = (Iterator)iterator.next();
                }
                return bl;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.removeFrom = this.current;
                return this.current.next();
            }

            @Override
            public void remove() {
                CollectPreconditions.checkRemove(this.removeFrom != null);
                this.removeFrom.remove();
                this.removeFrom = null;
            }
        };
    }

    public static <T> UnmodifiableIterator<T> filter(final Iterator<T> iterator, final Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(predicate);
        return new AbstractIterator<T>(){

            @Override
            protected T computeNext() {
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!predicate.apply(e)) continue;
                    return e;
                }
                return this.endOfData();
            }
        };
    }

    public static <T> boolean any(Iterator<T> iterator, Predicate<? super T> predicate) {
        return Iterators.indexOf(iterator, predicate) != -1;
    }

    public static <T> int indexOf(Iterator<T> iterator, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate, "predicate");
        int n = 0;
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (predicate.apply(t)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static <F, T> Iterator<T> transform(Iterator<F> iterator, final Function<? super F, ? extends T> function) {
        Preconditions.checkNotNull(function);
        return new TransformedIterator<F, T>(iterator){

            @Override
            T transform(F f) {
                return function.apply(f);
            }
        };
    }

    public static <T> T getNext(Iterator<? extends T> iterator, T t) {
        return iterator.hasNext() ? iterator.next() : t;
    }

    public static <T> Iterator<T> limit(final Iterator<T> iterator, final int n) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkArgument(n >= 0, "limit is negative");
        return new Iterator<T>(){
            private int count;

            @Override
            public boolean hasNext() {
                return this.count < n && iterator.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.count;
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    static <T> T pollNext(Iterator<T> iterator) {
        if (iterator.hasNext()) {
            T t = iterator.next();
            iterator.remove();
            return t;
        }
        return null;
    }

    public static <T> UnmodifiableIterator<T> forArray(T ... TArray) {
        return Iterators.forArray(TArray, 0, TArray.length, 0);
    }

    static <T> UnmodifiableListIterator<T> forArray(final T[] TArray, final int n, int n2, int n3) {
        Preconditions.checkArgument(n2 >= 0);
        int n4 = n + n2;
        Preconditions.checkPositionIndexes(n, n4, TArray.length);
        Preconditions.checkPositionIndex(n3, n2);
        if (n2 == 0) {
            return Iterators.emptyListIterator();
        }
        return new AbstractIndexedListIterator<T>(n2, n3){

            @Override
            protected T get(int n2) {
                return TArray[n + n2];
            }
        };
    }

    public static <T> UnmodifiableIterator<T> singletonIterator(final T t) {
        return new UnmodifiableIterator<T>(){
            boolean done;

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public T next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                this.done = true;
                return t;
            }
        };
    }

    public static <T> PeekingIterator<T> peekingIterator(Iterator<? extends T> iterator) {
        if (iterator instanceof PeekingImpl) {
            PeekingImpl peekingImpl = (PeekingImpl)iterator;
            return peekingImpl;
        }
        return new PeekingImpl<T>(iterator);
    }

    public static <T> UnmodifiableIterator<T> mergeSorted(Iterable<? extends Iterator<? extends T>> iterable, Comparator<? super T> comparator) {
        Preconditions.checkNotNull(iterable, "iterators");
        Preconditions.checkNotNull(comparator, "comparator");
        return new MergingIterator<T>(iterable, comparator);
    }

    static <T> ListIterator<T> cast(Iterator<T> iterator) {
        return (ListIterator)iterator;
    }

    private static class MergingIterator<T>
    extends UnmodifiableIterator<T> {
        final Queue<PeekingIterator<T>> queue;

        public MergingIterator(Iterable<? extends Iterator<? extends T>> iterable, final Comparator<? super T> comparator) {
            Comparator comparator2 = new Comparator<PeekingIterator<T>>(){

                @Override
                public int compare(PeekingIterator<T> peekingIterator, PeekingIterator<T> peekingIterator2) {
                    return comparator.compare(peekingIterator.peek(), peekingIterator2.peek());
                }
            };
            this.queue = new PriorityQueue<PeekingIterator<T>>(2, comparator2);
            for (Iterator<T> iterator : iterable) {
                if (!iterator.hasNext()) continue;
                this.queue.add(Iterators.peekingIterator(iterator));
            }
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public T next() {
            PeekingIterator<T> peekingIterator = this.queue.remove();
            T t = peekingIterator.next();
            if (peekingIterator.hasNext()) {
                this.queue.add(peekingIterator);
            }
            return t;
        }
    }

    private static class PeekingImpl<E>
    implements PeekingIterator<E> {
        private final Iterator<? extends E> iterator;
        private boolean hasPeeked;
        private E peekedElement;

        public PeekingImpl(Iterator<? extends E> iterator) {
            this.iterator = Preconditions.checkNotNull(iterator);
        }

        @Override
        public boolean hasNext() {
            return this.hasPeeked || this.iterator.hasNext();
        }

        @Override
        public E next() {
            if (!this.hasPeeked) {
                return this.iterator.next();
            }
            E e = this.peekedElement;
            this.hasPeeked = false;
            this.peekedElement = null;
            return e;
        }

        @Override
        public void remove() {
            Preconditions.checkState(!this.hasPeeked, "Can't remove after you've peeked at next");
            this.iterator.remove();
        }

        @Override
        public E peek() {
            if (!this.hasPeeked) {
                this.peekedElement = this.iterator.next();
                this.hasPeeked = true;
            }
            return this.peekedElement;
        }
    }
}

