/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector;

import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassFile;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ClassSources
implements ClassSource {
    private final List<ClassSource> sources;

    public ClassSources(Iterable<? extends ClassSource> iterable) {
        ArrayList<ClassSource> arrayList = new ArrayList<ClassSource>();
        for (ClassSource classSource : iterable) {
            if (classSource == null) {
                throw new IllegalArgumentException("'sources' contains null");
            }
            arrayList.add(classSource);
        }
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("'sources' is empty");
        }
        this.sources = arrayList;
    }

    @Override
    public ClassFile getClassFile(String string) throws IOException {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("'className' is empty");
        }
        for (ClassSource classSource : this.sources) {
            ClassFile classFile = classSource.getClassFile(string);
            if (classFile == null) continue;
            return classFile;
        }
        return null;
    }
}

