/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import com.github.tmurakami.dexopener.AndroidClassSource;
import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.DexClassFileFactory;
import com.github.tmurakami.dexopener.DexClassSourceFactory;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.DexOpener;
import com.github.tmurakami.dexopener.FileUtils;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassInjector;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassSource;
import java.io.File;

final class DexOpenerImpl
extends DexOpener {
    private final ApplicationInfo applicationInfo;
    private final ClassNameFilter classNameFilter;
    private final DexFileLoader dexFileLoader;
    private final DexClassFileFactory dexClassFileFactory;

    DexOpenerImpl(ApplicationInfo applicationInfo, ClassNameFilter classNameFilter, DexFileLoader dexFileLoader, DexClassFileFactory dexClassFileFactory) {
        this.applicationInfo = applicationInfo;
        this.classNameFilter = classNameFilter;
        this.dexFileLoader = dexFileLoader;
        this.dexClassFileFactory = dexClassFileFactory;
    }

    @Override
    public void installTo(@NonNull ClassLoader classLoader) {
        ApplicationInfo ai = this.applicationInfo;
        DexOpenerImpl.assertMinSdkVersionIsLowerThan26(ai);
        ClassInjector.from((ClassSource)this.newClassSource(ai)).into(classLoader);
    }

    private ClassSource newClassSource(ApplicationInfo ai) {
        return new AndroidClassSource(ai.sourceDir, this.classNameFilter, this.newDexClassSourceFactory(ai));
    }

    private DexClassSourceFactory newDexClassSourceFactory(ApplicationInfo ai) {
        return new DexClassSourceFactory(this.classNameFilter, DexOpenerImpl.getCacheDir(ai), this.dexFileLoader, this.dexClassFileFactory);
    }

    private static File getCacheDir(ApplicationInfo ai) {
        File cacheDir = new File(ai.dataDir, "code_cache/dexopener");
        if (cacheDir.isDirectory()) {
            FileUtils.delete(cacheDir.listFiles());
        }
        return cacheDir;
    }

    private static void assertMinSdkVersionIsLowerThan26(ApplicationInfo ai) {
        if (Build.VERSION.SDK_INT >= 24 && ai.minSdkVersion >= 26) {
            throw new UnsupportedOperationException("minSdkVersion must be lower than 26");
        }
    }
}

