/*
 * Decompiled with CFR 0.152.
 */
package fluflu.msgpack;

import fluflu.msgpack.MessagePacker;
import fluflu.msgpack.package$;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import scala.Array$;
import scala.Predef$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class MessagePacker$ {
    public static MessagePacker$ MODULE$;
    private final ThreadLocal<CharsetEncoder> encoders;

    static {
        new MessagePacker$();
    }

    public MessagePacker apply() {
        return new MessagePacker();
    }

    public void formatArrayFamilyHeader(int size, ArrayBuilder<Object> builder) {
        if (size < 16) {
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(0x90 | size))));
        } else if (size < 65536) {
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)package$.MODULE$.0xdc()));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(size >>> 8))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(size >>> 0))));
        } else {
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)package$.MODULE$.0xdd()));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(size >>> 24))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(size >>> 16))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(size >>> 8))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(size >>> 0))));
        }
    }

    public void formatMapFamilyHeader(int sz, ArrayBuilder<Object> builder) {
        if (sz < 16) {
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(0x80 | sz))));
        } else if (sz < 65536) {
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)package$.MODULE$.0xde()));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 8))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 0))));
        } else {
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)package$.MODULE$.0xdf()));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 24))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 16))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 8))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 0))));
        }
    }

    public void formatStrFamilyHeader(int sz, ArrayBuilder<Object> builder) {
        if (sz < 32) {
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(0xA0 | sz))));
        } else if (sz < 65536) {
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)package$.MODULE$.0xda()));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 8))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 0))));
        } else {
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)package$.MODULE$.0xdb()));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 24))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 16))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 8))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 0))));
        }
    }

    public void formatNil(ArrayBuilder<Object> builder) {
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)package$.MODULE$.0xc0()));
    }

    public void formatBoolFamily(boolean v, ArrayBuilder<Object> builder) {
        builder.$plus$eq((Object)(v ? BoxesRunTime.boxToByte((byte)package$.MODULE$.0xc3()) : BoxesRunTime.boxToByte((byte)package$.MODULE$.0xc2())));
    }

    public void formatIntFamily(long l, ArrayBuilder<Object> builder) {
        if (0x100000000L <= l) {
            this.formatLong(package$.MODULE$.0xcf(), l, builder);
        } else if (65536L <= l) {
            this.formatInt(package$.MODULE$.0xce(), (int)l, builder);
        } else if (256L <= l) {
            this.formatShort(package$.MODULE$.0xcd(), (int)l, builder);
        } else if (128L <= l) {
            this.formatByte(package$.MODULE$.0xcc(), (byte)l, builder);
        } else if (0L <= l) {
            this.formatByte((byte)l, builder);
        } else if (l >= -32L) {
            this.formatByte((byte)(0xE0L | l + 32L), builder);
        } else if (l >= (long)-128) {
            this.formatByte(package$.MODULE$.0xd0(), (byte)l, builder);
        } else if (l >= (long)Short.MIN_VALUE) {
            this.formatShort(package$.MODULE$.0xd1(), (int)l, builder);
        } else if (l >= (long)Integer.MIN_VALUE) {
            this.formatInt(package$.MODULE$.0xd2(), (int)l, builder);
        } else {
            this.formatLong(package$.MODULE$.0xd3(), l, builder);
        }
    }

    public void formatIntFamily(byte t, BigInt v, ArrayBuilder<Object> builder) {
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)t));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)v.$greater$greater(56).toByte()));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)v.$greater$greater(48).toByte()));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)v.$greater$greater(40).toByte()));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)v.$greater$greater(32).toByte()));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)v.$greater$greater(24).toByte()));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)v.$greater$greater(16).toByte()));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)v.$greater$greater(8).toByte()));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)v.$greater$greater(0).toByte()));
    }

    public void formatFloatFamily(double v, ArrayBuilder<Object> builder) {
        long x = Double.doubleToLongBits(v);
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)package$.MODULE$.0xcb()));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(x >>> 56))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(x >>> 48))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(x >>> 40))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(x >>> 32))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(x >>> 24))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(x >>> 16))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(x >>> 8))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(x >>> 0))));
    }

    public void formatStrFamily(String v, ArrayBuilder<Object> builder) {
        CharBuffer cb = CharBuffer.wrap(v);
        ByteBuffer buf = this.encoders.get().encode(cb);
        int len = buf.remaining();
        this.formatStrFamilyHeader(len, builder);
        byte[] arr = (byte[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Byte());
        buf.get(arr);
        builder.$plus$plus$eq((TraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arr)));
        buf.clear();
        cb.clear();
    }

    public void formatByte(byte v, ArrayBuilder<Object> builder) {
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)v));
    }

    public void formatByte(byte t, byte v, ArrayBuilder<Object> builder) {
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)t));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)v));
    }

    public void formatShort(byte t, int v, ArrayBuilder<Object> builder) {
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)t));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 8))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 0))));
    }

    public void formatInt(byte t, int v, ArrayBuilder<Object> builder) {
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)t));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 24))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 16))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 8))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 0))));
    }

    public void formatLong(byte t, long v, ArrayBuilder<Object> builder) {
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)t));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 56))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 48))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 40))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 32))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 24))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 16))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 8))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 0))));
    }

    private MessagePacker$() {
        MODULE$ = this;
        this.encoders = new ThreadLocal<CharsetEncoder>(){

            public CharsetEncoder initialValue() {
                return StandardCharsets.UTF_8.newEncoder();
            }
        };
    }
}

