/*
 * Decompiled with CFR 0.152.
 */
package io.ticofab.androidgpxparser.parser.domain;

import org.joda.time.DateTime;

public abstract class Point {
    private final Double mLatitude;
    private final Double mLongitude;
    private final Double mElevation;
    private final DateTime mTime;
    private final String mName;
    private final String mDesc;
    private final String mType;

    Point(Builder builder) {
        this.mLatitude = builder.mLatitude;
        this.mLongitude = builder.mLongitude;
        this.mElevation = builder.mElevation;
        this.mTime = builder.mTime;
        this.mName = builder.mName;
        this.mDesc = builder.mDesc;
        this.mType = builder.mType;
    }

    public Double getLatitude() {
        return this.mLatitude;
    }

    public Double getLongitude() {
        return this.mLongitude;
    }

    public Double getElevation() {
        return this.mElevation;
    }

    public DateTime getTime() {
        return this.mTime;
    }

    public String getName() {
        return this.mName;
    }

    public String getDesc() {
        return this.mDesc;
    }

    public String getType() {
        return this.mType;
    }

    public static abstract class Builder {
        private Double mLatitude;
        private Double mLongitude;
        private Double mElevation;
        private DateTime mTime;
        private String mName;
        private String mDesc;
        private String mType;

        public Builder setLatitude(Double latitude) {
            this.mLatitude = latitude;
            return this;
        }

        public Builder setLongitude(Double longitude) {
            this.mLongitude = longitude;
            return this;
        }

        public Builder setElevation(Double elevation) {
            this.mElevation = elevation;
            return this;
        }

        public Builder setTime(DateTime time) {
            this.mTime = time;
            return this;
        }

        public Builder setName(String mame) {
            this.mName = mame;
            return this;
        }

        public Builder setDesc(String desc) {
            this.mDesc = desc;
            return this;
        }

        public Builder setType(String type) {
            this.mType = type;
            return this;
        }

        public abstract Point build();
    }
}

