/*
 * Decompiled with CFR 0.152.
 */
package com.davemorrissey.labs.subscaleview.decoder;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;
import com.davemorrissey.labs.subscaleview.decoder.ImageRegionDecoder;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 (2\u00020\u0001:\u0002()B\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0017H\u0016J\b\u0010!\u001a\u00020\u0015H\u0002J\b\u0010\"\u001a\u00020\u0017H\u0002J\u0018\u0010#\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010$\u001a\u00020\u0019H\u0002J\b\u0010%\u001a\u00020\u0015H\u0016J\b\u0010&\u001a\u00020\u0019H\u0002J\b\u0010'\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/davemorrissey/labs/subscaleview/decoder/SkiaPooledImageRegionDecoder;", "Lcom/davemorrissey/labs/subscaleview/decoder/ImageRegionDecoder;", "()V", "bitmapConfig", "Landroid/graphics/Bitmap$Config;", "(Landroid/graphics/Bitmap$Config;)V", "context", "Landroid/content/Context;", "decoderLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "decoderPool", "Lcom/davemorrissey/labs/subscaleview/decoder/SkiaPooledImageRegionDecoder$DecoderPool;", "fileLength", "", "imageDimensions", "Landroid/graphics/Point;", "lazyInited", "Ljava/util/concurrent/atomic/AtomicBoolean;", "uri", "Landroid/net/Uri;", "allowAdditionalDecoder", "", "numberOfDecoders", "", "debug", "", "message", "", "decodeRegion", "Landroid/graphics/Bitmap;", "sRect", "Landroid/graphics/Rect;", "sampleSize", "getIsLowMemory", "getNumberOfCores", "init", "initialiseDecoder", "isReady", "lazyInit", "recycle", "Companion", "DecoderPool", "subsampling-scale-image-view_release"})
public final class SkiaPooledImageRegionDecoder
implements ImageRegionDecoder {
    private DecoderPool decoderPool = new DecoderPool();
    private final ReentrantReadWriteLock decoderLock = new ReentrantReadWriteLock(true);
    private final Bitmap.Config bitmapConfig;
    private Context context;
    private Uri uri;
    private long fileLength = Long.MAX_VALUE;
    private final Point imageDimensions = new Point(0, 0);
    private final AtomicBoolean lazyInited = new AtomicBoolean(false);
    private static final String TAG;
    private static final String FILE_PREFIX = "file://";
    private static final String ASSET_PREFIX = "file:///android_asset/";
    private static final String RESOURCE_PREFIX = "android.resource://";
    private static boolean debug;
    public static final Companion Companion;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized boolean isReady() {
        if (this.decoderPool == null) return false;
        DecoderPool decoderPool = this.decoderPool;
        if (decoderPool == null) {
            Intrinsics.throwNpe();
        }
        if (decoderPool.getIsEmpty()) return false;
        return true;
    }

    private final int getNumberOfCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    private final boolean getIsLowMemory() {
        Context context = this.context;
        if (context == null) {
            Intrinsics.throwNpe();
        }
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager activityManager = (ActivityManager)object;
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);
        return memoryInfo.lowMemory;
    }

    @Override
    @NotNull
    public Point init(@NotNull Context context, @NotNull Uri uri) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        this.context = context;
        this.uri = uri;
        this.initialiseDecoder();
        return this.imageDimensions;
    }

    private final void lazyInit() {
        if (this.lazyInited.compareAndSet(false, true) && this.fileLength < Long.MAX_VALUE) {
            this.debug("Starting lazy init of additional decoders");
            Thread thread2 = new Thread(this){
                final /* synthetic */ SkiaPooledImageRegionDecoder this$0;

                public void run() {
                    while (SkiaPooledImageRegionDecoder.access$getDecoderPool$p(this.this$0) != null) {
                        DecoderPool decoderPool = SkiaPooledImageRegionDecoder.access$getDecoderPool$p(this.this$0);
                        if (decoderPool == null) {
                            Intrinsics.throwNpe();
                        }
                        if (!SkiaPooledImageRegionDecoder.access$allowAdditionalDecoder(this.this$0, decoderPool.size(), SkiaPooledImageRegionDecoder.access$getFileLength$p(this.this$0))) break;
                        try {
                            if (SkiaPooledImageRegionDecoder.access$getDecoderPool$p(this.this$0) == null) continue;
                            long start = System.currentTimeMillis();
                            SkiaPooledImageRegionDecoder.access$debug(this.this$0, "Starting decoder");
                            SkiaPooledImageRegionDecoder.access$initialiseDecoder(this.this$0);
                            long end = System.currentTimeMillis();
                            SkiaPooledImageRegionDecoder.access$debug(this.this$0, "Started decoder, took " + (end - start) + " ms");
                        }
                        catch (Exception e) {
                            SkiaPooledImageRegionDecoder.access$debug(this.this$0, "Failed to start decoder: " + e.getMessage());
                        }
                    }
                }
                {
                    this.this$0 = $outer;
                }
            };
            thread2.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initialiseDecoder() throws Exception {
        String assetName;
        BitmapRegionDecoder decoder;
        Uri uri = this.uri;
        if (uri == null) {
            Intrinsics.throwNpe();
        }
        String string = uri.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uri!!.toString()");
        String uriString = string;
        long fileLength = Long.MAX_VALUE;
        if (StringsKt.startsWith$default((String)uriString, (String)RESOURCE_PREFIX, (boolean)false, (int)2, null)) {
            List segments;
            int size;
            Resources resources;
            Uri uri2 = this.uri;
            if (uri2 == null) {
                Intrinsics.throwNpe();
            }
            String packageName = uri2.getAuthority();
            Context context = this.context;
            if (context == null) {
                Intrinsics.throwNpe();
            }
            if (Intrinsics.areEqual((Object)context.getPackageName(), (Object)packageName)) {
                Context context2 = this.context;
                if (context2 == null) {
                    Intrinsics.throwNpe();
                }
                resources = context2.getResources();
            } else {
                Context context3 = this.context;
                if (context3 == null) {
                    Intrinsics.throwNpe();
                }
                PackageManager pm = context3.getPackageManager();
                resources = pm.getResourcesForApplication(packageName);
            }
            Resources res = resources;
            int id = 0;
            Uri uri3 = this.uri;
            if (uri3 == null) {
                Intrinsics.throwNpe();
            }
            if ((size = (segments = uri3.getPathSegments()).size()) == 2 && Intrinsics.areEqual((Object)((String)segments.get(0)), (Object)"drawable")) {
                String resName = (String)segments.get(1);
                id = res.getIdentifier(resName, "drawable", packageName);
            } else if (size == 1 && TextUtils.isDigitsOnly((CharSequence)((CharSequence)segments.get(0)))) {
                try {
                    id = Integer.parseInt((String)segments.get(0));
                }
                catch (NumberFormatException resName) {
                    // empty catch block
                }
            }
            try {
                AssetFileDescriptor descriptor;
                Context context4 = this.context;
                if (context4 == null) {
                    Intrinsics.throwNpe();
                }
                AssetFileDescriptor assetFileDescriptor = descriptor = context4.getResources().openRawResourceFd(id);
                Intrinsics.checkExpressionValueIsNotNull((Object)assetFileDescriptor, (String)"descriptor");
                fileLength = assetFileDescriptor.getLength();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Context context5 = this.context;
            if (context5 == null) {
                Intrinsics.throwNpe();
            }
            BitmapRegionDecoder bitmapRegionDecoder = BitmapRegionDecoder.newInstance((InputStream)context5.getResources().openRawResource(id), (boolean)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmapRegionDecoder, (String)"BitmapRegionDecoder.newI\u2026enRawResource(id), false)");
            decoder = bitmapRegionDecoder;
        } else if (StringsKt.startsWith$default((String)uriString, (String)ASSET_PREFIX, (boolean)false, (int)2, null)) {
            String res = uriString;
            int id = ASSET_PREFIX.length();
            String string2 = res;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(id);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            assetName = string3;
            try {
                AssetFileDescriptor descriptor;
                Context context = this.context;
                if (context == null) {
                    Intrinsics.throwNpe();
                }
                AssetFileDescriptor assetFileDescriptor = descriptor = context.getAssets().openFd(assetName);
                Intrinsics.checkExpressionValueIsNotNull((Object)assetFileDescriptor, (String)"descriptor");
                fileLength = assetFileDescriptor.getLength();
            }
            catch (Exception descriptor) {
                // empty catch block
            }
            Context context = this.context;
            if (context == null) {
                Intrinsics.throwNpe();
            }
            BitmapRegionDecoder bitmapRegionDecoder = BitmapRegionDecoder.newInstance((InputStream)context.getAssets().open(assetName, 1), (boolean)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmapRegionDecoder, (String)"BitmapRegionDecoder.newI\u2026er.ACCESS_RANDOM), false)");
            decoder = bitmapRegionDecoder;
        } else if (StringsKt.startsWith$default((String)uriString, (String)FILE_PREFIX, (boolean)false, (int)2, null)) {
            assetName = uriString;
            int descriptor = FILE_PREFIX.length();
            String string4 = assetName;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(descriptor);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            BitmapRegionDecoder bitmapRegionDecoder = BitmapRegionDecoder.newInstance((String)string5, (boolean)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmapRegionDecoder, (String)"BitmapRegionDecoder.newI\u2026LE_PREFIX.length), false)");
            decoder = bitmapRegionDecoder;
            try {
                File file = new File(uriString);
                if (file.exists()) {
                    fileLength = file.length();
                }
            }
            catch (Exception file) {}
        } else {
            InputStream inputStream = null;
            try {
                Context context = this.context;
                if (context == null) {
                    Intrinsics.throwNpe();
                }
                ContentResolver contentResolver = context.getContentResolver();
                Uri uri4 = this.uri;
                if (uri4 == null) {
                    Intrinsics.throwNpe();
                }
                inputStream = contentResolver.openInputStream(uri4);
                BitmapRegionDecoder bitmapRegionDecoder = BitmapRegionDecoder.newInstance((InputStream)inputStream, (boolean)false);
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmapRegionDecoder, (String)"BitmapRegionDecoder.newI\u2026tance(inputStream, false)");
                decoder = bitmapRegionDecoder;
                try {
                    AssetFileDescriptor descriptor;
                    Uri uri5 = this.uri;
                    if (uri5 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((descriptor = contentResolver.openAssetFileDescriptor(uri5, "r")) != null) {
                        fileLength = descriptor.getLength();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                try {
                    InputStream inputStream2 = inputStream;
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        this.fileLength = fileLength;
        this.imageDimensions.set(decoder.getWidth(), decoder.getHeight());
        this.decoderLock.writeLock().lock();
        try {
            DecoderPool decoderPool = this.decoderPool;
            if (decoderPool != null) {
                decoderPool.add(decoder);
            }
        }
        finally {
            this.decoderLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bitmap decodeRegion(@NotNull Rect sRect, int sampleSize) {
        Intrinsics.checkParameterIsNotNull((Object)sRect, (String)"sRect");
        StringBuilder stringBuilder = new StringBuilder().append("Decode region ").append(sRect).append(" on thread ");
        Thread thread2 = Thread.currentThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread2, (String)"Thread.currentThread()");
        this.debug(stringBuilder.append(thread2.getName()).toString());
        if (sRect.width() < this.imageDimensions.x || sRect.height() < this.imageDimensions.y) {
            this.lazyInit();
        }
        this.decoderLock.readLock().lock();
        try {
            if (this.decoderPool != null) {
                BitmapRegionDecoder decoder;
                block15: {
                    DecoderPool decoderPool;
                    Bitmap bitmap;
                    DecoderPool decoderPool2 = this.decoderPool;
                    if (decoderPool2 == null) {
                        Intrinsics.throwNpe();
                    }
                    decoder = decoderPool2.acquire();
                    try {
                        if (decoder == null || decoder.isRecycled()) break block15;
                        BitmapFactory.Options options = new BitmapFactory.Options();
                        options.inSampleSize = sampleSize;
                        options.inPreferredConfig = this.bitmapConfig;
                        Bitmap bitmap2 = decoder.decodeRegion(sRect, options);
                        if (bitmap2 == null) {
                            throw (Throwable)new RuntimeException("Skia image decoder returned null bitmap - image format may not be supported");
                        }
                        bitmap = bitmap2;
                        decoderPool = this.decoderPool;
                    }
                    catch (Throwable throwable) {
                        if (decoder != null) {
                            DecoderPool decoderPool3 = this.decoderPool;
                            if (decoderPool3 == null) {
                                Intrinsics.throwNpe();
                            }
                            decoderPool3.release(decoder);
                        }
                        throw throwable;
                    }
                    if (decoderPool == null) {
                        Intrinsics.throwNpe();
                    }
                    decoderPool.release(decoder);
                    return bitmap;
                }
                if (decoder != null) {
                    DecoderPool decoderPool = this.decoderPool;
                    if (decoderPool == null) {
                        Intrinsics.throwNpe();
                    }
                    decoderPool.release(decoder);
                }
            }
            throw (Throwable)new IllegalStateException("Cannot decode region after decoder has been recycled");
        }
        finally {
            this.decoderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void recycle() {
        this.decoderLock.writeLock().lock();
        try {
            if (this.decoderPool != null) {
                DecoderPool decoderPool = this.decoderPool;
                if (decoderPool == null) {
                    Intrinsics.throwNpe();
                }
                decoderPool.recycle();
                this.decoderPool = null;
                this.context = null;
                this.uri = null;
            }
        }
        finally {
            this.decoderLock.writeLock().unlock();
        }
    }

    private final boolean allowAdditionalDecoder(int numberOfDecoders, long fileLength) {
        boolean bl;
        if (numberOfDecoders >= 4) {
            this.debug("No additional decoders allowed, reached hard limit (4)");
            bl = false;
        } else if ((long)numberOfDecoders * fileLength > (long)0x1400000) {
            this.debug("No additional encoders allowed, reached hard memory limit (20Mb)");
            bl = false;
        } else if (numberOfDecoders >= this.getNumberOfCores()) {
            this.debug("No additional encoders allowed, limited by CPU cores (" + this.getNumberOfCores() + ')');
            bl = false;
        } else if (this.getIsLowMemory()) {
            this.debug("No additional encoders allowed, memory is low");
            bl = false;
        } else {
            this.debug("Additional decoder allowed, current count is " + numberOfDecoders + ", estimated native memory " + fileLength * (long)numberOfDecoders / (long)0x100000 + " Mb");
            bl = true;
        }
        return bl;
    }

    private final void debug(String message) {
        if (debug) {
            Log.d((String)TAG, (String)message);
        }
    }

    public SkiaPooledImageRegionDecoder(@Nullable Bitmap.Config bitmapConfig) {
        Bitmap.Config globalBitmapConfig = SubsamplingScaleImageView.Companion.getPreferredBitmapConfig();
        this.bitmapConfig = bitmapConfig != null ? bitmapConfig : (globalBitmapConfig != null ? globalBitmapConfig : Bitmap.Config.RGB_565);
    }

    @Keep
    public SkiaPooledImageRegionDecoder() {
        this(null);
    }

    static {
        Companion = new Companion(null);
        TAG = SkiaPooledImageRegionDecoder.class.getSimpleName();
        FILE_PREFIX = FILE_PREFIX;
        ASSET_PREFIX = FILE_PREFIX + "/android_asset/";
        RESOURCE_PREFIX = RESOURCE_PREFIX;
    }

    @Nullable
    public static final /* synthetic */ DecoderPool access$getDecoderPool$p(SkiaPooledImageRegionDecoder $this) {
        return $this.decoderPool;
    }

    public static final /* synthetic */ void access$setDecoderPool$p(SkiaPooledImageRegionDecoder $this, @Nullable DecoderPool decoderPool) {
        $this.decoderPool = decoderPool;
    }

    public static final /* synthetic */ boolean access$allowAdditionalDecoder(SkiaPooledImageRegionDecoder $this, int numberOfDecoders, long fileLength) {
        return $this.allowAdditionalDecoder(numberOfDecoders, fileLength);
    }

    public static final /* synthetic */ long access$getFileLength$p(SkiaPooledImageRegionDecoder $this) {
        return $this.fileLength;
    }

    public static final /* synthetic */ void access$setFileLength$p(SkiaPooledImageRegionDecoder $this, long l) {
        $this.fileLength = l;
    }

    public static final /* synthetic */ void access$debug(SkiaPooledImageRegionDecoder $this, @NotNull String message) {
        $this.debug(message);
    }

    public static final /* synthetic */ void access$initialiseDecoder(SkiaPooledImageRegionDecoder $this) {
        $this.initialiseDecoder();
    }

    public static final /* synthetic */ boolean access$getDebug$cp() {
        return debug;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007J\u0006\u0010\u0010\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0007J\u0006\u0010\u0012\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007J\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/davemorrissey/labs/subscaleview/decoder/SkiaPooledImageRegionDecoder$DecoderPool;", "", "()V", "available", "Ljava/util/concurrent/Semaphore;", "decoders", "Ljava/util/concurrent/ConcurrentHashMap;", "Landroid/graphics/BitmapRegionDecoder;", "", "nextAvailable", "getNextAvailable", "()Landroid/graphics/BitmapRegionDecoder;", "acquire", "add", "", "decoder", "getIsEmpty", "markAsUnused", "recycle", "release", "size", "", "subsampling-scale-image-view_release"})
    public static final class DecoderPool {
        private final Semaphore available = new Semaphore(0, true);
        private final ConcurrentHashMap<BitmapRegionDecoder, Boolean> decoders = new ConcurrentHashMap();

        public final synchronized boolean getIsEmpty() {
            return this.decoders.isEmpty();
        }

        private final synchronized BitmapRegionDecoder getNextAvailable() {
            for (Map.Entry<BitmapRegionDecoder, Boolean> entry : this.decoders.entrySet()) {
                if (entry.getValue().booleanValue()) continue;
                entry.setValue(true);
                return entry.getKey();
            }
            return null;
        }

        public final synchronized int size() {
            return this.decoders.size();
        }

        @Nullable
        public final BitmapRegionDecoder acquire() {
            this.available.acquireUninterruptibly();
            return this.getNextAvailable();
        }

        public final void release(@NotNull BitmapRegionDecoder decoder) {
            Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
            if (this.markAsUnused(decoder)) {
                this.available.release();
            }
        }

        public final synchronized void add(@NotNull BitmapRegionDecoder decoder) {
            Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
            Map map = this.decoders;
            Boolean bl = false;
            map.put(decoder, bl);
            this.available.release();
        }

        public final synchronized void recycle() {
            while (!this.decoders.isEmpty()) {
                BitmapRegionDecoder decoder;
                BitmapRegionDecoder bitmapRegionDecoder = decoder = this.acquire();
                if (bitmapRegionDecoder == null) {
                    Intrinsics.throwNpe();
                }
                bitmapRegionDecoder.recycle();
                this.decoders.remove(decoder);
            }
        }

        public final synchronized boolean markAsUnused(@NotNull BitmapRegionDecoder decoder) {
            Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
            for (Map.Entry<BitmapRegionDecoder, Boolean> entry : this.decoders.entrySet()) {
                boolean bl;
                if (!Intrinsics.areEqual((Object)decoder, (Object)entry.getKey())) continue;
                Boolean bl2 = entry.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)bl2, (String)"entry.value");
                if (bl2.booleanValue()) {
                    entry.setValue(false);
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/davemorrissey/labs/subscaleview/decoder/SkiaPooledImageRegionDecoder$Companion;", "", "()V", "ASSET_PREFIX", "", "FILE_PREFIX", "RESOURCE_PREFIX", "TAG", "kotlin.jvm.PlatformType", "debug", "", "setDebug", "", "subsampling-scale-image-view_release"})
    public static final class Companion {
        public final void setDebug(boolean debug) {
            debug = debug;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

