/*
 * Decompiled with CFR 0.152.
 */
package com.davemorrissey.labs.subscaleview;

import android.content.Context;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import com.davemorrissey.labs.subscaleview.ImageSource;
import com.davemorrissey.labs.subscaleview.decoder.CompatDecoderFactory;
import com.davemorrissey.labs.subscaleview.decoder.DecoderFactory;
import com.davemorrissey.labs.subscaleview.decoder.ImageDecoder;
import com.davemorrissey.labs.subscaleview.decoder.ImageRegionDecoder;
import com.davemorrissey.labs.subscaleview.decoder.SkiaImageDecoder;
import com.davemorrissey.labs.subscaleview.decoder.SkiaImageRegionDecoder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00f8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b4\b\u0016\u0018\u0000 \u00fd\u00012\u00020\u0001:\u0014\u00fa\u0001\u00fb\u0001\u00fc\u0001\u00fd\u0001\u00fe\u0001\u00ff\u0001\u0080\u0002\u0081\u0002\u0082\u0002\u0083\u0002B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010y\u001a\b\u0018\u00010zR\u00020\u00002\u0006\u0010h\u001a\u00020!2\u0006\u0010{\u001a\u00020\u0016J\u0010\u0010|\u001a\u00020,2\u0006\u0010h\u001a\u00020!H\u0002J\b\u0010}\u001a\u00020\u0011H\u0002J\b\u0010~\u001a\u00020\u0011H\u0002J\t\u0010\u007f\u001a\u00030\u0080\u0001H\u0002J\u0013\u0010\u0019\u001a\u00030\u0080\u00012\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001H\u0002J-\u0010\u0083\u0001\u001a\u00020!2\u0007\u0010\u0084\u0001\u001a\u00020!2\u0007\u0010\u0085\u0001\u001a\u00020!2\u0007\u0010\u0086\u0001\u001a\u00020!2\u0007\u0010\u0087\u0001\u001a\u00020!H\u0002J\u001f\u0010\u0088\u0001\u001a\u00030\u0080\u00012\b\u0010{\u001a\u0004\u0018\u00010\u00162\t\u0010\u0089\u0001\u001a\u0004\u0018\u00010\u0016H\u0002J6\u0010\u008a\u0001\u001a\u00020!2\u0007\u0010\u008b\u0001\u001a\u00020,2\u0007\u0010\u008c\u0001\u001a\u00020\b2\u0007\u0010\u008d\u0001\u001a\u00020!2\u0007\u0010\u008e\u0001\u001a\u00020!2\u0007\u0010\u008f\u0001\u001a\u00020\bH\u0002J-\u0010\u0090\u0001\u001a\u00020!2\u0007\u0010\u008c\u0001\u001a\u00020\b2\u0007\u0010\u008d\u0001\u001a\u00020!2\u0007\u0010\u008e\u0001\u001a\u00020!2\u0007\u0010\u008f\u0001\u001a\u00020\bH\u0002J-\u0010\u0091\u0001\u001a\u00020!2\u0007\u0010\u008c\u0001\u001a\u00020\b2\u0007\u0010\u008d\u0001\u001a\u00020!2\u0007\u0010\u008e\u0001\u001a\u00020!2\u0007\u0010\u008f\u0001\u001a\u00020\bH\u0002J&\u0010\u0092\u0001\u001a\u00030\u0080\u00012\u001a\u0010\u0093\u0001\u001a\u0015\u0012\u0005\u0012\u00030\u0095\u0001\u0012\u0005\u0012\u00030\u0095\u0001\u0012\u0002\b\u00030\u0094\u0001H\u0002J\u001f\u0010\u0096\u0001\u001a\u00030\u0080\u00012\b\u0010_\u001a\u0004\u0018\u00010K2\t\u0010\u0097\u0001\u001a\u0004\u0018\u00010KH\u0002J\u0012\u0010\u0098\u0001\u001a\u00030\u0080\u00012\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\u001b\u0010\u0098\u0001\u001a\u00030\u0080\u00012\u0006\u0010\u0015\u001a\u00020\u00112\u0007\u0010\u0099\u0001\u001a\u00020gH\u0002J\u001b\u0010\u009a\u0001\u001a\u00020,2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u009b\u0001\u001a\u00030\u0082\u0001H\u0002J\u0014\u0010\u009c\u0001\u001a\u00030\u009d\u00012\b\u0010\u009e\u0001\u001a\u00030\u009f\u0001H\u0002J\u0007\u0010\u00a0\u0001\u001a\u00020!J\u0007\u0010\u00a1\u0001\u001a\u00020,J\u0014\u0010\u00a2\u0001\u001a\u00030\u0080\u00012\b\u0010\u00a3\u0001\u001a\u00030\u009d\u0001H\u0002J\u0014\u0010\u00a4\u0001\u001a\u00030\u0080\u00012\b\u0010\u00a3\u0001\u001a\u00030\u009d\u0001H\u0002J,\u0010\u00a5\u0001\u001a\u00020\u00162\u0007\u0010\u00a6\u0001\u001a\u00020!2\u0007\u0010\u00a7\u0001\u001a\u00020!2\u0006\u0010h\u001a\u00020!2\u0007\u0010\u00a8\u0001\u001a\u00020\u0016H\u0002J\u0012\u0010\u00a9\u0001\u001a\u00020!2\u0007\u0010\u00aa\u0001\u001a\u00020!H\u0002J\b\u0010C\u001a\u00020!H\u0002J\u0014\u0010\u00ab\u0001\u001a\u00030\u0080\u00012\b\u0010\u009e\u0001\u001a\u00030\u009f\u0001H\u0014J\n\u0010\u00ac\u0001\u001a\u00030\u0080\u0001H\u0004J$\u0010\u00ac\u0001\u001a\u00030\u0080\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010]\u001a\u00020,2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u00ad\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u00ae\u0001\u001a\u00020,2\u0007\u0010\u00af\u0001\u001a\u00020,H\u0014J\u0015\u0010\u00b0\u0001\u001a\u00030\u0080\u00012\t\u0010\u00b1\u0001\u001a\u0004\u0018\u00010\fH\u0002J\n\u0010\u00b2\u0001\u001a\u00030\u0080\u0001H\u0004J.\u0010\u00b3\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u00b4\u0001\u001a\u00020,2\u0007\u0010\u00b5\u0001\u001a\u00020,2\u0007\u0010\u00b6\u0001\u001a\u00020,2\u0007\u0010\u00b7\u0001\u001a\u00020,H\u0014J\n\u0010\u00b8\u0001\u001a\u00030\u0080\u0001H\u0002J*\u0010\u00b9\u0001\u001a\u00030\u0080\u00012\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010c\u001a\u00020,2\u0006\u0010Y\u001a\u00020,2\u0006\u0010]\u001a\u00020,H\u0002J\u0013\u0010\u00ba\u0001\u001a\u00020\u00112\b\u0010\u00bb\u0001\u001a\u00030\u00bc\u0001H\u0016J\u0013\u0010\u00bd\u0001\u001a\u00020\u00112\b\u0010\u00bb\u0001\u001a\u00030\u00bc\u0001H\u0002J\n\u0010\u00be\u0001\u001a\u00030\u0080\u0001H\u0002J\u0012\u0010\u00bf\u0001\u001a\u00020,2\u0007\u0010\u00bf\u0001\u001a\u00020,H\u0002J\b\u0010\u00c0\u0001\u001a\u00030\u0080\u0001J\u0013\u0010\u00c1\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u00c2\u0001\u001a\u00020\u0011H\u0002J\u0013\u0010\u00c3\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u00c4\u0001\u001a\u00020\u0011H\u0002J\b\u0010\u00c5\u0001\u001a\u00030\u0080\u0001J\b\u0010Y\u001a\u00020,H\u0002J\b\u0010c\u001a\u00020,H\u0002J\u0018\u0010\u00c6\u0001\u001a\u00030\u0080\u00012\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eJ\u0010\u0010\u00c7\u0001\u001a\u00030\u0080\u00012\u0006\u0010\u0019\u001a\u00020\u0011J\u0011\u0010\u00c8\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u00c9\u0001\u001a\u00020,J\u0010\u0010\u00ca\u0001\u001a\u00030\u0080\u00012\u0006\u0010$\u001a\u00020!J\u0010\u0010\u00cb\u0001\u001a\u00030\u0080\u00012\u0006\u0010'\u001a\u00020\u0011J\u0010\u0010\u00cc\u0001\u001a\u00030\u0080\u00012\u0006\u0010(\u001a\u00020)J\u0012\u0010\u00cd\u0001\u001a\u00030\u0080\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0012\u0010\u00ce\u0001\u001a\u00030\u0080\u00012\b\u0010\u00cf\u0001\u001a\u00030\u00d0\u0001J \u0010\u00ce\u0001\u001a\u00030\u0080\u00012\b\u0010\u00cf\u0001\u001a\u00030\u00d0\u00012\f\b\u0002\u0010\u00d1\u0001\u001a\u0005\u0018\u00010\u00d0\u0001J[\u0010\u00d2\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u00d3\u0001\u001a\u00020&2\u0007\u0010\u00d4\u0001\u001a\u00020!2\u0007\u0010\u00d5\u0001\u001a\u00020!2\u0007\u0010\u00d6\u0001\u001a\u00020!2\u0007\u0010\u00d7\u0001\u001a\u00020!2\u0007\u0010\u00d8\u0001\u001a\u00020!2\u0007\u0010\u00d9\u0001\u001a\u00020!2\u0007\u0010\u00da\u0001\u001a\u00020!2\u0007\u0010\u00db\u0001\u001a\u00020!H\u0002J\u0011\u0010\u00dc\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u00dd\u0001\u001a\u00020,J\u001a\u0010\u00dc\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u00de\u0001\u001a\u00020,2\u0007\u0010\u00df\u0001\u001a\u00020,J\u0011\u0010\u00e0\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u00c9\u0001\u001a\u00020,J\u0010\u0010\u00e1\u0001\u001a\u00030\u0080\u00012\u0006\u0010C\u001a\u00020!J\u0011\u0010\u00e2\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u00c9\u0001\u001a\u00020,J\u0010\u0010\u00e3\u0001\u001a\u00030\u0080\u00012\u0006\u0010D\u001a\u00020,J\u0010\u0010\u00e4\u0001\u001a\u00030\u0080\u00012\u0006\u0010G\u001a\u00020HJ\u0010\u0010\u00e5\u0001\u001a\u00030\u0080\u00012\u0006\u0010I\u001a\u00020,J\u0016\u0010\u00e6\u0001\u001a\u00030\u0080\u00012\f\u0010T\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000eJ\u0010\u0010\u00e7\u0001\u001a\u00030\u0080\u00012\u0006\u0010X\u001a\u00020\u0011J\u001a\u0010\u00e8\u0001\u001a\u00030\u0080\u00012\u0006\u0010h\u001a\u00020!2\b\u0010{\u001a\u0004\u0018\u00010\u0016J\u0012\u0010\u00e9\u0001\u001a\u0004\u0018\u00010\u00162\u0007\u0010\u00ea\u0001\u001a\u00020\u0016J\u001b\u0010\u00e9\u0001\u001a\u0004\u0018\u00010\u00162\u0007\u0010\u00ea\u0001\u001a\u00020\u00162\u0007\u0010\u00eb\u0001\u001a\u00020\u0016J(\u0010\u00e9\u0001\u001a\u0004\u0018\u00010\u00162\u0007\u0010\u00ec\u0001\u001a\u00020!2\u0007\u0010\u00ed\u0001\u001a\u00020!2\t\b\u0002\u0010\u00eb\u0001\u001a\u00020\u0016H\u0007J\u001b\u0010\u00ee\u0001\u001a\u00030\u0080\u00012\u0006\u0010_\u001a\u00020K2\u0007\u0010\u00eb\u0001\u001a\u00020KH\u0002J\u0012\u0010\u00ef\u0001\u001a\u00020!2\u0007\u0010\u00ec\u0001\u001a\u00020!H\u0002J\u0012\u0010\u00f0\u0001\u001a\u00020!2\u0007\u0010\u00ed\u0001\u001a\u00020!H\u0002J\u0012\u0010\u00f1\u0001\u001a\u00020\u00112\u0007\u0010\u00f2\u0001\u001a\u00020qH\u0002J#\u0010\u00f3\u0001\u001a\u00020\u00162\u0007\u0010\u00a6\u0001\u001a\u00020!2\u0007\u0010\u00a7\u0001\u001a\u00020!2\u0006\u0010h\u001a\u00020!H\u0002J\u0012\u0010\u00f4\u0001\u001a\u0004\u0018\u00010\u00162\u0007\u0010\u00f5\u0001\u001a\u00020\u0016J(\u0010\u00f4\u0001\u001a\u0004\u0018\u00010\u00162\u0007\u0010\u00f6\u0001\u001a\u00020!2\u0007\u0010\u00f7\u0001\u001a\u00020!2\t\b\u0002\u0010\u00a8\u0001\u001a\u00020\u0016H\u0007J\u0012\u0010\u00f8\u0001\u001a\u00020!2\u0007\u0010\u00f6\u0001\u001a\u00020!H\u0002J\u0012\u0010\u00f9\u0001\u001a\u00020!2\u0007\u0010\u00f7\u0001\u001a\u00020!H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\n **\u0004\u0018\u00010)0)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010.\"\u0004\b0\u00101R\u000e\u00102\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010.\"\u0004\b4\u00101R\u000e\u00105\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00106\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010.\"\u0004\b7\u00101R\u001a\u00108\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010.\"\u0004\b9\u00101R\u000e\u0010:\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010;\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u000e\u0010@\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010E\u001a\u0004\u0018\u00010FX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010G\u001a\u0004\u0018\u00010HX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010J\u001a\u0004\u0018\u00010KX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010L\u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010MR\u000e\u0010N\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010P\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010R\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010S\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010T\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010U\u001a\u00020,8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bV\u0010WR\u000e\u0010X\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010Y\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010W\"\u0004\b[\u0010\\R\u000e\u0010]\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010^\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010_\u001a\u0004\u0018\u00010`X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010a\u001a\u0004\u0018\u00010KX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010b\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010c\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010W\"\u0004\be\u0010\\R\u0010\u0010f\u001a\u0004\u0018\u00010gX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010h\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bi\u0010=\"\u0004\bj\u0010?R\u000e\u0010k\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010l\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010m\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010n\u001a\u0016\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u00020q0p\u0018\u00010oX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010r\u001a\u0004\u0018\u00010sX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010t\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010u\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010v\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010w\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010x\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0084\u0002"}, d2={"Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attr", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "DOUBLE_TAP_ZOOM_DURATION", "", "anim", "Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView$Anim;", "bitmap", "Landroid/graphics/Bitmap;", "bitmapDecoderFactory", "Lcom/davemorrissey/labs/subscaleview/decoder/DecoderFactory;", "Lcom/davemorrissey/labs/subscaleview/decoder/ImageDecoder;", "bitmapIsCached", "", "bitmapIsPreview", "bitmapPaint", "Landroid/graphics/Paint;", "center", "Landroid/graphics/PointF;", "getCenter", "()Landroid/graphics/PointF;", "debug", "debugLinePaint", "debugTextPaint", "decoder", "Lcom/davemorrissey/labs/subscaleview/decoder/ImageRegionDecoder;", "decoderLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "density", "", "detector", "Landroid/view/GestureDetector;", "doubleTapZoomScale", "dstArray", "", "eagerLoadingEnabled", "executor", "Ljava/util/concurrent/Executor;", "kotlin.jvm.PlatformType", "fullImageSampleSize", "", "isBaseLayerReady", "()Z", "isImageLoaded", "setImageLoaded", "(Z)V", "isPanning", "isQuickScaleEnabled", "setQuickScaleEnabled", "isQuickScaling", "isReady", "setReady", "isZoomEnabled", "setZoomEnabled", "isZooming", "maxScale", "getMaxScale", "()F", "setMaxScale", "(F)V", "maxTileHeight", "maxTileWidth", "maxTouchCount", "minScale", "minimumTileDpi", "objectMatrix", "Landroid/graphics/Matrix;", "onImageEventListener", "Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView$OnImageEventListener;", "orientation", "pRegion", "Landroid/graphics/Rect;", "pendingScale", "Ljava/lang/Float;", "quickScaleLastDistance", "quickScaleMoved", "quickScaleSCenter", "quickScaleThreshold", "quickScaleVLastPoint", "quickScaleVStart", "regionDecoderFactory", "requiredRotation", "getRequiredRotation", "()I", "resetScaleOnSizeChange", "sHeight", "getSHeight", "setSHeight", "(I)V", "sOrientation", "sPendingCenter", "sRect", "Landroid/graphics/RectF;", "sRegion", "sRequestedCenter", "sWidth", "getSWidth", "setSWidth", "satTemp", "Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView$ScaleAndTranslate;", "scale", "getScale", "setScale", "scaleStart", "singleDetector", "srcArray", "tileMap", "", "", "Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView$Tile;", "uri", "Landroid/net/Uri;", "vCenterStart", "vDistStart", "vTranslate", "vTranslateBefore", "vTranslateStart", "animateScaleAndCenter", "Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView$AnimationBuilder;", "sCenter", "calculateInSampleSize", "checkImageLoaded", "checkReady", "createPaints", "", "message", "", "distance", "x0", "x1", "y0", "y1", "doubleTapZoom", "vFocus", "ease", "type", "time", "from", "change", "duration", "easeInOutQuad", "easeOutQuad", "execute", "asyncTask", "Landroid/os/AsyncTask;", "Ljava/lang/Void;", "fileSRect", "target", "fitToBounds", "sat", "getExifOrientation", "sourceUri", "getMaxBitmapDimensions", "Landroid/graphics/Point;", "canvas", "Landroid/graphics/Canvas;", "getMinScale", "getOrientation", "initialiseBaseLayer", "maxTileDimensions", "initialiseTileMap", "limitedSCenter", "sCenterX", "sCenterY", "sTarget", "limitedScale", "targetScale", "onDraw", "onImageLoaded", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onPreviewLoaded", "previewBitmap", "onReady", "onSizeChanged", "w", "h", "oldw", "oldh", "onTileLoaded", "onTilesInited", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "onTouchEventInternal", "preDraw", "px", "recycle", "refreshRequiredTiles", "load", "reset", "newImage", "resetScaleAndCenter", "setBitmapDecoderFactory", "setDebug", "setDoubleTapZoomDpi", "dpi", "setDoubleTapZoomScale", "setEagerLoadingEnabled", "setExecutor", "setGestureDetector", "setImage", "imageSource", "Lcom/davemorrissey/labs/subscaleview/ImageSource;", "previewSource", "setMatrixArray", "array", "f0", "f1", "f2", "f3", "f4", "f5", "f6", "f7", "setMaxTileSize", "maxPixels", "maxPixelsX", "maxPixelsY", "setMaximumDpi", "setMinScale", "setMinimumDpi", "setMinimumTileDpi", "setOnImageEventListener", "setOrientation", "setRegionDecoderFactory", "setResetScaleOnSizeChange", "setScaleAndCenter", "sourceToViewCoord", "sxy", "vTarget", "sx", "sy", "sourceToViewRect", "sourceToViewX", "sourceToViewY", "tileVisible", "tile", "vTranslateForSCenter", "viewToSourceCoord", "vxy", "vx", "vy", "viewToSourceX", "viewToSourceY", "Anim", "AnimationBuilder", "BitmapLoadTask", "Companion", "DefaultOnImageEventListener", "OnImageEventListener", "ScaleAndTranslate", "Tile", "TileLoadTask", "TilesInitTask", "subsampling-scale-image-view_release"})
public class SubsamplingScaleImageView
extends View {
    private Bitmap bitmap;
    private boolean bitmapIsPreview;
    private boolean bitmapIsCached;
    private Uri uri;
    private int fullImageSampleSize;
    private Map<Integer, List<Tile>> tileMap;
    private boolean debug;
    private int orientation;
    private float maxScale;
    private float minScale;
    private int minimumTileDpi;
    private int maxTileWidth;
    private int maxTileHeight;
    private Executor executor;
    private boolean eagerLoadingEnabled;
    private boolean isZoomEnabled;
    private boolean isQuickScaleEnabled;
    private final long DOUBLE_TAP_ZOOM_DURATION = 500L;
    private float doubleTapZoomScale;
    private float scale;
    private float scaleStart;
    private PointF vTranslate;
    private PointF vTranslateStart;
    private PointF vTranslateBefore;
    private Float pendingScale;
    private PointF sPendingCenter;
    private PointF sRequestedCenter;
    private int sWidth;
    private int sHeight;
    private int sOrientation;
    private Rect sRegion;
    private Rect pRegion;
    private boolean isZooming;
    private boolean isPanning;
    private boolean isQuickScaling;
    private int maxTouchCount;
    private boolean resetScaleOnSizeChange;
    private GestureDetector detector;
    private GestureDetector singleDetector;
    private ImageRegionDecoder decoder;
    private final ReentrantReadWriteLock decoderLock;
    private DecoderFactory<? extends ImageDecoder> bitmapDecoderFactory;
    private DecoderFactory<? extends ImageRegionDecoder> regionDecoderFactory;
    private PointF vCenterStart;
    private float vDistStart;
    private final float quickScaleThreshold;
    private float quickScaleLastDistance;
    private boolean quickScaleMoved;
    private PointF quickScaleVLastPoint;
    private PointF quickScaleSCenter;
    private PointF quickScaleVStart;
    private Anim anim;
    private boolean isReady;
    private boolean isImageLoaded;
    private OnImageEventListener onImageEventListener;
    private Paint bitmapPaint;
    private Paint debugTextPaint;
    private Paint debugLinePaint;
    private ScaleAndTranslate satTemp;
    private Matrix objectMatrix;
    private RectF sRect;
    private final float[] srcArray;
    private final float[] dstArray;
    private final float density;
    private static final String TAG;
    public static final int ORIENTATION_USE_EXIF = -1;
    public static final int ORIENTATION_0 = 0;
    public static final int ORIENTATION_90 = 90;
    public static final int ORIENTATION_180 = 180;
    public static final int ORIENTATION_270 = 270;
    private static final List<Integer> VALID_ORIENTATIONS;
    public static final int EASE_OUT_QUAD = 1;
    public static final int EASE_IN_OUT_QUAD = 2;
    private static final List<Integer> VALID_EASING_STYLES;
    public static final int ORIGIN_ANIM = 1;
    public static final int ORIGIN_FLING = 2;
    public static final int ORIGIN_DOUBLE_TAP_ZOOM = 3;
    public static final int TILE_SIZE_AUTO = Integer.MAX_VALUE;
    @Nullable
    private static Bitmap.Config preferredBitmapConfig;
    public static final Companion Companion;

    public final float getMaxScale() {
        return this.maxScale;
    }

    public final void setMaxScale(float f) {
        this.maxScale = f;
    }

    public final boolean isZoomEnabled() {
        return this.isZoomEnabled;
    }

    public final void setZoomEnabled(boolean bl) {
        this.isZoomEnabled = bl;
    }

    public final boolean isQuickScaleEnabled() {
        return this.isQuickScaleEnabled;
    }

    public final void setQuickScaleEnabled(boolean bl) {
        this.isQuickScaleEnabled = bl;
    }

    public final float getScale() {
        return this.scale;
    }

    public final void setScale(float f) {
        this.scale = f;
    }

    public final int getSWidth() {
        return this.sWidth;
    }

    public final void setSWidth(int n) {
        this.sWidth = n;
    }

    public final int getSHeight() {
        return this.sHeight;
    }

    public final void setSHeight(int n) {
        this.sHeight = n;
    }

    public final boolean isReady() {
        return this.isReady;
    }

    public final void setReady(boolean bl) {
        this.isReady = bl;
    }

    public final boolean isImageLoaded() {
        return this.isImageLoaded;
    }

    public final void setImageLoaded(boolean bl) {
        this.isImageLoaded = bl;
    }

    private final boolean isBaseLayerReady() {
        if (this.bitmap != null && !this.bitmapIsPreview) {
            return true;
        }
        if (this.tileMap != null) {
            boolean baseLayerReady = true;
            Map<Integer, List<Tile>> map = this.tileMap;
            if (map == null) {
                Intrinsics.throwNpe();
            }
            Map<Integer, List<Tile>> map2 = map;
            Iterator<Map.Entry<Integer, List<Tile>>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, List<Tile>> entry;
                Map.Entry<Integer, List<Tile>> entry2 = entry = iterator.next();
                int key = ((Number)entry2.getKey()).intValue();
                entry2 = entry;
                List<Tile> value = entry2.getValue();
                if (key != this.fullImageSampleSize) continue;
                for (Tile tile : value) {
                    if (!tile.getLoading() && tile.getBitmap() != null) continue;
                    baseLayerReady = false;
                }
            }
            return baseLayerReady;
        }
        return false;
    }

    private final int getRequiredRotation() {
        return this.orientation == -1 ? this.sOrientation : this.orientation;
    }

    @Nullable
    public final PointF getCenter() {
        int mX = this.getWidth() / 2;
        int mY = this.getHeight() / 2;
        return SubsamplingScaleImageView.viewToSourceCoord$default(this, mX, mY, null, 4, null);
    }

    public final void setOrientation(int orientation) {
        if (!VALID_ORIENTATIONS.contains(orientation)) {
            throw (Throwable)new IllegalArgumentException("Invalid orientation: " + orientation);
        }
        this.orientation = orientation;
        this.reset(false);
        this.invalidate();
        this.requestLayout();
    }

    public final void setImage(@NotNull ImageSource imageSource) {
        Intrinsics.checkParameterIsNotNull((Object)imageSource, (String)"imageSource");
        this.setImage(imageSource, null);
    }

    public final void setImage(@NotNull ImageSource imageSource, @Nullable ImageSource previewSource) {
        Intrinsics.checkParameterIsNotNull((Object)imageSource, (String)"imageSource");
        this.reset(true);
        if (previewSource != null) {
            if (imageSource.getBitmap() != null) {
                throw (Throwable)new IllegalArgumentException("Preview image cannot be used when a bitmap is provided for the main image");
            }
            if (imageSource.getSWidth() <= 0 || imageSource.getSHeight() <= 0) {
                throw (Throwable)new IllegalArgumentException("Preview image cannot be used unless dimensions are provided for the main image");
            }
            this.sWidth = imageSource.getSWidth();
            this.sHeight = imageSource.getSHeight();
            this.pRegion = previewSource.getSRegion();
            if (previewSource.getBitmap() != null) {
                this.bitmapIsCached = previewSource.isCached();
                this.onPreviewLoaded(previewSource.getBitmap());
            } else {
                Uri uri = previewSource.getUri();
                if (uri == null && previewSource.getResource() != null) {
                    StringBuilder stringBuilder = new StringBuilder().append("android.resource://");
                    Context context = this.getContext();
                    Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                    uri = Uri.parse((String)stringBuilder.append(context.getPackageName()).append('/').append(previewSource.getResource()).toString());
                }
                Context context = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                Uri uri2 = uri;
                if (uri2 == null) {
                    Intrinsics.throwNpe();
                }
                BitmapLoadTask task = new BitmapLoadTask(this, context, this.bitmapDecoderFactory, uri2, true);
                this.execute(task);
            }
        }
        if (imageSource.getBitmap() != null && imageSource.getSRegion() != null) {
            Bitmap bitmap = imageSource.getBitmap();
            Rect rect = imageSource.getSRegion();
            if (rect == null) {
                Intrinsics.throwNpe();
            }
            int n = rect.left;
            Rect rect2 = imageSource.getSRegion();
            if (rect2 == null) {
                Intrinsics.throwNpe();
            }
            int n2 = rect2.top;
            Rect rect3 = imageSource.getSRegion();
            if (rect3 == null) {
                Intrinsics.throwNpe();
            }
            int n3 = rect3.width();
            Rect rect4 = imageSource.getSRegion();
            if (rect4 == null) {
                Intrinsics.throwNpe();
            }
            this.onImageLoaded(Bitmap.createBitmap((Bitmap)bitmap, (int)n, (int)n2, (int)n3, (int)rect4.height()), 0, false);
        } else if (imageSource.getBitmap() != null) {
            this.onImageLoaded(imageSource.getBitmap(), 0, imageSource.isCached());
        } else {
            AsyncTask task;
            this.sRegion = imageSource.getSRegion();
            this.uri = imageSource.getUri();
            if (this.uri == null && imageSource.getResource() != null) {
                StringBuilder stringBuilder = new StringBuilder().append("android.resource://");
                Context context = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                this.uri = Uri.parse((String)stringBuilder.append(context.getPackageName()).append('/').append(imageSource.getResource()).toString());
            }
            if (imageSource.getTile() || this.sRegion != null) {
                Context context = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                Uri uri = this.uri;
                if (uri == null) {
                    Intrinsics.throwNpe();
                }
                task = new TilesInitTask(this, context, this.regionDecoderFactory, uri);
                this.execute((AsyncTask)task);
            } else {
                Context context = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                Uri uri = this.uri;
                if (uri == null) {
                    Intrinsics.throwNpe();
                }
                task = new BitmapLoadTask(this, context, this.bitmapDecoderFactory, uri, false);
                this.execute(task);
            }
        }
    }

    public static /* synthetic */ void setImage$default(SubsamplingScaleImageView subsamplingScaleImageView, ImageSource imageSource, ImageSource imageSource2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setImage");
        }
        if ((n & 2) != 0) {
            imageSource2 = null;
        }
        subsamplingScaleImageView.setImage(imageSource, imageSource2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reset(boolean newImage) {
        this.debug("reset newImage=" + newImage);
        this.scale = 0.0f;
        this.scaleStart = 0.0f;
        this.vTranslate = null;
        this.vTranslateStart = null;
        this.vTranslateBefore = null;
        this.pendingScale = Float.valueOf(0.0f);
        this.sPendingCenter = null;
        this.sRequestedCenter = null;
        this.isZooming = false;
        this.isPanning = false;
        this.isQuickScaling = false;
        this.maxTouchCount = 0;
        this.fullImageSampleSize = 0;
        this.vCenterStart = null;
        this.vDistStart = 0.0f;
        this.quickScaleLastDistance = 0.0f;
        this.quickScaleMoved = false;
        this.quickScaleSCenter = null;
        this.quickScaleVLastPoint = null;
        this.quickScaleVStart = null;
        this.anim = null;
        this.satTemp = null;
        this.objectMatrix = null;
        this.sRect = null;
        if (newImage) {
            this.uri = null;
            this.decoderLock.writeLock().lock();
            try {
                ImageRegionDecoder imageRegionDecoder = this.decoder;
                if (imageRegionDecoder != null) {
                    imageRegionDecoder.recycle();
                }
                this.decoder = null;
            }
            finally {
                this.decoderLock.writeLock().unlock();
            }
            if (!this.bitmapIsCached) {
                Bitmap bitmap = this.bitmap;
                if (bitmap != null) {
                    bitmap.recycle();
                }
            }
            if (this.bitmap != null && this.bitmapIsCached) {
                OnImageEventListener onImageEventListener = this.onImageEventListener;
                if (onImageEventListener != null) {
                    onImageEventListener.onPreviewReleased();
                }
            }
            this.sWidth = 0;
            this.sHeight = 0;
            this.sOrientation = 0;
            this.sRegion = null;
            this.pRegion = null;
            this.isReady = false;
            this.isImageLoaded = false;
            this.bitmap = null;
            this.bitmapIsPreview = false;
            this.bitmapIsCached = false;
        }
        if (this.tileMap != null) {
            Map<Integer, List<Tile>> map = this.tileMap;
            if (map == null) {
                Intrinsics.throwNpe();
            }
            Map<Integer, List<Tile>> map2 = map;
            Iterator<Map.Entry<Integer, List<Tile>>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, List<Tile>> entry;
                Map.Entry<Integer, List<Tile>> entry2 = entry = iterator.next();
                int key = ((Number)entry2.getKey()).intValue();
                entry2 = entry;
                List<Tile> value = entry2.getValue();
                for (Tile tile : value) {
                    tile.setVisible(false);
                    Bitmap bitmap = tile.getBitmap();
                    if (bitmap != null) {
                        bitmap.recycle();
                    }
                    tile.setBitmap(null);
                }
            }
            this.tileMap = null;
        }
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.setGestureDetector(context);
    }

    private final void setGestureDetector(Context context) {
        this.detector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(this, context){
            final /* synthetic */ SubsamplingScaleImageView this$0;
            final /* synthetic */ Context $context;

            public boolean onFling(@Nullable MotionEvent e1, @Nullable MotionEvent e2, float velocityX, float velocityY) {
                if (this.this$0.isReady() && SubsamplingScaleImageView.access$getVTranslate$p(this.this$0) != null && e1 != null && e2 != null && (Math.abs(e1.getX() - e2.getX()) > (float)50 || Math.abs(e1.getY() - e2.getY()) > (float)50) && (Math.abs(velocityX) > (float)500 || Math.abs(velocityY) > (float)500) && !SubsamplingScaleImageView.access$isZooming$p(this.this$0)) {
                    PointF pointF = SubsamplingScaleImageView.access$getVTranslate$p(this.this$0);
                    if (pointF == null) {
                        Intrinsics.throwNpe();
                    }
                    float f = pointF.x + velocityX * 0.25f;
                    PointF pointF2 = SubsamplingScaleImageView.access$getVTranslate$p(this.this$0);
                    if (pointF2 == null) {
                        Intrinsics.throwNpe();
                    }
                    PointF vTranslateEnd = new PointF(f, pointF2.y + velocityY * 0.25f);
                    float sCenterXEnd = ((float)(this.this$0.getWidth() / 2) - vTranslateEnd.x) / this.this$0.getScale();
                    float sCenterYEnd = ((float)(this.this$0.getHeight() / 2) - vTranslateEnd.y) / this.this$0.getScale();
                    this.this$0.new AnimationBuilder(new PointF(sCenterXEnd, sCenterYEnd)).withEasing(1).withOrigin(2).start();
                    return true;
                }
                return super.onFling(e1, e2, velocityX, velocityY);
            }

            public boolean onSingleTapConfirmed(@NotNull MotionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.this$0.performClick();
                return true;
            }

            public boolean onDoubleTap(@NotNull MotionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                if (this.this$0.isZoomEnabled() && this.this$0.isReady() && SubsamplingScaleImageView.access$getVTranslate$p(this.this$0) != null) {
                    SubsamplingScaleImageView.access$setGestureDetector(this.this$0, this.$context);
                    if (this.this$0.isQuickScaleEnabled()) {
                        SubsamplingScaleImageView.access$setVCenterStart$p(this.this$0, new PointF(e.getX(), e.getY()));
                        PointF pointF = SubsamplingScaleImageView.access$getVTranslate$p(this.this$0);
                        if (pointF == null) {
                            Intrinsics.throwNpe();
                        }
                        float f = pointF.x;
                        PointF pointF2 = SubsamplingScaleImageView.access$getVTranslate$p(this.this$0);
                        if (pointF2 == null) {
                            Intrinsics.throwNpe();
                        }
                        SubsamplingScaleImageView.access$setVTranslateStart$p(this.this$0, new PointF(f, pointF2.y));
                        SubsamplingScaleImageView.access$setScaleStart$p(this.this$0, this.this$0.getScale());
                        SubsamplingScaleImageView.access$setQuickScaling$p(this.this$0, true);
                        SubsamplingScaleImageView.access$setZooming$p(this.this$0, true);
                        SubsamplingScaleImageView.access$setQuickScaleLastDistance$p(this.this$0, -1.0f);
                        PointF pointF3 = SubsamplingScaleImageView.access$getVCenterStart$p(this.this$0);
                        if (pointF3 == null) {
                            Intrinsics.throwNpe();
                        }
                        SubsamplingScaleImageView.access$setQuickScaleSCenter$p(this.this$0, this.this$0.viewToSourceCoord(pointF3));
                        SubsamplingScaleImageView.access$setQuickScaleVStart$p(this.this$0, new PointF(e.getX(), e.getY()));
                        PointF pointF4 = SubsamplingScaleImageView.access$getQuickScaleSCenter$p(this.this$0);
                        if (pointF4 == null) {
                            Intrinsics.throwNpe();
                        }
                        float f2 = pointF4.x;
                        PointF pointF5 = SubsamplingScaleImageView.access$getQuickScaleSCenter$p(this.this$0);
                        if (pointF5 == null) {
                            Intrinsics.throwNpe();
                        }
                        SubsamplingScaleImageView.access$setQuickScaleVLastPoint$p(this.this$0, new PointF(f2, pointF5.y));
                        SubsamplingScaleImageView.access$setQuickScaleMoved$p(this.this$0, false);
                        return false;
                    }
                    SubsamplingScaleImageView.access$doubleTapZoom(this.this$0, this.this$0.viewToSourceCoord(new PointF(e.getX(), e.getY())), new PointF(e.getX(), e.getY()));
                    return true;
                }
                return super.onDoubleTapEvent(e);
            }
            {
                this.this$0 = $outer;
                this.$context = $captured_local_variable$1;
            }
        });
        this.singleDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(this){
            final /* synthetic */ SubsamplingScaleImageView this$0;

            public boolean onSingleTapConfirmed(@NotNull MotionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.this$0.performClick();
                return true;
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.resetScaleOnSizeChange) {
            super.onSizeChanged(w, h, oldw, oldh);
            if (oldh != 0 && oldw != 0) {
                this.resetScaleAndCenter();
            }
        } else {
            PointF sCenter = this.getCenter();
            if (this.isReady && sCenter != null) {
                this.anim = null;
                this.pendingScale = Float.valueOf(this.scale);
                this.sPendingCenter = sCenter;
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int parentWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int parentHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        boolean resizeWidth = widthSpecMode != 0x40000000;
        boolean resizeHeight = heightSpecMode != 0x40000000;
        int width = parentWidth;
        int height = parentHeight;
        if (this.sWidth > 0 && this.sHeight > 0) {
            if (resizeWidth && resizeHeight) {
                width = this.sWidth();
                height = this.sHeight();
            } else if (resizeHeight) {
                height = (int)((double)this.sHeight() / (double)this.sWidth() * (double)width);
            } else if (resizeWidth) {
                width = (int)((double)this.sWidth() / (double)this.sHeight() * (double)height);
            }
        }
        width = Math.max(width, this.getSuggestedMinimumWidth());
        height = Math.max(height, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(width, height);
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        block14: {
            block15: {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                Anim anim = this.anim;
                if (anim != null) {
                    if (!anim.getInterruptible()) {
                        ViewParent viewParent = this.getParent();
                        if (viewParent != null) {
                            viewParent.requestDisallowInterceptTouchEvent(true);
                        }
                        return true;
                    }
                }
                this.anim = null;
                if (this.vTranslate == null) {
                    GestureDetector gestureDetector = this.singleDetector;
                    if (gestureDetector != null) {
                        gestureDetector.onTouchEvent(event);
                    }
                    return true;
                }
                if (this.isQuickScaling) break block14;
                if (this.detector == null) break block15;
                GestureDetector gestureDetector = this.detector;
                if (gestureDetector == null) {
                    Intrinsics.throwNpe();
                }
                if (!gestureDetector.onTouchEvent(event)) break block14;
            }
            this.isZooming = false;
            this.isPanning = false;
            this.maxTouchCount = 0;
            return true;
        }
        if (this.vTranslateStart == null) {
            this.vTranslateStart = new PointF(0.0f, 0.0f);
        }
        if (this.vTranslateBefore == null) {
            this.vTranslateBefore = new PointF(0.0f, 0.0f);
        }
        if (this.vCenterStart == null) {
            this.vCenterStart = new PointF(0.0f, 0.0f);
        }
        PointF pointF = this.vTranslateBefore;
        if (pointF == null) {
            Intrinsics.throwNpe();
        }
        pointF.set(this.vTranslate);
        boolean handled = this.onTouchEventInternal(event);
        return handled || super.onTouchEvent(event);
    }

    private final boolean onTouchEventInternal(MotionEvent event) {
        int touchCount = event.getPointerCount();
        switch (event.getAction()) {
            case 0: 
            case 5: 
            case 261: {
                Unit unit;
                this.anim = null;
                ViewParent viewParent = this.getParent();
                if (viewParent != null) {
                    viewParent.requestDisallowInterceptTouchEvent(true);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                this.maxTouchCount = Math.max(this.maxTouchCount, touchCount);
                if (touchCount >= 2) {
                    if (this.isZoomEnabled) {
                        float distance = this.distance(event.getX(0), event.getX(1), event.getY(0), event.getY(1));
                        this.scaleStart = this.scale;
                        this.vDistStart = distance;
                        PointF pointF = this.vTranslateStart;
                        if (pointF == null) {
                            Intrinsics.throwNpe();
                        }
                        PointF pointF2 = this.vTranslate;
                        if (pointF2 == null) {
                            Intrinsics.throwNpe();
                        }
                        float f = pointF2.x;
                        PointF pointF3 = this.vTranslate;
                        if (pointF3 == null) {
                            Intrinsics.throwNpe();
                        }
                        pointF.set(f, pointF3.y);
                        PointF pointF4 = this.vCenterStart;
                        if (pointF4 == null) {
                            Intrinsics.throwNpe();
                        }
                        pointF4.set((event.getX(0) + event.getX(1)) / (float)2, (event.getY(0) + event.getY(1)) / (float)2);
                    } else {
                        this.maxTouchCount = 0;
                    }
                } else if (!this.isQuickScaling) {
                    PointF pointF = this.vTranslateStart;
                    if (pointF == null) {
                        Intrinsics.throwNpe();
                    }
                    PointF pointF5 = this.vTranslate;
                    if (pointF5 == null) {
                        Intrinsics.throwNpe();
                    }
                    float f = pointF5.x;
                    PointF pointF6 = this.vTranslate;
                    if (pointF6 == null) {
                        Intrinsics.throwNpe();
                    }
                    pointF.set(f, pointF6.y);
                    PointF pointF7 = this.vCenterStart;
                    if (pointF7 == null) {
                        Intrinsics.throwNpe();
                    }
                    pointF7.set(event.getX(), event.getY());
                }
                return true;
            }
            case 2: {
                boolean consumed = false;
                if (this.maxTouchCount > 0) {
                    if (touchCount >= 2) {
                        float vDistEnd = this.distance(event.getX(0), event.getX(1), event.getY(0), event.getY(1));
                        float vCenterEndX = (event.getX(0) + event.getX(1)) / (float)2;
                        float vCenterEndY = (event.getY(0) + event.getY(1)) / (float)2;
                        if (this.isZoomEnabled) {
                            PointF pointF = this.vCenterStart;
                            if (pointF == null) {
                                Intrinsics.throwNpe();
                            }
                            float f = pointF.x;
                            PointF pointF8 = this.vCenterStart;
                            if (pointF8 == null) {
                                Intrinsics.throwNpe();
                            }
                            if (this.distance(f, vCenterEndX, pointF8.y, vCenterEndY) > (float)5 || Math.abs(vDistEnd - this.vDistStart) > (float)5 || this.isPanning) {
                                this.isZooming = true;
                                this.isPanning = true;
                                consumed = true;
                                double previousScale = this.scale;
                                this.scale = Math.min(this.maxScale, vDistEnd / this.vDistStart * this.scaleStart);
                                if (this.scale <= this.minScale()) {
                                    this.vDistStart = vDistEnd;
                                    this.scaleStart = this.minScale();
                                    PointF pointF9 = this.vCenterStart;
                                    if (pointF9 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    pointF9.set(vCenterEndX, vCenterEndY);
                                    PointF pointF10 = this.vTranslateStart;
                                    if (pointF10 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    pointF10.set(this.vTranslate);
                                } else {
                                    PointF pointF11 = this.vCenterStart;
                                    if (pointF11 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    float f2 = pointF11.x;
                                    PointF pointF12 = this.vTranslateStart;
                                    if (pointF12 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    float vLeftStart = f2 - pointF12.x;
                                    PointF pointF13 = this.vCenterStart;
                                    if (pointF13 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    float f3 = pointF13.y;
                                    PointF pointF14 = this.vTranslateStart;
                                    if (pointF14 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    float vTopStart = f3 - pointF14.y;
                                    float vLeftNow = vLeftStart * (this.scale / this.scaleStart);
                                    float vTopNow = vTopStart * (this.scale / this.scaleStart);
                                    if (this.vTranslate == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    this.vTranslate.x = vCenterEndX - vLeftNow;
                                    if (this.vTranslate == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    this.vTranslate.y = vCenterEndY - vTopNow;
                                    if (previousScale * (double)this.sHeight() < (double)this.getHeight() && this.scale * (float)this.sHeight() >= (float)this.getHeight() || previousScale * (double)this.sWidth() < (double)this.getWidth() && this.scale * (float)this.sWidth() >= (float)this.getWidth()) {
                                        this.fitToBounds(true);
                                        PointF pointF15 = this.vCenterStart;
                                        if (pointF15 == null) {
                                            Intrinsics.throwNpe();
                                        }
                                        pointF15.set(vCenterEndX, vCenterEndY);
                                        PointF pointF16 = this.vTranslateStart;
                                        if (pointF16 == null) {
                                            Intrinsics.throwNpe();
                                        }
                                        pointF16.set(this.vTranslate);
                                        this.scaleStart = this.scale;
                                        this.vDistStart = vDistEnd;
                                    }
                                }
                                this.fitToBounds(true);
                                this.refreshRequiredTiles(this.eagerLoadingEnabled);
                            }
                        }
                    } else if (this.isQuickScaling) {
                        PointF pointF = this.quickScaleVStart;
                        if (pointF == null) {
                            Intrinsics.throwNpe();
                        }
                        float dist = Math.abs(pointF.y - event.getY()) * (float)2 + this.quickScaleThreshold;
                        if (this.quickScaleLastDistance == -1.0f) {
                            this.quickScaleLastDistance = dist;
                        }
                        float f = event.getY();
                        PointF pointF17 = this.quickScaleVLastPoint;
                        if (pointF17 == null) {
                            Intrinsics.throwNpe();
                        }
                        boolean isUpwards = f > pointF17.y;
                        PointF pointF18 = this.quickScaleVLastPoint;
                        if (pointF18 == null) {
                            Intrinsics.throwNpe();
                        }
                        pointF18.set(0.0f, event.getY());
                        float spanDiff = Math.abs(1.0f - dist / this.quickScaleLastDistance) * 0.5f;
                        if (spanDiff > 0.03f || this.quickScaleMoved) {
                            this.quickScaleMoved = true;
                            float multiplier = 1.0f;
                            if (this.quickScaleLastDistance > 0.0f) {
                                multiplier = isUpwards ? 1.0f + spanDiff : 1.0f - spanDiff;
                            }
                            double previousScale = this.scale;
                            this.scale = Math.max(this.minScale(), Math.min(this.maxScale, this.scale * multiplier));
                            PointF pointF19 = this.vCenterStart;
                            if (pointF19 == null) {
                                Intrinsics.throwNpe();
                            }
                            float f4 = pointF19.x;
                            PointF pointF20 = this.vTranslateStart;
                            if (pointF20 == null) {
                                Intrinsics.throwNpe();
                            }
                            float vLeftStart = f4 - pointF20.x;
                            PointF pointF21 = this.vCenterStart;
                            if (pointF21 == null) {
                                Intrinsics.throwNpe();
                            }
                            float f5 = pointF21.y;
                            PointF pointF22 = this.vTranslateStart;
                            if (pointF22 == null) {
                                Intrinsics.throwNpe();
                            }
                            float vTopStart = f5 - pointF22.y;
                            float vLeftNow = vLeftStart * (this.scale / this.scaleStart);
                            float vTopNow = vTopStart * (this.scale / this.scaleStart);
                            if (this.vTranslate == null) {
                                Intrinsics.throwNpe();
                            }
                            PointF pointF23 = this.vCenterStart;
                            if (pointF23 == null) {
                                Intrinsics.throwNpe();
                            }
                            this.vTranslate.x = pointF23.x - vLeftNow;
                            if (this.vTranslate == null) {
                                Intrinsics.throwNpe();
                            }
                            PointF pointF24 = this.vCenterStart;
                            if (pointF24 == null) {
                                Intrinsics.throwNpe();
                            }
                            this.vTranslate.y = pointF24.y - vTopNow;
                            if (previousScale * (double)this.sHeight() < (double)this.getHeight() && this.scale * (float)this.sHeight() >= (float)this.getHeight() || previousScale * (double)this.sWidth() < (double)this.getWidth() && this.scale * (float)this.sWidth() >= (float)this.getWidth()) {
                                this.fitToBounds(true);
                                PointF pointF25 = this.vCenterStart;
                                if (pointF25 == null) {
                                    Intrinsics.throwNpe();
                                }
                                PointF pointF26 = this.quickScaleSCenter;
                                if (pointF26 == null) {
                                    Intrinsics.throwNpe();
                                }
                                pointF25.set(this.sourceToViewCoord(pointF26));
                                PointF pointF27 = this.vTranslateStart;
                                if (pointF27 == null) {
                                    Intrinsics.throwNpe();
                                }
                                pointF27.set(this.vTranslate);
                                this.scaleStart = this.scale;
                                dist = 0.0f;
                            }
                        }
                        this.quickScaleLastDistance = dist;
                        this.fitToBounds(true);
                        this.refreshRequiredTiles(this.eagerLoadingEnabled);
                        consumed = true;
                    } else if (!this.isZooming) {
                        float f = event.getX();
                        PointF pointF = this.vCenterStart;
                        if (pointF == null) {
                            Intrinsics.throwNpe();
                        }
                        float dx = Math.abs(f - pointF.x);
                        float f6 = event.getY();
                        PointF pointF28 = this.vCenterStart;
                        if (pointF28 == null) {
                            Intrinsics.throwNpe();
                        }
                        float dy = Math.abs(f6 - pointF28.y);
                        float offset = this.density * (float)5;
                        if (dx > offset || dy > offset || this.isPanning) {
                            boolean yPan;
                            consumed = true;
                            if (this.vTranslate == null) {
                                Intrinsics.throwNpe();
                            }
                            PointF pointF29 = this.vTranslateStart;
                            if (pointF29 == null) {
                                Intrinsics.throwNpe();
                            }
                            float f7 = pointF29.x;
                            float f8 = event.getX();
                            PointF pointF30 = this.vCenterStart;
                            if (pointF30 == null) {
                                Intrinsics.throwNpe();
                            }
                            this.vTranslate.x = f7 + (f8 - pointF30.x);
                            if (this.vTranslate == null) {
                                Intrinsics.throwNpe();
                            }
                            PointF pointF31 = this.vTranslateStart;
                            if (pointF31 == null) {
                                Intrinsics.throwNpe();
                            }
                            float f9 = pointF31.y;
                            float f10 = event.getY();
                            PointF pointF32 = this.vCenterStart;
                            if (pointF32 == null) {
                                Intrinsics.throwNpe();
                            }
                            this.vTranslate.y = f9 + (f10 - pointF32.y);
                            PointF pointF33 = this.vTranslate;
                            if (pointF33 == null) {
                                Intrinsics.throwNpe();
                            }
                            float lastX = pointF33.x;
                            PointF pointF34 = this.vTranslate;
                            if (pointF34 == null) {
                                Intrinsics.throwNpe();
                            }
                            float lastY = pointF34.y;
                            this.fitToBounds(true);
                            PointF pointF35 = this.vTranslate;
                            if (pointF35 == null) {
                                Intrinsics.throwNpe();
                            }
                            boolean atXEdge = lastX != pointF35.x;
                            PointF pointF36 = this.vTranslate;
                            if (pointF36 == null) {
                                Intrinsics.throwNpe();
                            }
                            boolean atYEdge = lastY != pointF36.y;
                            boolean edgeXSwipe = atXEdge && dx > dy && !this.isPanning;
                            boolean edgeYSwipe = atYEdge && dy > dx && !this.isPanning;
                            PointF pointF37 = this.vTranslate;
                            if (pointF37 == null) {
                                Intrinsics.throwNpe();
                            }
                            boolean bl = yPan = lastY == pointF37.y && dy > offset * (float)3;
                            if (!(edgeXSwipe || edgeYSwipe || atXEdge && atYEdge && !yPan && !this.isPanning)) {
                                this.isPanning = true;
                            } else if (dx > offset || dy > offset) {
                                Unit unit;
                                this.maxTouchCount = 0;
                                ViewParent viewParent = this.getParent();
                                if (viewParent != null) {
                                    viewParent.requestDisallowInterceptTouchEvent(false);
                                    unit = Unit.INSTANCE;
                                } else {
                                    unit = null;
                                }
                            }
                            this.refreshRequiredTiles(this.eagerLoadingEnabled);
                        }
                    }
                }
                if (!consumed) break;
                this.invalidate();
                return true;
            }
            case 1: 
            case 6: 
            case 262: {
                if (this.isQuickScaling) {
                    this.isQuickScaling = false;
                    if (!this.quickScaleMoved) {
                        this.doubleTapZoom(this.quickScaleSCenter, this.vCenterStart);
                    }
                }
                if (this.maxTouchCount > 0 && (this.isZooming || this.isPanning)) {
                    if (this.isZooming && touchCount == 2) {
                        this.isPanning = true;
                        PointF pointF = this.vTranslateStart;
                        if (pointF == null) {
                            Intrinsics.throwNpe();
                        }
                        PointF pointF38 = this.vTranslate;
                        if (pointF38 == null) {
                            Intrinsics.throwNpe();
                        }
                        float f = pointF38.x;
                        PointF pointF39 = this.vTranslate;
                        if (pointF39 == null) {
                            Intrinsics.throwNpe();
                        }
                        pointF.set(f, pointF39.y);
                        if (event.getActionIndex() == 1) {
                            PointF pointF40 = this.vCenterStart;
                            if (pointF40 == null) {
                                Intrinsics.throwNpe();
                            }
                            pointF40.set(event.getX(0), event.getY(0));
                        } else {
                            PointF pointF41 = this.vCenterStart;
                            if (pointF41 == null) {
                                Intrinsics.throwNpe();
                            }
                            pointF41.set(event.getX(1), event.getY(1));
                        }
                    }
                    if (touchCount < 3) {
                        this.isZooming = false;
                    }
                    if (touchCount < 2) {
                        this.isPanning = false;
                        this.maxTouchCount = 0;
                    }
                    this.refreshRequiredTiles(true);
                    return true;
                }
                if (touchCount == 1) {
                    this.isZooming = false;
                    this.isPanning = false;
                    this.maxTouchCount = 0;
                }
                return true;
            }
        }
        return false;
    }

    private final void doubleTapZoom(PointF sCenter, PointF vFocus) {
        float targetScale;
        float doubleTapZoomScale = Math.min(this.maxScale, this.doubleTapZoomScale);
        boolean zoomIn = (double)this.scale <= (double)doubleTapZoomScale * 0.9 || this.scale == this.minScale;
        float f = targetScale = zoomIn ? doubleTapZoomScale : this.minScale();
        if (!zoomIn) {
            PointF pointF = sCenter;
            if (pointF == null) {
                Intrinsics.throwNpe();
            }
            new AnimationBuilder(targetScale, pointF).withInterruptible(false).withDuration(this.DOUBLE_TAP_ZOOM_DURATION).withOrigin(3).start();
        } else {
            PointF pointF = sCenter;
            if (pointF == null) {
                Intrinsics.throwNpe();
            }
            PointF pointF2 = vFocus;
            if (pointF2 == null) {
                Intrinsics.throwNpe();
            }
            new AnimationBuilder(targetScale, pointF, pointF2).withInterruptible(false).withDuration(this.DOUBLE_TAP_ZOOM_DURATION).withOrigin(3).start();
        }
        this.invalidate();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected void onDraw(@NotNull Canvas canvas) {
        block171: {
            Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
            super.onDraw(canvas);
            this.createPaints();
            if (this.sWidth == 0 || this.sHeight == 0 || this.getWidth() == 0 || this.getHeight() == 0) {
                return;
            }
            if (this.tileMap == null && this.decoder != null) {
                this.initialiseBaseLayer(this.getMaxBitmapDimensions(canvas));
            }
            if (!this.checkReady()) {
                return;
            }
            this.preDraw();
            if (this.anim == null) break block171;
            v0 = this.anim;
            if (v0 == null) {
                Intrinsics.throwNpe();
            }
            if (v0.getVFocusStart() == null) break block171;
            if (this.vTranslateBefore == null) {
                this.vTranslateBefore = new PointF(0.0f, 0.0f);
            }
            v1 = this.vTranslateBefore;
            if (v1 == null) {
                Intrinsics.throwNpe();
            }
            v1.set(this.vTranslate);
            v2 = System.currentTimeMillis();
            v3 = this.anim;
            if (v3 == null) {
                Intrinsics.throwNpe();
            }
            scaleElapsed = v2 - v3.getTime();
            v4 = this.anim;
            if (v4 == null) {
                Intrinsics.throwNpe();
            }
            finished = scaleElapsed > v4.getDuration();
            v5 = this.anim;
            if (v5 == null) {
                Intrinsics.throwNpe();
            }
            scaleElapsed = Math.min(scaleElapsed, v5.getDuration());
            v6 = this.anim;
            if (v6 == null) {
                Intrinsics.throwNpe();
            }
            v7 = v6.getEasing();
            v8 = this.anim;
            if (v8 == null) {
                Intrinsics.throwNpe();
            }
            v9 = v8.getScaleStart();
            v10 = this.anim;
            if (v10 == null) {
                Intrinsics.throwNpe();
            }
            v11 = v10.getScaleEnd();
            v12 = this.anim;
            if (v12 == null) {
                Intrinsics.throwNpe();
            }
            v13 = v11 - v12.getScaleStart();
            v14 = this.anim;
            if (v14 == null) {
                Intrinsics.throwNpe();
            }
            this.scale = this.ease(v7, scaleElapsed, v9, v13, v14.getDuration());
            v15 = this.anim;
            if (v15 == null) {
                Intrinsics.throwNpe();
            }
            v16 = v15.getEasing();
            v17 = this.anim;
            if (v17 == null) {
                Intrinsics.throwNpe();
            }
            v18 = v17.getVFocusStart();
            if (v18 == null) {
                Intrinsics.throwNpe();
            }
            v19 = v18.x;
            v20 = this.anim;
            if (v20 == null) {
                Intrinsics.throwNpe();
            }
            v21 = v20.getVFocusEnd();
            if (v21 == null) {
                Intrinsics.throwNpe();
            }
            v22 = v21.x;
            v23 = this.anim;
            if (v23 == null) {
                Intrinsics.throwNpe();
            }
            v24 = v23.getVFocusStart();
            if (v24 == null) {
                Intrinsics.throwNpe();
            }
            v25 = v22 - v24.x;
            v26 = this.anim;
            if (v26 == null) {
                Intrinsics.throwNpe();
            }
            vFocusNowX = this.ease(v16, scaleElapsed, v19, v25, v26.getDuration());
            v27 = this.anim;
            if (v27 == null) {
                Intrinsics.throwNpe();
            }
            v28 = v27.getEasing();
            v29 = this.anim;
            if (v29 == null) {
                Intrinsics.throwNpe();
            }
            v30 = v29.getVFocusStart();
            if (v30 == null) {
                Intrinsics.throwNpe();
            }
            v31 = v30.y;
            v32 = this.anim;
            if (v32 == null) {
                Intrinsics.throwNpe();
            }
            v33 = v32.getVFocusEnd();
            if (v33 == null) {
                Intrinsics.throwNpe();
            }
            v34 = v33.y;
            v35 = this.anim;
            if (v35 == null) {
                Intrinsics.throwNpe();
            }
            v36 = v35.getVFocusStart();
            if (v36 == null) {
                Intrinsics.throwNpe();
            }
            v37 = v34 - v36.y;
            v38 = this.anim;
            if (v38 == null) {
                Intrinsics.throwNpe();
            }
            vFocusNowY = this.ease(v28, scaleElapsed, v31, v37, v38.getDuration());
            v39 = this.vTranslate;
            if (v39 == null) {
                Intrinsics.throwNpe();
            }
            v40 = v39.x;
            v41 = this.anim;
            if (v41 == null) {
                Intrinsics.throwNpe();
            }
            v42 = v41.getSCenterEnd();
            if (v42 == null) {
                Intrinsics.throwNpe();
            }
            v39.x = v40 - (this.sourceToViewX(v42.x) - vFocusNowX);
            v43 = this.vTranslate;
            if (v43 == null) {
                Intrinsics.throwNpe();
            }
            v44 = v43.y;
            v45 = this.anim;
            if (v45 == null) {
                Intrinsics.throwNpe();
            }
            v46 = v45.getSCenterEnd();
            if (v46 == null) {
                Intrinsics.throwNpe();
            }
            v43.y = v44 - (this.sourceToViewY(v46.y) - vFocusNowY);
            if (finished) ** GOTO lbl-1000
            v47 = this.anim;
            if (v47 == null) {
                Intrinsics.throwNpe();
            }
            v48 = v47.getScaleStart();
            v49 = this.anim;
            if (v49 == null) {
                Intrinsics.throwNpe();
            }
            if (v48 == v49.getScaleEnd()) lbl-1000:
            // 2 sources

            {
                v50 = true;
            } else {
                v50 = false;
            }
            this.fitToBounds(v50);
            this.refreshRequiredTiles(finished);
            if (finished) {
                this.anim = null;
            }
            this.invalidate();
        }
        if (this.tileMap != null && this.isBaseLayerReady()) {
            sampleSize = Math.min(this.fullImageSampleSize, this.calculateInSampleSize(this.scale));
            hasMissingTiles = false;
            v51 = this.tileMap;
            if (v51 == null) {
                Intrinsics.throwNpe();
            }
            vFocusNowY = v51;
            vFocusNowX = vFocusNowY.entrySet().iterator();
            while (vFocusNowX.hasNext()) {
                var8_25 = finished = vFocusNowX.next();
                key = ((Number)var8_25.getKey()).intValue();
                var8_25 = finished;
                value = var8_25.getValue();
                if (key != sampleSize) continue;
                for (Object tile : value) {
                    if (!tile.getVisible() || !tile.getLoading() && tile.getBitmap() != null) continue;
                    hasMissingTiles = true;
                }
            }
            v52 = this.tileMap;
            if (v52 == null) {
                Intrinsics.throwNpe();
            }
            key = v52;
            for (Map.Entry<Integer, List<Tile>> finished : key.entrySet()) {
                tile = finished;
                key = ((Number)tile.getKey()).intValue();
                tile = finished;
                value = tile.getValue();
                if (key != sampleSize && !hasMissingTiles) continue;
                for (Object tile : value) {
                    v53 = tile.getSRect();
                    if (v53 == null) {
                        Intrinsics.throwNpe();
                    }
                    v54 = tile.getVRect();
                    if (v54 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.sourceToViewRect(v53, v54);
                    if (!tile.getLoading() && tile.getBitmap() != null) {
                        if (this.objectMatrix == null) {
                            this.objectMatrix = new Matrix();
                        }
                        v55 = this.objectMatrix;
                        if (v55 == null) {
                            Intrinsics.throwNpe();
                        }
                        v55.reset();
                        v56 = tile.getBitmap();
                        if (v56 == null) {
                            Intrinsics.throwNpe();
                        }
                        v57 = v56.getWidth();
                        v58 = tile.getBitmap();
                        if (v58 == null) {
                            Intrinsics.throwNpe();
                        }
                        v59 = v58.getWidth();
                        v60 = tile.getBitmap();
                        if (v60 == null) {
                            Intrinsics.throwNpe();
                        }
                        v61 = v60.getHeight();
                        v62 = tile.getBitmap();
                        if (v62 == null) {
                            Intrinsics.throwNpe();
                        }
                        this.setMatrixArray(this.srcArray, 0.0f, 0.0f, v57, 0.0f, v59, v61, 0.0f, v62.getHeight());
                        switch (this.getRequiredRotation()) {
                            case 0: {
                                v63 = tile.getVRect();
                                if (v63 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v64 = v63.left;
                                v65 = tile.getVRect();
                                if (v65 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v66 = v65.top;
                                v67 = tile.getVRect();
                                if (v67 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v68 = v67.right;
                                v69 = tile.getVRect();
                                if (v69 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v70 = v69.top;
                                v71 = tile.getVRect();
                                if (v71 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v72 = v71.right;
                                v73 = tile.getVRect();
                                if (v73 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v74 = v73.bottom;
                                v75 = tile.getVRect();
                                if (v75 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v76 = v75.left;
                                v77 = tile.getVRect();
                                if (v77 == null) {
                                    Intrinsics.throwNpe();
                                }
                                this.setMatrixArray(this.dstArray, v64, v66, v68, v70, v72, v74, v76, v77.bottom);
                                break;
                            }
                            case 90: {
                                v78 = tile.getVRect();
                                if (v78 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v79 = v78.right;
                                v80 = tile.getVRect();
                                if (v80 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v81 = v80.top;
                                v82 = tile.getVRect();
                                if (v82 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v83 = v82.right;
                                v84 = tile.getVRect();
                                if (v84 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v85 = v84.bottom;
                                v86 = tile.getVRect();
                                if (v86 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v87 = v86.left;
                                v88 = tile.getVRect();
                                if (v88 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v89 = v88.bottom;
                                v90 = tile.getVRect();
                                if (v90 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v91 = v90.left;
                                v92 = tile.getVRect();
                                if (v92 == null) {
                                    Intrinsics.throwNpe();
                                }
                                this.setMatrixArray(this.dstArray, v79, v81, v83, v85, v87, v89, v91, v92.top);
                                break;
                            }
                            case 180: {
                                v93 = tile.getVRect();
                                if (v93 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v94 = v93.right;
                                v95 = tile.getVRect();
                                if (v95 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v96 = v95.bottom;
                                v97 = tile.getVRect();
                                if (v97 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v98 = v97.left;
                                v99 = tile.getVRect();
                                if (v99 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v100 = v99.bottom;
                                v101 = tile.getVRect();
                                if (v101 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v102 = v101.left;
                                v103 = tile.getVRect();
                                if (v103 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v104 = v103.top;
                                v105 = tile.getVRect();
                                if (v105 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v106 = v105.right;
                                v107 = tile.getVRect();
                                if (v107 == null) {
                                    Intrinsics.throwNpe();
                                }
                                this.setMatrixArray(this.dstArray, v94, v96, v98, v100, v102, v104, v106, v107.top);
                                break;
                            }
                            case 270: {
                                v108 = tile.getVRect();
                                if (v108 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v109 = v108.left;
                                v110 = tile.getVRect();
                                if (v110 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v111 = v110.bottom;
                                v112 = tile.getVRect();
                                if (v112 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v113 = v112.left;
                                v114 = tile.getVRect();
                                if (v114 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v115 = v114.top;
                                v116 = tile.getVRect();
                                if (v116 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v117 = v116.right;
                                v118 = tile.getVRect();
                                if (v118 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v119 = v118.top;
                                v120 = tile.getVRect();
                                if (v120 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v121 = v120.right;
                                v122 = tile.getVRect();
                                if (v122 == null) {
                                    Intrinsics.throwNpe();
                                }
                                this.setMatrixArray(this.dstArray, v109, v111, v113, v115, v117, v119, v121, v122.bottom);
                            }
                        }
                        v123 = this.objectMatrix;
                        if (v123 == null) {
                            Intrinsics.throwNpe();
                        }
                        v123.setPolyToPoly(this.srcArray, 0, this.dstArray, 0, 4);
                        v124 = tile.getBitmap();
                        if (v124 == null) {
                            Intrinsics.throwNpe();
                        }
                        v125 = this.objectMatrix;
                        if (v125 == null) {
                            Intrinsics.throwNpe();
                        }
                        canvas.drawBitmap(v124, v125, this.bitmapPaint);
                        if (this.debug) {
                            v126 = tile.getVRect();
                            if (v126 == null) {
                                Intrinsics.throwNpe();
                            }
                            v127 = this.debugLinePaint;
                            if (v127 == null) {
                                Intrinsics.throwNpe();
                            }
                            canvas.drawRect(v126, v127);
                        }
                    } else if (tile.getLoading() && this.debug) {
                        v128 = tile.getVRect();
                        if (v128 == null) {
                            Intrinsics.throwNpe();
                        }
                        v129 = v128.left + this.px(5);
                        v130 = tile.getVRect();
                        if (v130 == null) {
                            Intrinsics.throwNpe();
                        }
                        v131 = v130.top + this.px(35);
                        v132 = this.debugTextPaint;
                        if (v132 == null) {
                            Intrinsics.throwNpe();
                        }
                        canvas.drawText("LOADING", v129, v131, v132);
                    }
                    if (!tile.getVisible() || !this.debug) continue;
                    v133 = new StringBuilder().append("ISS ").append(tile.getSampleSize()).append(" RECT ");
                    v134 = tile.getSRect();
                    if (v134 == null) {
                        Intrinsics.throwNpe();
                    }
                    v135 = v133.append(v134.top).append(", ");
                    v136 = tile.getSRect();
                    if (v136 == null) {
                        Intrinsics.throwNpe();
                    }
                    v137 = v135.append(v136.left).append(", ");
                    v138 = tile.getSRect();
                    if (v138 == null) {
                        Intrinsics.throwNpe();
                    }
                    v139 = v137.append(v138.bottom).append(", ");
                    v140 = tile.getSRect();
                    if (v140 == null) {
                        Intrinsics.throwNpe();
                    }
                    v141 = v139.append(v140.right).toString();
                    v142 = tile.getVRect();
                    if (v142 == null) {
                        Intrinsics.throwNpe();
                    }
                    v143 = v142.left + this.px(5);
                    v144 = tile.getVRect();
                    if (v144 == null) {
                        Intrinsics.throwNpe();
                    }
                    v145 = v144.top + this.px(15);
                    v146 = this.debugTextPaint;
                    if (v146 == null) {
                        Intrinsics.throwNpe();
                    }
                    canvas.drawText(v141, v143, v145, v146);
                }
            }
        } else if (this.bitmap != null) {
            v147 = this.bitmap;
            if (v147 == null) {
                Intrinsics.throwNpe();
            }
            if (!v147.isRecycled()) {
                xScale = this.scale;
                yScale = this.scale;
                if (this.bitmapIsPreview) {
                    v148 = this.sWidth;
                    v149 = this.bitmap;
                    if (v149 == null) {
                        Intrinsics.throwNpe();
                    }
                    xScale = this.scale * (v148 / (float)v149.getWidth());
                    v150 = this.sHeight;
                    v151 = this.bitmap;
                    if (v151 == null) {
                        Intrinsics.throwNpe();
                    }
                    yScale = this.scale * (v150 / (float)v151.getHeight());
                }
                if (this.objectMatrix == null) {
                    this.objectMatrix = new Matrix();
                }
                v152 = this.objectMatrix;
                if (v152 == null) {
                    Intrinsics.throwNpe();
                }
                $receiver = finished = v152;
                $receiver.reset();
                $receiver.postScale(xScale, yScale);
                $receiver.postRotate((float)this.getRequiredRotation());
                v153 = this.vTranslate;
                if (v153 == null) {
                    Intrinsics.throwNpe();
                }
                v154 = v153.x;
                v155 = this.vTranslate;
                if (v155 == null) {
                    Intrinsics.throwNpe();
                }
                $receiver.postTranslate(v154, v155.y);
                switch (this.getRequiredRotation()) {
                    case 90: {
                        $receiver.postTranslate(this.scale * (float)this.sHeight, 0.0f);
                        break;
                    }
                    case 180: {
                        $receiver.postTranslate(this.scale * (float)this.sWidth, this.scale * (float)this.sHeight);
                        break;
                    }
                    case 270: {
                        $receiver.postTranslate(0.0f, this.scale * (float)this.sWidth);
                    }
                }
                v156 = this.bitmap;
                if (v156 == null) {
                    Intrinsics.throwNpe();
                }
                v157 = this.objectMatrix;
                if (v157 == null) {
                    Intrinsics.throwNpe();
                }
                canvas.drawBitmap(v156, v157, this.bitmapPaint);
            }
        }
        if (this.debug) {
            v158 = new StringBuilder().append("Scale: ");
            xScale = StringCompanionObject.INSTANCE;
            v159 = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull((Object)v159, (String)"Locale.ENGLISH");
            yScale = v159;
            finished = "%.2f";
            $receiver /* !! */  = new Object[]{Float.valueOf(this.scale)};
            var11_27 = v158;
            var10_28 = canvas;
            v160 = String.format(yScale, (String)finished, Arrays.copyOf($receiver /* !! */ , $receiver /* !! */ .length));
            Intrinsics.checkExpressionValueIsNotNull((Object)v160, (String)"java.lang.String.format(locale, format, *args)");
            var12_29 = v160;
            v161 = var11_27.append(var12_29).append(" (");
            xScale = StringCompanionObject.INSTANCE;
            v162 = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull((Object)v162, (String)"Locale.ENGLISH");
            yScale = v162;
            finished = "%.2f";
            $receiver /* !! */  = new Object[]{Float.valueOf(this.minScale())};
            var11_27 = v161;
            v163 = String.format(yScale, (String)finished, Arrays.copyOf($receiver /* !! */ , $receiver /* !! */ .length));
            Intrinsics.checkExpressionValueIsNotNull((Object)v163, (String)"java.lang.String.format(locale, format, *args)");
            var12_29 = v163;
            v164 = var11_27.append(var12_29).append(" - ");
            xScale = StringCompanionObject.INSTANCE;
            v165 = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull((Object)v165, (String)"Locale.ENGLISH");
            yScale = v165;
            finished = "%.2f";
            $receiver /* !! */  = new Object[]{Float.valueOf(this.maxScale)};
            var11_27 = v164;
            v166 = String.format(yScale, (String)finished, Arrays.copyOf($receiver /* !! */ , $receiver /* !! */ .length));
            Intrinsics.checkExpressionValueIsNotNull((Object)v166, (String)"java.lang.String.format(locale, format, *args)");
            var12_29 = v166;
            v167 = var11_27.append(var12_29).append(')').toString();
            v168 = this.px(5);
            v169 = this.px(15);
            v170 = this.debugTextPaint;
            if (v170 == null) {
                Intrinsics.throwNpe();
            }
            var10_28.drawText(v167, v168, v169, v170);
            v171 = new StringBuilder().append("Translate: ");
            xScale = StringCompanionObject.INSTANCE;
            v172 = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull((Object)v172, (String)"Locale.ENGLISH");
            yScale = v172;
            finished = "%.2f";
            v173 = new Object[1];
            v174 = this.vTranslate;
            if (v174 == null) {
                Intrinsics.throwNpe();
            }
            v173[0] = Float.valueOf(v174.x);
            $receiver /* !! */  = v173;
            var11_27 = v171;
            var10_28 = canvas;
            v175 = String.format(yScale, (String)finished, Arrays.copyOf($receiver /* !! */ , $receiver /* !! */ .length));
            Intrinsics.checkExpressionValueIsNotNull((Object)v175, (String)"java.lang.String.format(locale, format, *args)");
            var12_29 = v175;
            v176 = var11_27.append(var12_29).append(':');
            xScale = StringCompanionObject.INSTANCE;
            v177 = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull((Object)v177, (String)"Locale.ENGLISH");
            yScale = v177;
            finished = "%.2f";
            v178 = new Object[1];
            v179 = this.vTranslate;
            if (v179 == null) {
                Intrinsics.throwNpe();
            }
            v178[0] = Float.valueOf(v179.y);
            $receiver /* !! */  = v178;
            var11_27 = v176;
            v180 = String.format(yScale, (String)finished, Arrays.copyOf($receiver /* !! */ , $receiver /* !! */ .length));
            Intrinsics.checkExpressionValueIsNotNull((Object)v180, (String)"java.lang.String.format(locale, format, *args)");
            var12_29 = v180;
            v181 = var11_27.append(var12_29).toString();
            v182 = this.px(5);
            v183 = this.px(30);
            v184 = this.debugTextPaint;
            if (v184 == null) {
                Intrinsics.throwNpe();
            }
            var10_28.drawText(v181, v182, v183, v184);
            center = this.getCenter();
            v185 = new StringBuilder().append("Source center: ");
            yScale = StringCompanionObject.INSTANCE;
            v186 = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull((Object)v186, (String)"Locale.ENGLISH");
            finished = v186;
            $receiver /* !! */  = "%.2f";
            v187 = new Object[1];
            v188 = center;
            if (v188 == null) {
                Intrinsics.throwNpe();
            }
            v187[0] = Float.valueOf(v188.x);
            var6_20 = v187;
            var11_27 = v185;
            var10_28 = canvas;
            v189 = String.format((Locale)finished, (String)$receiver /* !! */ , Arrays.copyOf(var6_20, var6_20.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)v189, (String)"java.lang.String.format(locale, format, *args)");
            var12_29 = v189;
            v190 = var11_27.append(var12_29).append(':');
            yScale = StringCompanionObject.INSTANCE;
            v191 = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull((Object)v191, (String)"Locale.ENGLISH");
            finished = v191;
            $receiver /* !! */  = "%.2f";
            var6_20 = new Object[]{Float.valueOf(center.y)};
            var11_27 = v190;
            v192 = String.format((Locale)finished, (String)$receiver /* !! */ , Arrays.copyOf(var6_20, var6_20.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)v192, (String)"java.lang.String.format(locale, format, *args)");
            var12_29 = v192;
            v193 = var11_27.append(var12_29).toString();
            v194 = this.px(5);
            v195 = this.px(45);
            v196 = this.debugTextPaint;
            if (v196 == null) {
                Intrinsics.throwNpe();
            }
            var10_28.drawText(v193, v194, v195, v196);
            if (this.anim != null) {
                v197 = this.anim;
                if (v197 == null) {
                    Intrinsics.throwNpe();
                }
                v198 = v197.getSCenterStart();
                if (v198 == null) {
                    Intrinsics.throwNpe();
                }
                vCenterStart = this.sourceToViewCoord(v198);
                v199 = this.anim;
                if (v199 == null) {
                    Intrinsics.throwNpe();
                }
                v200 = v199.getSCenterEndRequested();
                if (v200 == null) {
                    Intrinsics.throwNpe();
                }
                vCenterEndRequested = this.sourceToViewCoord(v200);
                v201 = this.anim;
                if (v201 == null) {
                    Intrinsics.throwNpe();
                }
                v202 = v201.getSCenterEnd();
                if (v202 == null) {
                    Intrinsics.throwNpe();
                }
                vCenterEnd = this.sourceToViewCoord(v202);
                v203 = vCenterStart;
                if (v203 == null) {
                    Intrinsics.throwNpe();
                }
                v204 = v203.x;
                v205 = vCenterStart.y;
                v206 = this.px(10);
                v207 = this.debugLinePaint;
                if (v207 == null) {
                    Intrinsics.throwNpe();
                }
                canvas.drawCircle(v204, v205, v206, v207);
                v208 = this.debugLinePaint;
                if (v208 == null) {
                    Intrinsics.throwNpe();
                }
                v208.setColor(-65536);
                v209 = vCenterEndRequested;
                if (v209 == null) {
                    Intrinsics.throwNpe();
                }
                v210 = v209.x;
                v211 = vCenterEndRequested.y;
                v212 = this.px(20);
                v213 = this.debugLinePaint;
                if (v213 == null) {
                    Intrinsics.throwNpe();
                }
                canvas.drawCircle(v210, v211, v212, v213);
                v214 = this.debugLinePaint;
                if (v214 == null) {
                    Intrinsics.throwNpe();
                }
                v214.setColor(-16776961);
                v215 = vCenterEnd;
                if (v215 == null) {
                    Intrinsics.throwNpe();
                }
                v216 = v215.x;
                v217 = vCenterEnd.y;
                v218 = this.px(25);
                v219 = this.debugLinePaint;
                if (v219 == null) {
                    Intrinsics.throwNpe();
                }
                canvas.drawCircle(v216, v217, v218, v219);
                v220 = this.debugLinePaint;
                if (v220 == null) {
                    Intrinsics.throwNpe();
                }
                v220.setColor(-16711681);
                v221 = this.getWidth() / 2;
                v222 = this.getHeight() / 2;
                v223 = this.px(30);
                v224 = this.debugLinePaint;
                if (v224 == null) {
                    Intrinsics.throwNpe();
                }
                canvas.drawCircle(v221, v222, v223, v224);
            }
            if (this.vCenterStart != null) {
                v225 = this.debugLinePaint;
                if (v225 == null) {
                    Intrinsics.throwNpe();
                }
                v225.setColor(-65536);
                v226 = this.vCenterStart;
                if (v226 == null) {
                    Intrinsics.throwNpe();
                }
                v227 = v226.x;
                v228 = this.vCenterStart;
                if (v228 == null) {
                    Intrinsics.throwNpe();
                }
                v229 = v228.y;
                v230 = this.px(20);
                v231 = this.debugLinePaint;
                if (v231 == null) {
                    Intrinsics.throwNpe();
                }
                canvas.drawCircle(v227, v229, v230, v231);
            }
            if (this.quickScaleSCenter != null) {
                v232 = this.debugLinePaint;
                if (v232 == null) {
                    Intrinsics.throwNpe();
                }
                v232.setColor(-16776961);
                v233 = this.quickScaleSCenter;
                if (v233 == null) {
                    Intrinsics.throwNpe();
                }
                v234 = this.sourceToViewX(v233.x);
                v235 = this.quickScaleSCenter;
                if (v235 == null) {
                    Intrinsics.throwNpe();
                }
                v236 = this.sourceToViewY(v235.y);
                v237 = this.px(35);
                v238 = this.debugLinePaint;
                if (v238 == null) {
                    Intrinsics.throwNpe();
                }
                canvas.drawCircle(v234, v236, v237, v238);
            }
            if (this.quickScaleVStart != null && this.isQuickScaling) {
                v239 = this.debugLinePaint;
                if (v239 == null) {
                    Intrinsics.throwNpe();
                }
                v239.setColor(-16711681);
                v240 = this.quickScaleVStart;
                if (v240 == null) {
                    Intrinsics.throwNpe();
                }
                v241 = v240.x;
                v242 = this.quickScaleVStart;
                if (v242 == null) {
                    Intrinsics.throwNpe();
                }
                v243 = v242.y;
                v244 = this.px(30);
                v245 = this.debugLinePaint;
                if (v245 == null) {
                    Intrinsics.throwNpe();
                }
                canvas.drawCircle(v241, v243, v244, v245);
            }
            v246 = this.debugLinePaint;
            if (v246 == null) {
                Intrinsics.throwNpe();
            }
            v246.setColor(-65281);
        }
    }

    private final void setMatrixArray(float[] array, float f0, float f1, float f2, float f3, float f4, float f5, float f6, float f7) {
        array[0] = f0;
        array[1] = f1;
        array[2] = f2;
        array[3] = f3;
        array[4] = f4;
        array[5] = f5;
        array[6] = f6;
        array[7] = f7;
    }

    private final boolean checkReady() {
        boolean ready;
        block1: {
            boolean bl = ready = this.getWidth() > 0 && this.getHeight() > 0 && this.sWidth > 0 && this.sHeight > 0 && (this.bitmap != null || this.isBaseLayerReady());
            if (this.isReady || !ready) break block1;
            this.preDraw();
            this.isReady = true;
            this.onReady();
            OnImageEventListener onImageEventListener = this.onImageEventListener;
            if (onImageEventListener != null) {
                onImageEventListener.onReady();
            }
        }
        return ready;
    }

    private final boolean checkImageLoaded() {
        boolean imageLoaded;
        block1: {
            imageLoaded = this.isBaseLayerReady();
            if (this.isImageLoaded || !imageLoaded) break block1;
            this.preDraw();
            this.isImageLoaded = true;
            this.onImageLoaded();
            OnImageEventListener onImageEventListener = this.onImageEventListener;
            if (onImageEventListener != null) {
                onImageEventListener.onImageLoaded();
            }
        }
        return imageLoaded;
    }

    private final void createPaints() {
        Paint paint;
        Paint $receiver;
        SubsamplingScaleImageView subsamplingScaleImageView;
        Paint paint2;
        if (this.bitmapPaint == null) {
            paint2 = new Paint();
            subsamplingScaleImageView = this;
            $receiver = paint2;
            $receiver.setAntiAlias(true);
            $receiver.setFilterBitmap(true);
            $receiver.setDither(true);
            subsamplingScaleImageView.bitmapPaint = paint = paint2;
        }
        if ((this.debugTextPaint == null || this.debugLinePaint == null) && this.debug) {
            paint2 = new Paint();
            subsamplingScaleImageView = this;
            $receiver = paint2;
            $receiver.setTextSize((float)this.px(12));
            $receiver.setColor(-65281);
            $receiver.setStyle(Paint.Style.FILL);
            subsamplingScaleImageView.debugTextPaint = paint = paint2;
            paint2 = new Paint();
            subsamplingScaleImageView = this;
            $receiver = paint2;
            $receiver.setColor(-65281);
            $receiver.setStyle(Paint.Style.STROKE);
            $receiver.setStrokeWidth((float)this.px(1));
            subsamplingScaleImageView.debugLinePaint = paint = paint2;
        }
    }

    private final synchronized void initialiseBaseLayer(Point maxTileDimensions) {
        this.debug("initialiseBaseLayer maxTileDimensions=" + maxTileDimensions.x + 'x' + maxTileDimensions.y);
        ScaleAndTranslate scaleAndTranslate = this.satTemp = new ScaleAndTranslate(0.0f, new PointF(0.0f, 0.0f));
        if (scaleAndTranslate == null) {
            Intrinsics.throwNpe();
        }
        this.fitToBounds(true, scaleAndTranslate);
        ScaleAndTranslate scaleAndTranslate2 = this.satTemp;
        if (scaleAndTranslate2 == null) {
            Intrinsics.throwNpe();
        }
        this.fullImageSampleSize = this.calculateInSampleSize(scaleAndTranslate2.getScale());
        if (this.fullImageSampleSize > 1) {
            this.fullImageSampleSize /= 2;
        }
        if (this.uri == null) {
            return;
        }
        if (this.fullImageSampleSize == 1 && this.sRegion == null && this.sWidth() < maxTileDimensions.x && this.sHeight() < maxTileDimensions.y) {
            ImageRegionDecoder imageRegionDecoder = this.decoder;
            if (imageRegionDecoder == null) {
                Intrinsics.throwNpe();
            }
            imageRegionDecoder.recycle();
            this.decoder = null;
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            Uri uri = this.uri;
            if (uri == null) {
                Intrinsics.throwNpe();
            }
            BitmapLoadTask task = new BitmapLoadTask(this, context, this.bitmapDecoderFactory, uri, false);
            this.execute(task);
        } else {
            List<Tile> baseGrid;
            this.initialiseTileMap(maxTileDimensions);
            Map<Integer, List<Tile>> map = this.tileMap;
            if (map == null) {
                Intrinsics.throwNpe();
            }
            List<Tile> list = baseGrid = map.get(this.fullImageSampleSize);
            if (list == null) {
                Intrinsics.throwNpe();
            }
            for (Tile baseTile : list) {
                ImageRegionDecoder imageRegionDecoder = this.decoder;
                if (imageRegionDecoder == null) {
                    Intrinsics.throwNpe();
                }
                TileLoadTask task = new TileLoadTask(this, imageRegionDecoder, baseTile);
                this.execute(task);
            }
            this.refreshRequiredTiles(true);
        }
    }

    private final void refreshRequiredTiles(boolean load) {
        if (this.decoder == null || this.tileMap == null) {
            return;
        }
        int sampleSize = Math.min(this.fullImageSampleSize, this.calculateInSampleSize(this.scale));
        Map<Integer, List<Tile>> map = this.tileMap;
        if (map == null) {
            Intrinsics.throwNpe();
        }
        Map<Integer, List<Tile>> map2 = map;
        Iterator<Map.Entry<Integer, List<Tile>>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, List<Tile>> entry;
            Map.Entry<Integer, List<Tile>> entry2 = entry = iterator.next();
            int key = ((Number)entry2.getKey()).intValue();
            entry2 = entry;
            List<Tile> value = entry2.getValue();
            for (Tile tile : value) {
                if (tile.getSampleSize() < sampleSize || tile.getSampleSize() > sampleSize && tile.getSampleSize() != this.fullImageSampleSize) {
                    tile.setVisible(false);
                    Bitmap bitmap = tile.getBitmap();
                    if (bitmap != null) {
                        bitmap.recycle();
                    }
                    tile.setBitmap(null);
                }
                if (tile.getSampleSize() == sampleSize) {
                    if (this.tileVisible(tile)) {
                        tile.setVisible(true);
                        if (tile.getLoading() || tile.getBitmap() != null || !load) continue;
                        ImageRegionDecoder imageRegionDecoder = this.decoder;
                        if (imageRegionDecoder == null) {
                            Intrinsics.throwNpe();
                        }
                        TileLoadTask task = new TileLoadTask(this, imageRegionDecoder, tile);
                        this.execute(task);
                        continue;
                    }
                    if (tile.getSampleSize() == this.fullImageSampleSize) continue;
                    tile.setVisible(false);
                    Bitmap bitmap = tile.getBitmap();
                    if (bitmap != null) {
                        bitmap.recycle();
                    }
                    tile.setBitmap(null);
                    continue;
                }
                if (tile.getSampleSize() != this.fullImageSampleSize) continue;
                tile.setVisible(true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean tileVisible(Tile tile) {
        float sVisLeft = this.viewToSourceX(0.0f);
        float sVisRight = this.viewToSourceX(this.getWidth());
        float sVisTop = this.viewToSourceY(0.0f);
        float sVisBottom = this.viewToSourceY(this.getHeight());
        Rect rect = tile.getSRect();
        if (rect == null) {
            Intrinsics.throwNpe();
        }
        if (sVisLeft > (float)rect.right) return false;
        Rect rect2 = tile.getSRect();
        if (rect2 == null) {
            Intrinsics.throwNpe();
        }
        if ((float)rect2.left > sVisRight) return false;
        Rect rect3 = tile.getSRect();
        if (rect3 == null) {
            Intrinsics.throwNpe();
        }
        if (sVisTop > (float)rect3.bottom) return false;
        Rect rect4 = tile.getSRect();
        if (rect4 == null) {
            Intrinsics.throwNpe();
        }
        if ((float)rect4.top > sVisBottom) return false;
        return true;
    }

    private final void preDraw() {
        if (this.getWidth() == 0 || this.getHeight() == 0 || this.sWidth <= 0 || this.sHeight <= 0) {
            return;
        }
        if (this.sPendingCenter != null && this.pendingScale != null) {
            Float f = this.pendingScale;
            if (f == null) {
                Intrinsics.throwNpe();
            }
            this.scale = f.floatValue();
            if (this.vTranslate == null) {
                this.vTranslate = new PointF();
            }
            if (this.vTranslate == null) {
                Intrinsics.throwNpe();
            }
            float f2 = this.getWidth() / 2;
            PointF pointF = this.sPendingCenter;
            if (pointF == null) {
                Intrinsics.throwNpe();
            }
            this.vTranslate.x = f2 - this.scale * pointF.x;
            if (this.vTranslate == null) {
                Intrinsics.throwNpe();
            }
            float f3 = this.getHeight() / 2;
            PointF pointF2 = this.sPendingCenter;
            if (pointF2 == null) {
                Intrinsics.throwNpe();
            }
            this.vTranslate.y = f3 - this.scale * pointF2.y;
            this.sPendingCenter = null;
            this.pendingScale = null;
            this.fitToBounds(true);
            this.refreshRequiredTiles(true);
        }
        this.fitToBounds(false);
    }

    private final int calculateInSampleSize(float scale) {
        float newScale = scale;
        if (this.minimumTileDpi > 0) {
            Resources resources = this.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
            DisplayMetrics metrics = resources.getDisplayMetrics();
            float averageDpi = (metrics.xdpi + metrics.ydpi) / (float)2;
            newScale *= (float)this.minimumTileDpi / averageDpi;
        }
        int reqWidth = (int)((float)this.sWidth() * newScale);
        int reqHeight = (int)((float)this.sHeight() * newScale);
        int inSampleSize = 1;
        if (reqWidth == 0 || reqHeight == 0) {
            return 32;
        }
        if (this.sHeight() > reqHeight || this.sWidth() > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)this.sHeight() / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)this.sWidth() / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        int power = 1;
        while (power * 2 < inSampleSize) {
            power *= 2;
        }
        return power;
    }

    private final void fitToBounds(boolean center, ScaleAndTranslate sat) {
        float maxTy;
        float maxTx;
        float yPaddingRatio;
        PointF vTranslate = sat.getVTranslate();
        float scale = this.limitedScale(sat.getScale());
        float scaleWidth = scale * (float)this.sWidth();
        float scaleHeight = scale * (float)this.sHeight();
        if (center) {
            vTranslate.x = Math.max(vTranslate.x, (float)this.getWidth() - scaleWidth);
            vTranslate.y = Math.max(vTranslate.y, (float)this.getHeight() - scaleHeight);
        } else {
            vTranslate.x = Math.max(vTranslate.x, -scaleWidth);
            vTranslate.y = Math.max(vTranslate.y, -scaleHeight);
        }
        float xPaddingRatio = this.getPaddingLeft() > 0 || this.getPaddingRight() > 0 ? (float)this.getPaddingLeft() / (float)(this.getPaddingLeft() + this.getPaddingRight()) : 0.5f;
        float f = yPaddingRatio = this.getPaddingTop() > 0 || this.getPaddingBottom() > 0 ? (float)this.getPaddingTop() / (float)(this.getPaddingTop() + this.getPaddingBottom()) : 0.5f;
        if (center) {
            maxTx = Math.max(0.0f, ((float)this.getWidth() - scaleWidth) * xPaddingRatio);
            maxTy = Math.max(0.0f, ((float)this.getHeight() - scaleHeight) * yPaddingRatio);
        } else {
            maxTx = Math.max(0, this.getWidth());
            maxTy = Math.max(0, this.getHeight());
        }
        vTranslate.x = Math.min(vTranslate.x, maxTx);
        vTranslate.y = Math.min(vTranslate.y, maxTy);
        sat.setScale(scale);
    }

    private final void fitToBounds(boolean center) {
        boolean init = false;
        if (this.vTranslate == null) {
            init = true;
            this.vTranslate = new PointF(0.0f, 0.0f);
        }
        if (this.satTemp == null) {
            this.satTemp = new ScaleAndTranslate(0.0f, new PointF(0.0f, 0.0f));
        }
        ScaleAndTranslate scaleAndTranslate = this.satTemp;
        if (scaleAndTranslate == null) {
            Intrinsics.throwNpe();
        }
        scaleAndTranslate.setScale(this.scale);
        ScaleAndTranslate scaleAndTranslate2 = this.satTemp;
        if (scaleAndTranslate2 == null) {
            Intrinsics.throwNpe();
        }
        scaleAndTranslate2.getVTranslate().set(this.vTranslate);
        ScaleAndTranslate scaleAndTranslate3 = this.satTemp;
        if (scaleAndTranslate3 == null) {
            Intrinsics.throwNpe();
        }
        this.fitToBounds(center, scaleAndTranslate3);
        ScaleAndTranslate scaleAndTranslate4 = this.satTemp;
        if (scaleAndTranslate4 == null) {
            Intrinsics.throwNpe();
        }
        this.scale = scaleAndTranslate4.getScale();
        PointF pointF = this.vTranslate;
        if (pointF == null) {
            Intrinsics.throwNpe();
        }
        ScaleAndTranslate scaleAndTranslate5 = this.satTemp;
        if (scaleAndTranslate5 == null) {
            Intrinsics.throwNpe();
        }
        pointF.set(scaleAndTranslate5.getVTranslate());
        if (init) {
            PointF pointF2 = this.vTranslate;
            if (pointF2 == null) {
                Intrinsics.throwNpe();
            }
            pointF2.set(this.vTranslateForSCenter(this.sWidth() / 2, this.sHeight() / 2, this.scale));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initialiseTileMap(Point maxTileDimensions) {
        this.debug("initialiseTileMap maxTileDimensions=" + maxTileDimensions.x + 'x' + maxTileDimensions.y);
        this.tileMap = new LinkedHashMap();
        int sampleSize = this.fullImageSampleSize;
        int xTiles = 1;
        int yTiles = 1;
        while (true) {
            Map<Integer, List<Tile>> map;
            int sTileWidth = this.sWidth() / xTiles;
            int sTileHeight = this.sHeight() / yTiles;
            int subTileWidth = sTileWidth / sampleSize;
            int subTileHeight = sTileHeight / sampleSize;
            while (subTileWidth + xTiles + 1 > maxTileDimensions.x || (double)subTileWidth > (double)this.getWidth() * 1.25 && sampleSize < this.fullImageSampleSize) {
                sTileWidth = this.sWidth() / ++xTiles;
                subTileWidth = sTileWidth / sampleSize;
            }
            while (subTileHeight + yTiles + 1 > maxTileDimensions.y || (double)subTileHeight > (double)this.getHeight() * 1.25 && sampleSize < this.fullImageSampleSize) {
                sTileHeight = this.sHeight() / ++yTiles;
                subTileHeight = sTileHeight / sampleSize;
            }
            ArrayList<Tile> tileGrid = new ArrayList<Tile>(xTiles * yTiles);
            int n = 0;
            int n2 = xTiles;
            while (n < n2) {
                void x;
                int n3 = 0;
                int n4 = yTiles;
                while (n3 < n4) {
                    void y;
                    Tile tile = new Tile();
                    tile.setSampleSize(sampleSize);
                    tile.setVisible(sampleSize == this.fullImageSampleSize);
                    tile.setSRect(new Rect((int)(x * sTileWidth), (int)(y * sTileHeight), x == xTiles - 1 ? this.sWidth() : (x + true) * sTileWidth, y == yTiles - 1 ? this.sHeight() : (y + true) * sTileHeight));
                    tile.setVRect(new Rect(0, 0, 0, 0));
                    tile.setFileSRect(new Rect(tile.getSRect()));
                    tileGrid.add(tile);
                    ++y;
                }
                ++x;
            }
            if (this.tileMap == null) {
                Intrinsics.throwNpe();
            }
            Integer n5 = sampleSize;
            ArrayList<Tile> arrayList = tileGrid;
            map.put(n5, arrayList);
            if (sampleSize == 1) break;
            sampleSize /= 2;
        }
    }

    private final synchronized void onTilesInited(ImageRegionDecoder decoder, int sWidth, int sHeight, int sOrientation) {
        this.debug("onTilesInited sWidth=" + sWidth + ", sHeight=" + sHeight + ", sOrientation=" + this.orientation);
        if (this.sWidth > 0 && this.sHeight > 0 && (this.sWidth != sWidth || this.sHeight != sHeight)) {
            this.reset(false);
            if (this.bitmap != null) {
                if (!this.bitmapIsCached) {
                    Bitmap bitmap = this.bitmap;
                    if (bitmap == null) {
                        Intrinsics.throwNpe();
                    }
                    bitmap.recycle();
                }
                this.bitmap = null;
                if (this.bitmapIsCached) {
                    OnImageEventListener onImageEventListener = this.onImageEventListener;
                    if (onImageEventListener != null) {
                        onImageEventListener.onPreviewReleased();
                    }
                }
                this.bitmapIsPreview = false;
                this.bitmapIsCached = false;
            }
        }
        this.decoder = decoder;
        this.sWidth = sWidth;
        this.sHeight = sHeight;
        this.sOrientation = sOrientation;
        this.checkReady();
        if (!this.checkImageLoaded() && this.maxTileWidth > 0 && this.maxTileWidth != Integer.MAX_VALUE && this.maxTileHeight > 0 && this.maxTileHeight != Integer.MAX_VALUE && this.getWidth() > 0 && this.getHeight() > 0) {
            this.initialiseBaseLayer(new Point(this.maxTileWidth, this.maxTileHeight));
        }
        this.invalidate();
        this.requestLayout();
    }

    private final synchronized void onTileLoaded() {
        this.debug("onTileLoaded");
        this.checkReady();
        this.checkImageLoaded();
        if (this.isBaseLayerReady() && this.bitmap != null) {
            if (!this.bitmapIsCached) {
                Bitmap bitmap = this.bitmap;
                if (bitmap == null) {
                    Intrinsics.throwNpe();
                }
                bitmap.recycle();
            }
            this.bitmap = null;
            if (this.bitmapIsCached) {
                OnImageEventListener onImageEventListener = this.onImageEventListener;
                if (onImageEventListener != null) {
                    onImageEventListener.onPreviewReleased();
                }
            }
            this.bitmapIsPreview = false;
            this.bitmapIsCached = false;
        }
        this.invalidate();
    }

    private final synchronized void onPreviewLoaded(Bitmap previewBitmap) {
        Bitmap bitmap;
        this.debug("onPreviewLoaded");
        if (this.bitmap != null || this.isImageLoaded) {
            Bitmap bitmap2 = previewBitmap;
            if (bitmap2 == null) {
                Intrinsics.throwNpe();
            }
            bitmap2.recycle();
            return;
        }
        if (this.pRegion != null) {
            Bitmap bitmap3 = previewBitmap;
            if (bitmap3 == null) {
                Intrinsics.throwNpe();
            }
            Rect rect = this.pRegion;
            if (rect == null) {
                Intrinsics.throwNpe();
            }
            int n = rect.left;
            Rect rect2 = this.pRegion;
            if (rect2 == null) {
                Intrinsics.throwNpe();
            }
            int n2 = rect2.top;
            Rect rect3 = this.pRegion;
            if (rect3 == null) {
                Intrinsics.throwNpe();
            }
            int n3 = rect3.width();
            Rect rect4 = this.pRegion;
            if (rect4 == null) {
                Intrinsics.throwNpe();
            }
            bitmap = Bitmap.createBitmap((Bitmap)bitmap3, (int)n, (int)n2, (int)n3, (int)rect4.height());
        } else {
            bitmap = previewBitmap;
        }
        this.bitmap = bitmap;
        this.bitmapIsPreview = true;
        if (this.checkReady()) {
            this.invalidate();
            this.requestLayout();
        }
    }

    private final synchronized void onImageLoaded(Bitmap bitmap, int sOrientation, boolean bitmapIsCached) {
        this.debug("onImageLoaded");
        if (this.sWidth > 0 && this.sHeight > 0) {
            Bitmap bitmap2 = bitmap;
            if (bitmap2 == null) {
                Intrinsics.throwNpe();
            }
            if (this.sWidth != bitmap2.getWidth() || this.sHeight != bitmap.getHeight()) {
                this.reset(false);
            }
        }
        if (!this.bitmapIsCached) {
            Bitmap bitmap3 = this.bitmap;
            if (bitmap3 != null) {
                bitmap3.recycle();
            }
        }
        if (this.bitmap != null && this.bitmapIsCached) {
            OnImageEventListener onImageEventListener = this.onImageEventListener;
            if (onImageEventListener != null) {
                onImageEventListener.onPreviewReleased();
            }
        }
        this.bitmapIsCached = bitmapIsCached;
        this.bitmap = bitmap;
        this.bitmapIsPreview = false;
        Bitmap bitmap4 = bitmap;
        if (bitmap4 == null) {
            Intrinsics.throwNpe();
        }
        this.sWidth = bitmap4.getWidth();
        this.sHeight = bitmap.getHeight();
        this.sOrientation = sOrientation;
        boolean ready = this.checkReady();
        boolean imageLoaded = this.checkImageLoaded();
        if (ready || imageLoaded) {
            this.invalidate();
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int getExifOrientation(Context context, String sourceUri) {
        int exifOrientation = 0;
        if (StringsKt.startsWith$default((String)sourceUri, (String)"content", (boolean)false, (int)2, null)) {
            Cursor cursor = null;
            try {
                String[] columns = new String[]{"orientation"};
                cursor = context.getContentResolver().query(Uri.parse((String)sourceUri), columns, null, null, null);
                if (cursor == null) return exifOrientation;
                if (!cursor.moveToFirst()) return exifOrientation;
                int orientation = cursor.getInt(0);
                if (VALID_ORIENTATIONS.contains(orientation) && orientation != -1) {
                    exifOrientation = orientation;
                    return exifOrientation;
                }
                Log.w((String)TAG, (String)("Unsupported orientation: " + orientation));
                return exifOrientation;
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Could not get orientation of image from media store");
                return exifOrientation;
            }
            finally {
                Cursor cursor2 = cursor;
                if (cursor2 != null) {
                    cursor2.close();
                }
            }
        }
        if (!StringsKt.startsWith$default((String)sourceUri, (String)ImageSource.Companion.getFILE_SCHEME(), (boolean)false, (int)2, null)) return exifOrientation;
        if (StringsKt.startsWith$default((String)sourceUri, (String)ImageSource.Companion.getASSET_SCHEME(), (boolean)false, (int)2, null)) return exifOrientation;
        try {
            String string;
            String e = sourceUri;
            int n = ImageSource.Companion.getFILE_SCHEME().length() - 1;
            String string2 = e;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String string4 = string = string3;
            ExifInterface exifInterface = new ExifInterface(string4);
            int orientationAttr = exifInterface.getAttributeInt("Orientation", 1);
            if (orientationAttr == 1) return 0;
            if (orientationAttr == 0) {
                return 0;
            }
            if (orientationAttr == 6) {
                return 90;
            }
            if (orientationAttr == 3) {
                return 180;
            }
            if (orientationAttr == 8) {
                return 270;
            }
            Log.w((String)TAG, (String)("Unsupported EXIF orientation: " + orientationAttr));
            return exifOrientation;
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Could not get EXIF orientation of image");
        }
        return exifOrientation;
    }

    private final void execute(AsyncTask<Void, Void, ?> asyncTask) {
        asyncTask.executeOnExecutor(this.executor, (Object[])new Void[0]);
    }

    public final void setMaxTileSize(int maxPixels) {
        this.maxTileWidth = maxPixels;
        this.maxTileHeight = maxPixels;
    }

    public final void setMaxTileSize(int maxPixelsX, int maxPixelsY) {
        this.maxTileWidth = maxPixelsX;
        this.maxTileHeight = maxPixelsY;
    }

    private final Point getMaxBitmapDimensions(Canvas canvas) {
        return new Point(Math.min(canvas.getMaximumBitmapWidth(), this.maxTileWidth), Math.min(canvas.getMaximumBitmapHeight(), this.maxTileHeight));
    }

    private final int sWidth() {
        int rotation = this.getRequiredRotation();
        return rotation == 90 || rotation == 270 ? this.sHeight : this.sWidth;
    }

    private final int sHeight() {
        int rotation = this.getRequiredRotation();
        return rotation == 90 || rotation == 270 ? this.sWidth : this.sHeight;
    }

    private final void fileSRect(Rect sRect, Rect target) {
        switch (this.getRequiredRotation()) {
            case 0: {
                Rect rect = target;
                if (rect == null) {
                    Intrinsics.throwNpe();
                }
                rect.set(sRect);
                break;
            }
            case 90: {
                Rect rect = target;
                if (rect == null) {
                    Intrinsics.throwNpe();
                }
                Rect rect2 = sRect;
                if (rect2 == null) {
                    Intrinsics.throwNpe();
                }
                rect.set(rect2.top, this.sHeight - sRect.right, sRect.bottom, this.sHeight - sRect.left);
                break;
            }
            case 180: {
                Rect rect = target;
                if (rect == null) {
                    Intrinsics.throwNpe();
                }
                Rect rect3 = sRect;
                if (rect3 == null) {
                    Intrinsics.throwNpe();
                }
                rect.set(this.sWidth - rect3.right, this.sHeight - sRect.bottom, this.sWidth - sRect.left, this.sHeight - sRect.top);
                break;
            }
            default: {
                Rect rect = target;
                if (rect == null) {
                    Intrinsics.throwNpe();
                }
                Rect rect4 = sRect;
                if (rect4 == null) {
                    Intrinsics.throwNpe();
                }
                rect.set(this.sWidth - rect4.bottom, sRect.left, this.sWidth - sRect.top, sRect.right);
            }
        }
    }

    private final float distance(float x0, float x1, float y0, float y1) {
        float x = x0 - x1;
        float y = y0 - y1;
        return (float)Math.sqrt(x * x + y * y);
    }

    public final void recycle() {
        this.reset(true);
        this.bitmapPaint = null;
        this.debugTextPaint = null;
        this.debugLinePaint = null;
    }

    private final float viewToSourceX(float vx) {
        float f;
        if (this.vTranslate == null) {
            f = FloatCompanionObject.INSTANCE.getNaN();
        } else {
            PointF pointF = this.vTranslate;
            if (pointF == null) {
                Intrinsics.throwNpe();
            }
            f = (vx - pointF.x) / this.scale;
        }
        return f;
    }

    private final float viewToSourceY(float vy) {
        float f;
        if (this.vTranslate == null) {
            f = FloatCompanionObject.INSTANCE.getNaN();
        } else {
            PointF pointF = this.vTranslate;
            if (pointF == null) {
                Intrinsics.throwNpe();
            }
            f = (vy - pointF.y) / this.scale;
        }
        return f;
    }

    @Nullable
    public final PointF viewToSourceCoord(@NotNull PointF vxy) {
        Intrinsics.checkParameterIsNotNull((Object)vxy, (String)"vxy");
        return this.viewToSourceCoord(vxy.x, vxy.y, new PointF());
    }

    @JvmOverloads
    @Nullable
    public final PointF viewToSourceCoord(float vx, float vy, @NotNull PointF sTarget) {
        Intrinsics.checkParameterIsNotNull((Object)sTarget, (String)"sTarget");
        if (this.vTranslate == null) {
            return null;
        }
        sTarget.set(this.viewToSourceX(vx), this.viewToSourceY(vy));
        return sTarget;
    }

    @JvmOverloads
    @Nullable
    public static /* synthetic */ PointF viewToSourceCoord$default(SubsamplingScaleImageView subsamplingScaleImageView, float f, float f2, PointF pointF, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: viewToSourceCoord");
        }
        if ((n & 4) != 0) {
            pointF = new PointF();
        }
        return subsamplingScaleImageView.viewToSourceCoord(f, f2, pointF);
    }

    @JvmOverloads
    @Nullable
    public final PointF viewToSourceCoord(float vx, float vy) {
        return SubsamplingScaleImageView.viewToSourceCoord$default(this, vx, vy, null, 4, null);
    }

    private final float sourceToViewX(float sx) {
        float f;
        if (this.vTranslate == null) {
            f = FloatCompanionObject.INSTANCE.getNaN();
        } else {
            PointF pointF = this.vTranslate;
            if (pointF == null) {
                Intrinsics.throwNpe();
            }
            f = sx * this.scale + pointF.x;
        }
        return f;
    }

    private final float sourceToViewY(float sy) {
        float f;
        if (this.vTranslate == null) {
            f = FloatCompanionObject.INSTANCE.getNaN();
        } else {
            PointF pointF = this.vTranslate;
            if (pointF == null) {
                Intrinsics.throwNpe();
            }
            f = sy * this.scale + pointF.y;
        }
        return f;
    }

    @Nullable
    public final PointF sourceToViewCoord(@NotNull PointF sxy) {
        Intrinsics.checkParameterIsNotNull((Object)sxy, (String)"sxy");
        return this.sourceToViewCoord(sxy.x, sxy.y, new PointF());
    }

    @Nullable
    public final PointF sourceToViewCoord(@NotNull PointF sxy, @NotNull PointF vTarget) {
        Intrinsics.checkParameterIsNotNull((Object)sxy, (String)"sxy");
        Intrinsics.checkParameterIsNotNull((Object)vTarget, (String)"vTarget");
        return this.sourceToViewCoord(sxy.x, sxy.y, vTarget);
    }

    @JvmOverloads
    @Nullable
    public final PointF sourceToViewCoord(float sx, float sy, @NotNull PointF vTarget) {
        Intrinsics.checkParameterIsNotNull((Object)vTarget, (String)"vTarget");
        if (this.vTranslate == null) {
            return null;
        }
        vTarget.set(this.sourceToViewX(sx), this.sourceToViewY(sy));
        return vTarget;
    }

    @JvmOverloads
    @Nullable
    public static /* synthetic */ PointF sourceToViewCoord$default(SubsamplingScaleImageView subsamplingScaleImageView, float f, float f2, PointF pointF, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sourceToViewCoord");
        }
        if ((n & 4) != 0) {
            pointF = new PointF();
        }
        return subsamplingScaleImageView.sourceToViewCoord(f, f2, pointF);
    }

    @JvmOverloads
    @Nullable
    public final PointF sourceToViewCoord(float sx, float sy) {
        return SubsamplingScaleImageView.sourceToViewCoord$default(this, sx, sy, null, 4, null);
    }

    private final void sourceToViewRect(Rect sRect, Rect vTarget) {
        vTarget.set((int)this.sourceToViewX(sRect.left), (int)this.sourceToViewY(sRect.top), (int)this.sourceToViewX(sRect.right), (int)this.sourceToViewY(sRect.bottom));
    }

    private final PointF vTranslateForSCenter(float sCenterX, float sCenterY, float scale) {
        int vxCenter = this.getPaddingLeft() + (this.getWidth() - this.getPaddingRight() - this.getPaddingLeft()) / 2;
        int vyCenter = this.getPaddingTop() + (this.getHeight() - this.getPaddingBottom() - this.getPaddingTop()) / 2;
        if (this.satTemp == null) {
            this.satTemp = new ScaleAndTranslate(0.0f, new PointF(0.0f, 0.0f));
        }
        ScaleAndTranslate scaleAndTranslate = this.satTemp;
        if (scaleAndTranslate == null) {
            Intrinsics.throwNpe();
        }
        scaleAndTranslate.setScale(scale);
        ScaleAndTranslate scaleAndTranslate2 = this.satTemp;
        if (scaleAndTranslate2 == null) {
            Intrinsics.throwNpe();
        }
        scaleAndTranslate2.getVTranslate().set((float)vxCenter - sCenterX * scale, (float)vyCenter - sCenterY * scale);
        ScaleAndTranslate scaleAndTranslate3 = this.satTemp;
        if (scaleAndTranslate3 == null) {
            Intrinsics.throwNpe();
        }
        this.fitToBounds(true, scaleAndTranslate3);
        ScaleAndTranslate scaleAndTranslate4 = this.satTemp;
        if (scaleAndTranslate4 == null) {
            Intrinsics.throwNpe();
        }
        return scaleAndTranslate4.getVTranslate();
    }

    private final PointF limitedSCenter(float sCenterX, float sCenterY, float scale, PointF sTarget) {
        PointF vTranslate = this.vTranslateForSCenter(sCenterX, sCenterY, scale);
        int vxCenter = this.getPaddingLeft() + (this.getWidth() - this.getPaddingRight() - this.getPaddingLeft()) / 2;
        int vyCenter = this.getPaddingTop() + (this.getHeight() - this.getPaddingBottom() - this.getPaddingTop()) / 2;
        float sx = ((float)vxCenter - vTranslate.x) / scale;
        float sy = ((float)vyCenter - vTranslate.y) / scale;
        sTarget.set(sx, sy);
        return sTarget;
    }

    private final float minScale() {
        int vPadding = this.getPaddingBottom() + this.getPaddingTop();
        int hPadding = this.getPaddingLeft() + this.getPaddingRight();
        return Math.min((float)(this.getWidth() - hPadding) / (float)this.sWidth(), (float)(this.getHeight() - vPadding) / (float)this.sHeight());
    }

    private final float limitedScale(float targetScale) {
        float newTargetScale = targetScale;
        newTargetScale = Math.max(this.minScale(), newTargetScale);
        newTargetScale = Math.min(this.maxScale, newTargetScale);
        return newTargetScale;
    }

    private final float ease(int type, long time, float from, float change, long duration) {
        float f;
        switch (type) {
            case 2: {
                f = this.easeInOutQuad(time, from, change, duration);
                break;
            }
            case 1: {
                f = this.easeOutQuad(time, from, change, duration);
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unexpected easing type: " + type);
            }
        }
        return f;
    }

    private final float easeOutQuad(long time, float from, float change, long duration) {
        float progress = (float)time / (float)duration;
        return -change * progress * (progress - (float)2) + from;
    }

    private final float easeInOutQuad(long time, float from, float change, long duration) {
        float f;
        float timeF = (float)time / ((float)duration / 2.0f);
        if (timeF < 1.0f) {
            f = change / 2.0f * timeF * timeF + from;
        } else {
            float f2 = timeF;
            timeF = f2 + -1.0f;
            f = -change / 2.0f * (timeF * (timeF - (float)2) - 1.0f) + from;
        }
        return f;
    }

    private final void debug(String message) {
        if (this.debug) {
            Log.d((String)TAG, (String)message);
        }
    }

    private final int px(int px) {
        return (int)(this.density * (float)px);
    }

    public final void setRegionDecoderFactory(@NotNull DecoderFactory<ImageRegionDecoder> regionDecoderFactory) {
        Intrinsics.checkParameterIsNotNull(regionDecoderFactory, (String)"regionDecoderFactory");
        this.regionDecoderFactory = regionDecoderFactory;
    }

    public final void setBitmapDecoderFactory(@NotNull DecoderFactory<? extends ImageDecoder> bitmapDecoderFactory) {
        Intrinsics.checkParameterIsNotNull(bitmapDecoderFactory, (String)"bitmapDecoderFactory");
        this.bitmapDecoderFactory = bitmapDecoderFactory;
    }

    public final void setMinScale(float minScale) {
        this.minScale = minScale;
    }

    public final void setMinimumDpi(int dpi) {
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float averageDpi = (metrics.xdpi + metrics.ydpi) / (float)2;
        this.maxScale = averageDpi / (float)dpi;
    }

    public final void setMaximumDpi(int dpi) {
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float averageDpi = (metrics.xdpi + metrics.ydpi) / (float)2;
        this.setMinScale(averageDpi / (float)dpi);
    }

    public final float getMinScale() {
        return this.minScale();
    }

    public final void setMinimumTileDpi(int minimumTileDpi) {
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float averageDpi = (metrics.xdpi + metrics.ydpi) / (float)2;
        this.minimumTileDpi = (int)Math.min(averageDpi, (float)minimumTileDpi);
        if (this.isReady) {
            this.reset(false);
            this.invalidate();
        }
    }

    public final void setScaleAndCenter(float scale, @Nullable PointF sCenter) {
        this.anim = null;
        this.pendingScale = Float.valueOf(scale);
        this.sPendingCenter = sCenter;
        this.sRequestedCenter = sCenter;
        this.invalidate();
    }

    public final void resetScaleAndCenter() {
        this.anim = null;
        this.pendingScale = Float.valueOf(this.limitedScale(0.0f));
        this.sPendingCenter = this.isReady ? new PointF((float)(this.sWidth() / 2), (float)(this.sHeight() / 2)) : new PointF(0.0f, 0.0f);
        this.invalidate();
    }

    protected final void onReady() {
    }

    protected final void onImageLoaded() {
    }

    public final int getOrientation() {
        return this.orientation;
    }

    public final void setDoubleTapZoomScale(float doubleTapZoomScale) {
        this.doubleTapZoomScale = doubleTapZoomScale;
    }

    public final void setDoubleTapZoomDpi(int dpi) {
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float averageDpi = (metrics.xdpi + metrics.ydpi) / (float)2;
        this.setDoubleTapZoomScale(averageDpi / (float)dpi);
    }

    public final void setResetScaleOnSizeChange(boolean resetScaleOnSizeChange) {
        this.resetScaleOnSizeChange = resetScaleOnSizeChange;
    }

    public final void setExecutor(@NotNull Executor executor) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        this.executor = executor;
    }

    public final void setEagerLoadingEnabled(boolean eagerLoadingEnabled) {
        this.eagerLoadingEnabled = eagerLoadingEnabled;
    }

    public final void setDebug(boolean debug) {
        this.debug = debug;
    }

    public final void setOnImageEventListener(@NotNull OnImageEventListener onImageEventListener) {
        Intrinsics.checkParameterIsNotNull((Object)onImageEventListener, (String)"onImageEventListener");
        this.onImageEventListener = onImageEventListener;
    }

    @Nullable
    public final AnimationBuilder animateScaleAndCenter(float scale, @NotNull PointF sCenter) {
        Intrinsics.checkParameterIsNotNull((Object)sCenter, (String)"sCenter");
        return !this.isReady ? null : new AnimationBuilder(scale, sCenter);
    }

    @JvmOverloads
    public SubsamplingScaleImageView(@NotNull Context context, @Nullable AttributeSet attr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attr);
        this.maxScale = 2.0f;
        this.minScale = this.minScale();
        this.minimumTileDpi = -1;
        this.maxTileWidth = Integer.MAX_VALUE;
        this.maxTileHeight = Integer.MAX_VALUE;
        this.executor = AsyncTask.THREAD_POOL_EXECUTOR;
        this.eagerLoadingEnabled = true;
        this.isZoomEnabled = true;
        this.isQuickScaleEnabled = true;
        this.DOUBLE_TAP_ZOOM_DURATION = 500L;
        this.doubleTapZoomScale = 1.0f;
        this.decoderLock = new ReentrantReadWriteLock(true);
        this.bitmapDecoderFactory = new CompatDecoderFactory<SkiaImageDecoder>(SkiaImageDecoder.class);
        this.regionDecoderFactory = new CompatDecoderFactory<SkiaImageRegionDecoder>(SkiaImageRegionDecoder.class);
        this.srcArray = new float[8];
        this.dstArray = new float[8];
        this.resetScaleOnSizeChange = true;
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        this.density = resources.getDisplayMetrics().density;
        this.setMinimumDpi(160);
        this.setDoubleTapZoomDpi(160);
        this.setMinimumTileDpi(320);
        this.setGestureDetector(context);
        Resources resources2 = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources2, (String)"context.resources");
        this.quickScaleThreshold = TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)resources2.getDisplayMetrics());
    }

    @JvmOverloads
    public /* synthetic */ SubsamplingScaleImageView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    @JvmOverloads
    public SubsamplingScaleImageView(@NotNull Context context) {
        this(context, null, 2, null);
    }

    static {
        Companion = new Companion(null);
        TAG = SubsamplingScaleImageView.class.getSimpleName();
        VALID_ORIENTATIONS = Arrays.asList(0, 90, 180, 270, -1);
        VALID_EASING_STYLES = Arrays.asList(2, 1);
    }

    public static final /* synthetic */ void access$setSRegion$p(SubsamplingScaleImageView $this, @Nullable Rect rect) {
        $this.sRegion = rect;
    }

    public static final /* synthetic */ void access$setOnImageEventListener$p(SubsamplingScaleImageView $this, @Nullable OnImageEventListener onImageEventListener) {
        $this.onImageEventListener = onImageEventListener;
    }

    @Nullable
    public static final /* synthetic */ PointF access$getVTranslate$p(SubsamplingScaleImageView $this) {
        return $this.vTranslate;
    }

    public static final /* synthetic */ void access$setVTranslate$p(SubsamplingScaleImageView $this, @Nullable PointF pointF) {
        $this.vTranslate = pointF;
    }

    public static final /* synthetic */ boolean access$isZooming$p(SubsamplingScaleImageView $this) {
        return $this.isZooming;
    }

    public static final /* synthetic */ void access$setZooming$p(SubsamplingScaleImageView $this, boolean bl) {
        $this.isZooming = bl;
    }

    public static final /* synthetic */ void access$setGestureDetector(SubsamplingScaleImageView $this, @NotNull Context context) {
        $this.setGestureDetector(context);
    }

    @Nullable
    public static final /* synthetic */ PointF access$getVCenterStart$p(SubsamplingScaleImageView $this) {
        return $this.vCenterStart;
    }

    public static final /* synthetic */ void access$setVCenterStart$p(SubsamplingScaleImageView $this, @Nullable PointF pointF) {
        $this.vCenterStart = pointF;
    }

    @Nullable
    public static final /* synthetic */ PointF access$getVTranslateStart$p(SubsamplingScaleImageView $this) {
        return $this.vTranslateStart;
    }

    public static final /* synthetic */ void access$setVTranslateStart$p(SubsamplingScaleImageView $this, @Nullable PointF pointF) {
        $this.vTranslateStart = pointF;
    }

    public static final /* synthetic */ float access$getScaleStart$p(SubsamplingScaleImageView $this) {
        return $this.scaleStart;
    }

    public static final /* synthetic */ void access$setScaleStart$p(SubsamplingScaleImageView $this, float f) {
        $this.scaleStart = f;
    }

    public static final /* synthetic */ boolean access$isQuickScaling$p(SubsamplingScaleImageView $this) {
        return $this.isQuickScaling;
    }

    public static final /* synthetic */ void access$setQuickScaling$p(SubsamplingScaleImageView $this, boolean bl) {
        $this.isQuickScaling = bl;
    }

    public static final /* synthetic */ float access$getQuickScaleLastDistance$p(SubsamplingScaleImageView $this) {
        return $this.quickScaleLastDistance;
    }

    public static final /* synthetic */ void access$setQuickScaleLastDistance$p(SubsamplingScaleImageView $this, float f) {
        $this.quickScaleLastDistance = f;
    }

    @Nullable
    public static final /* synthetic */ PointF access$getQuickScaleSCenter$p(SubsamplingScaleImageView $this) {
        return $this.quickScaleSCenter;
    }

    public static final /* synthetic */ void access$setQuickScaleSCenter$p(SubsamplingScaleImageView $this, @Nullable PointF pointF) {
        $this.quickScaleSCenter = pointF;
    }

    @Nullable
    public static final /* synthetic */ PointF access$getQuickScaleVStart$p(SubsamplingScaleImageView $this) {
        return $this.quickScaleVStart;
    }

    public static final /* synthetic */ void access$setQuickScaleVStart$p(SubsamplingScaleImageView $this, @Nullable PointF pointF) {
        $this.quickScaleVStart = pointF;
    }

    @Nullable
    public static final /* synthetic */ PointF access$getQuickScaleVLastPoint$p(SubsamplingScaleImageView $this) {
        return $this.quickScaleVLastPoint;
    }

    public static final /* synthetic */ void access$setQuickScaleVLastPoint$p(SubsamplingScaleImageView $this, @Nullable PointF pointF) {
        $this.quickScaleVLastPoint = pointF;
    }

    public static final /* synthetic */ boolean access$getQuickScaleMoved$p(SubsamplingScaleImageView $this) {
        return $this.quickScaleMoved;
    }

    public static final /* synthetic */ void access$setQuickScaleMoved$p(SubsamplingScaleImageView $this, boolean bl) {
        $this.quickScaleMoved = bl;
    }

    public static final /* synthetic */ void access$doubleTapZoom(SubsamplingScaleImageView $this, @Nullable PointF sCenter, @Nullable PointF vFocus) {
        $this.doubleTapZoom(sCenter, vFocus);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B/\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ#\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0019\"\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u0014R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00070\u00070\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\u0012\u001a \u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\n \u0010*\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\t0\t0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00050\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView$TilesInitTask;", "Landroid/os/AsyncTask;", "Ljava/lang/Void;", "", "view", "Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView;", "context", "Landroid/content/Context;", "decoderFactory", "Lcom/davemorrissey/labs/subscaleview/decoder/DecoderFactory;", "Lcom/davemorrissey/labs/subscaleview/decoder/ImageRegionDecoder;", "source", "Landroid/net/Uri;", "(Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView;Landroid/content/Context;Lcom/davemorrissey/labs/subscaleview/decoder/DecoderFactory;Landroid/net/Uri;)V", "contextRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "decoder", "decoderFactoryRef", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "viewRef", "doInBackground", "params", "", "([Ljava/lang/Void;)[I", "onPostExecute", "", "xyo", "subsampling-scale-image-view_release"})
    private static final class TilesInitTask
    extends AsyncTask<Void, Void, int[]> {
        private final WeakReference<SubsamplingScaleImageView> viewRef;
        private final WeakReference<Context> contextRef;
        private final WeakReference<DecoderFactory<? extends ImageRegionDecoder>> decoderFactoryRef;
        private ImageRegionDecoder decoder;
        private Exception exception;
        private final Uri source;

        @Nullable
        protected int[] doInBackground(Void ... params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            try {
                String string = this.source.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"source.toString()");
                String sourceUri = string;
                Context context = (Context)this.contextRef.get();
                DecoderFactory decoderFactory = (DecoderFactory)this.decoderFactoryRef.get();
                SubsamplingScaleImageView view = (SubsamplingScaleImageView)((Object)this.viewRef.get());
                if (context != null && decoderFactory != null && view != null) {
                    view.debug("TilesInitTask.doInBackground");
                    ImageRegionDecoder imageRegionDecoder = this.decoder = (ImageRegionDecoder)decoderFactory.make();
                    if (imageRegionDecoder == null) {
                        Intrinsics.throwNpe();
                    }
                    Point dimensions = imageRegionDecoder.init(context, this.source);
                    int sWidth = dimensions.x;
                    int sHeight = dimensions.y;
                    int exifOrientation = view.getExifOrientation(context, sourceUri);
                    Rect rect = view.sRegion;
                    if (rect != null) {
                        Rect rect2;
                        Rect $receiver = rect2 = rect;
                        $receiver.left = Math.max(0, $receiver.left);
                        $receiver.top = Math.max(0, $receiver.top);
                        $receiver.right = Math.min(sWidth, $receiver.right);
                        $receiver.bottom = Math.min(sHeight, $receiver.bottom);
                        sWidth = $receiver.width();
                        sHeight = $receiver.height();
                    }
                    return new int[]{sWidth, sHeight, exifOrientation};
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Failed to initialise bitmap decoder", (Throwable)e);
                this.exception = e;
            }
            return null;
        }

        protected void onPostExecute(@Nullable int[] xyo) {
            block3: {
                SubsamplingScaleImageView view;
                block4: {
                    view = (SubsamplingScaleImageView)((Object)this.viewRef.get());
                    if (view == null) break block3;
                    if (this.decoder == null || xyo == null || xyo.length != 3) break block4;
                    ImageRegionDecoder imageRegionDecoder = this.decoder;
                    if (imageRegionDecoder == null) {
                        Intrinsics.throwNpe();
                    }
                    view.onTilesInited(imageRegionDecoder, xyo[0], xyo[1], xyo[2]);
                    break block3;
                }
                if (this.exception == null) break block3;
                OnImageEventListener onImageEventListener = view.onImageEventListener;
                if (onImageEventListener != null) {
                    Exception exception = this.exception;
                    if (exception == null) {
                        Intrinsics.throwNpe();
                    }
                    onImageEventListener.onImageLoadError(exception);
                }
            }
        }

        public TilesInitTask(@NotNull SubsamplingScaleImageView view, @NotNull Context context, @NotNull DecoderFactory<? extends ImageRegionDecoder> decoderFactory, @NotNull Uri source) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)view), (String)"view");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull(decoderFactory, (String)"decoderFactory");
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            this.source = source;
            this.viewRef = new WeakReference<SubsamplingScaleImageView>(view);
            this.contextRef = new WeakReference<Context>(context);
            this.decoderFactoryRef = new WeakReference<DecoderFactory<? extends ImageRegionDecoder>>(decoderFactory);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ#\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0015\"\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u0014R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00070\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\t0\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00050\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView$TileLoadTask;", "Landroid/os/AsyncTask;", "Ljava/lang/Void;", "Landroid/graphics/Bitmap;", "view", "Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView;", "decoder", "Lcom/davemorrissey/labs/subscaleview/decoder/ImageRegionDecoder;", "tile", "Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView$Tile;", "(Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView;Lcom/davemorrissey/labs/subscaleview/decoder/ImageRegionDecoder;Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView$Tile;)V", "decoderRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "tileRef", "viewRef", "doInBackground", "params", "", "([Ljava/lang/Void;)Landroid/graphics/Bitmap;", "onPostExecute", "", "bitmap", "subsampling-scale-image-view_release"})
    private static final class TileLoadTask
    extends AsyncTask<Void, Void, Bitmap> {
        private final WeakReference<SubsamplingScaleImageView> viewRef;
        private final WeakReference<ImageRegionDecoder> decoderRef;
        private final WeakReference<Tile> tileRef;
        private Exception exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        protected Bitmap doInBackground(Void ... params) {
            block17: {
                Tile tile;
                block16: {
                    Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
                    SubsamplingScaleImageView view = (SubsamplingScaleImageView)((Object)this.viewRef.get());
                    ImageRegionDecoder decoder = (ImageRegionDecoder)this.decoderRef.get();
                    tile = (Tile)this.tileRef.get();
                    if (decoder == null || tile == null || view == null || !decoder.isReady() || !tile.getVisible()) break block16;
                    Rect rect = tile.getSRect();
                    if (rect == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.graphics.Rect");
                    }
                    view.debug("TileLoadTask.doInBackground, tile.sRect=" + rect + ", tile.sampleSize=" + tile.getSampleSize());
                    view.decoderLock.readLock().lock();
                    try {
                        if (decoder.isReady()) {
                            view.fileSRect(tile.getSRect(), tile.getFileSRect());
                            if (view.sRegion != null) {
                                Rect rect2 = tile.getFileSRect();
                                if (rect2 == null) {
                                    Intrinsics.throwNpe();
                                }
                                Rect rect3 = view.sRegion;
                                if (rect3 == null) {
                                    Intrinsics.throwNpe();
                                }
                                int n = rect3.left;
                                Rect rect4 = view.sRegion;
                                if (rect4 == null) {
                                    Intrinsics.throwNpe();
                                }
                                rect2.offset(n, rect4.top);
                            }
                            Rect rect5 = tile.getFileSRect();
                            if (rect5 == null) {
                                Intrinsics.throwNpe();
                            }
                            Bitmap bitmap = decoder.decodeRegion(rect5, tile.getSampleSize());
                            return bitmap;
                        }
                        tile.setLoading(false);
                        break block17;
                    }
                    finally {
                        view.decoderLock.readLock().unlock();
                    }
                }
                try {
                    Tile tile2 = tile;
                    if (tile2 != null) {
                        tile2.setLoading(false);
                    }
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Failed to decode tile", (Throwable)e);
                    this.exception = e;
                }
                catch (OutOfMemoryError e) {
                    Log.e((String)TAG, (String)"Failed to decode tile - OutOfMemoryError", (Throwable)e);
                    this.exception = new RuntimeException(e);
                }
            }
            return null;
        }

        protected void onPostExecute(@Nullable Bitmap bitmap) {
            block2: {
                SubsamplingScaleImageView subsamplingScaleImageView;
                block3: {
                    subsamplingScaleImageView = (SubsamplingScaleImageView)((Object)this.viewRef.get());
                    Tile tile = (Tile)this.tileRef.get();
                    if (subsamplingScaleImageView == null || tile == null) break block2;
                    if (bitmap == null) break block3;
                    tile.setBitmap(bitmap);
                    tile.setLoading(false);
                    subsamplingScaleImageView.onTileLoaded();
                    break block2;
                }
                if (this.exception == null) break block2;
                OnImageEventListener onImageEventListener = subsamplingScaleImageView.onImageEventListener;
                if (onImageEventListener != null) {
                    Exception exception = this.exception;
                    if (exception == null) {
                        Intrinsics.throwNpe();
                    }
                    onImageEventListener.onTileLoadError(exception);
                }
            }
        }

        public TileLoadTask(@NotNull SubsamplingScaleImageView view, @NotNull ImageRegionDecoder decoder, @NotNull Tile tile) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)view), (String)"view");
            Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
            Intrinsics.checkParameterIsNotNull((Object)tile, (String)"tile");
            this.viewRef = new WeakReference<SubsamplingScaleImageView>(view);
            this.decoderRef = new WeakReference<ImageRegionDecoder>(decoder);
            this.tileRef = new WeakReference<Tile>(tile);
            tile.setLoading(true);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B7\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ#\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u001c\"\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0003H\u0014\u00a2\u0006\u0002\u0010!R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00070\u00070\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0015\u001a \u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\n \u0014*\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\t0\t0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0018\u00010\u0017j\u0004\u0018\u0001`\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00050\u00050\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView$BitmapLoadTask;", "Landroid/os/AsyncTask;", "Ljava/lang/Void;", "", "view", "Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView;", "context", "Landroid/content/Context;", "decoderFactory", "Lcom/davemorrissey/labs/subscaleview/decoder/DecoderFactory;", "Lcom/davemorrissey/labs/subscaleview/decoder/ImageDecoder;", "source", "Landroid/net/Uri;", "preview", "", "(Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView;Landroid/content/Context;Lcom/davemorrissey/labs/subscaleview/decoder/DecoderFactory;Landroid/net/Uri;Z)V", "bitmap", "Landroid/graphics/Bitmap;", "contextRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "decoderFactoryRef", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "viewRef", "doInBackground", "params", "", "([Ljava/lang/Void;)Ljava/lang/Integer;", "onPostExecute", "", "orientation", "(Ljava/lang/Integer;)V", "subsampling-scale-image-view_release"})
    private static final class BitmapLoadTask
    extends AsyncTask<Void, Void, Integer> {
        private final WeakReference<SubsamplingScaleImageView> viewRef;
        private final WeakReference<Context> contextRef;
        private final WeakReference<DecoderFactory<? extends ImageDecoder>> decoderFactoryRef;
        private Bitmap bitmap;
        private Exception exception;
        private final Uri source;
        private final boolean preview;

        @Nullable
        protected Integer doInBackground(Void ... params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            try {
                String string = this.source.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"source.toString()");
                String sourceUri = string;
                Context context = (Context)this.contextRef.get();
                DecoderFactory decoderFactory = (DecoderFactory)this.decoderFactoryRef.get();
                SubsamplingScaleImageView view = (SubsamplingScaleImageView)((Object)this.viewRef.get());
                if (context != null && decoderFactory != null && view != null) {
                    view.debug("BitmapLoadTask.doInBackground");
                    this.bitmap = ((ImageDecoder)decoderFactory.make()).decode(context, this.source);
                    return view.getExifOrientation(context, sourceUri);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Failed to load bitmap", (Throwable)e);
                this.exception = e;
            }
            catch (OutOfMemoryError e) {
                Log.e((String)TAG, (String)"Failed to load bitmap - OutOfMemoryError", (Throwable)e);
                this.exception = new RuntimeException(e);
            }
            return null;
        }

        protected void onPostExecute(@Nullable Integer orientation) {
            block4: {
                SubsamplingScaleImageView subsamplingScaleImageView;
                block5: {
                    block2: {
                        block3: {
                            subsamplingScaleImageView = (SubsamplingScaleImageView)((Object)this.viewRef.get());
                            if (this.bitmap == null || orientation == null) break block2;
                            if (!this.preview) break block3;
                            SubsamplingScaleImageView subsamplingScaleImageView2 = subsamplingScaleImageView;
                            if (subsamplingScaleImageView2 == null) break block4;
                            subsamplingScaleImageView2.onPreviewLoaded(this.bitmap);
                            break block4;
                        }
                        SubsamplingScaleImageView subsamplingScaleImageView3 = subsamplingScaleImageView;
                        if (subsamplingScaleImageView3 == null) break block4;
                        subsamplingScaleImageView3.onImageLoaded(this.bitmap, orientation, false);
                        break block4;
                    }
                    if (this.exception == null) break block4;
                    if (!this.preview) break block5;
                    Object object = subsamplingScaleImageView;
                    if (object == null || (object = ((SubsamplingScaleImageView)object).onImageEventListener) == null) break block4;
                    Exception exception = this.exception;
                    if (exception == null) {
                        Intrinsics.throwNpe();
                    }
                    object.onPreviewLoadError(exception);
                    break block4;
                }
                Object object = subsamplingScaleImageView;
                if (object == null || (object = ((SubsamplingScaleImageView)object).onImageEventListener) == null) break block4;
                Exception exception = this.exception;
                if (exception == null) {
                    Intrinsics.throwNpe();
                }
                object.onImageLoadError(exception);
            }
        }

        public BitmapLoadTask(@NotNull SubsamplingScaleImageView view, @NotNull Context context, @NotNull DecoderFactory<? extends ImageDecoder> decoderFactory, @NotNull Uri source, boolean preview) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)view), (String)"view");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull(decoderFactory, (String)"decoderFactory");
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            this.source = source;
            this.preview = preview;
            this.viewRef = new WeakReference<SubsamplingScaleImageView>(view);
            this.contextRef = new WeakReference<Context>(context);
            this.decoderFactoryRef = new WeakReference<DecoderFactory<? extends ImageDecoder>>(decoderFactory);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\f\"\u0004\b \u0010\u000eR\u001a\u0010!\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0012\"\u0004\b#\u0010\u0014\u00a8\u0006$"}, d2={"Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView$Tile;", "", "()V", "bitmap", "Landroid/graphics/Bitmap;", "getBitmap", "()Landroid/graphics/Bitmap;", "setBitmap", "(Landroid/graphics/Bitmap;)V", "fileSRect", "Landroid/graphics/Rect;", "getFileSRect", "()Landroid/graphics/Rect;", "setFileSRect", "(Landroid/graphics/Rect;)V", "loading", "", "getLoading", "()Z", "setLoading", "(Z)V", "sRect", "getSRect", "setSRect", "sampleSize", "", "getSampleSize", "()I", "setSampleSize", "(I)V", "vRect", "getVRect", "setVRect", "visible", "getVisible", "setVisible", "subsampling-scale-image-view_release"})
    public static final class Tile {
        @Nullable
        private Rect sRect;
        private int sampleSize;
        @Nullable
        private Bitmap bitmap;
        private boolean loading;
        private boolean visible;
        @Nullable
        private Rect vRect;
        @Nullable
        private Rect fileSRect;

        @Nullable
        public final Rect getSRect() {
            return this.sRect;
        }

        public final void setSRect(@Nullable Rect rect) {
            this.sRect = rect;
        }

        public final int getSampleSize() {
            return this.sampleSize;
        }

        public final void setSampleSize(int n) {
            this.sampleSize = n;
        }

        @Nullable
        public final Bitmap getBitmap() {
            return this.bitmap;
        }

        public final void setBitmap(@Nullable Bitmap bitmap) {
            this.bitmap = bitmap;
        }

        public final boolean getLoading() {
            return this.loading;
        }

        public final void setLoading(boolean bl) {
            this.loading = bl;
        }

        public final boolean getVisible() {
            return this.visible;
        }

        public final void setVisible(boolean bl) {
            this.visible = bl;
        }

        @Nullable
        public final Rect getVRect() {
            return this.vRect;
        }

        public final void setVRect(@Nullable Rect rect) {
            this.vRect = rect;
        }

        @Nullable
        public final Rect getFileSRect() {
            return this.fileSRect;
        }

        public final void setFileSRect(@Nullable Rect rect) {
            this.fileSRect = rect;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u001c\u0010!\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001dR\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010'\"\u0004\b,\u0010)R\u001a\u0010-\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0006\"\u0004\b/\u0010\bR\u001c\u00100\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u001b\"\u0004\b2\u0010\u001dR\u001c\u00103\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u001b\"\u0004\b5\u0010\u001d\u00a8\u00066"}, d2={"Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView$Anim;", "", "()V", "duration", "", "getDuration", "()J", "setDuration", "(J)V", "easing", "", "getEasing", "()I", "setEasing", "(I)V", "interruptible", "", "getInterruptible", "()Z", "setInterruptible", "(Z)V", "origin", "getOrigin", "setOrigin", "sCenterEnd", "Landroid/graphics/PointF;", "getSCenterEnd", "()Landroid/graphics/PointF;", "setSCenterEnd", "(Landroid/graphics/PointF;)V", "sCenterEndRequested", "getSCenterEndRequested", "setSCenterEndRequested", "sCenterStart", "getSCenterStart", "setSCenterStart", "scaleEnd", "", "getScaleEnd", "()F", "setScaleEnd", "(F)V", "scaleStart", "getScaleStart", "setScaleStart", "time", "getTime", "setTime", "vFocusEnd", "getVFocusEnd", "setVFocusEnd", "vFocusStart", "getVFocusStart", "setVFocusStart", "subsampling-scale-image-view_release"})
    public static final class Anim {
        private float scaleStart;
        private float scaleEnd;
        @Nullable
        private PointF sCenterStart;
        @Nullable
        private PointF sCenterEnd;
        @Nullable
        private PointF sCenterEndRequested;
        @Nullable
        private PointF vFocusStart;
        @Nullable
        private PointF vFocusEnd;
        private long duration = 500L;
        private boolean interruptible = true;
        private int easing = 2;
        private int origin = 1;
        private long time = System.currentTimeMillis();

        public final float getScaleStart() {
            return this.scaleStart;
        }

        public final void setScaleStart(float f) {
            this.scaleStart = f;
        }

        public final float getScaleEnd() {
            return this.scaleEnd;
        }

        public final void setScaleEnd(float f) {
            this.scaleEnd = f;
        }

        @Nullable
        public final PointF getSCenterStart() {
            return this.sCenterStart;
        }

        public final void setSCenterStart(@Nullable PointF pointF) {
            this.sCenterStart = pointF;
        }

        @Nullable
        public final PointF getSCenterEnd() {
            return this.sCenterEnd;
        }

        public final void setSCenterEnd(@Nullable PointF pointF) {
            this.sCenterEnd = pointF;
        }

        @Nullable
        public final PointF getSCenterEndRequested() {
            return this.sCenterEndRequested;
        }

        public final void setSCenterEndRequested(@Nullable PointF pointF) {
            this.sCenterEndRequested = pointF;
        }

        @Nullable
        public final PointF getVFocusStart() {
            return this.vFocusStart;
        }

        public final void setVFocusStart(@Nullable PointF pointF) {
            this.vFocusStart = pointF;
        }

        @Nullable
        public final PointF getVFocusEnd() {
            return this.vFocusEnd;
        }

        public final void setVFocusEnd(@Nullable PointF pointF) {
            this.vFocusEnd = pointF;
        }

        public final long getDuration() {
            return this.duration;
        }

        public final void setDuration(long l) {
            this.duration = l;
        }

        public final boolean getInterruptible() {
            return this.interruptible;
        }

        public final void setInterruptible(boolean bl) {
            this.interruptible = bl;
        }

        public final int getEasing() {
            return this.easing;
        }

        public final void setEasing(int n) {
            this.easing = n;
        }

        public final int getOrigin() {
            return this.origin;
        }

        public final void setOrigin(int n) {
            this.origin = n;
        }

        public final long getTime() {
            return this.time;
        }

        public final void setTime(long l) {
            this.time = l;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView$ScaleAndTranslate;", "", "scale", "", "vTranslate", "Landroid/graphics/PointF;", "(FLandroid/graphics/PointF;)V", "getScale", "()F", "setScale", "(F)V", "getVTranslate", "()Landroid/graphics/PointF;", "setVTranslate", "(Landroid/graphics/PointF;)V", "subsampling-scale-image-view_release"})
    public static final class ScaleAndTranslate {
        private float scale;
        @NotNull
        private PointF vTranslate;

        public final float getScale() {
            return this.scale;
        }

        public final void setScale(float f) {
            this.scale = f;
        }

        @NotNull
        public final PointF getVTranslate() {
            return this.vTranslate;
        }

        public final void setVTranslate(@NotNull PointF pointF) {
            Intrinsics.checkParameterIsNotNull((Object)pointF, (String)"<set-?>");
            this.vTranslate = pointF;
        }

        public ScaleAndTranslate(float scale, @NotNull PointF vTranslate) {
            Intrinsics.checkParameterIsNotNull((Object)vTranslate, (String)"vTranslate");
            this.scale = scale;
            this.vTranslate = vTranslate;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u0015\u001a\u00060\u0000R\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\u0017\u001a\u00060\u0000R\u00020\u00162\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u0018\u001a\u00060\u0000R\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0019\u001a\u00060\u0000R\u00020\u00162\u0006\u0010\u0010\u001a\u00020\rR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView$AnimationBuilder;", "", "sCenter", "Landroid/graphics/PointF;", "(Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView;Landroid/graphics/PointF;)V", "scale", "", "(Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView;FLandroid/graphics/PointF;)V", "vFocus", "(Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView;FLandroid/graphics/PointF;Landroid/graphics/PointF;)V", "duration", "", "easing", "", "interruptible", "", "origin", "targetSCenter", "targetScale", "start", "", "withDuration", "Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView;", "withEasing", "withInterruptible", "withOrigin", "subsampling-scale-image-view_release"})
    public final class AnimationBuilder {
        private final float targetScale;
        private final PointF targetSCenter;
        private final PointF vFocus;
        private long duration;
        private int easing;
        private int origin;
        private boolean interruptible;

        @NotNull
        public final AnimationBuilder withDuration(long duration) {
            this.duration = duration;
            return this;
        }

        @NotNull
        public final AnimationBuilder withInterruptible(boolean interruptible) {
            this.interruptible = interruptible;
            return this;
        }

        @NotNull
        public final AnimationBuilder withEasing(int easing) {
            if (!VALID_EASING_STYLES.contains(easing)) {
                throw (Throwable)new IllegalArgumentException("Unknown easing type: " + easing);
            }
            this.easing = easing;
            return this;
        }

        @NotNull
        public final AnimationBuilder withOrigin(int origin) {
            this.origin = origin;
            return this;
        }

        public final void start() {
            int vxCenter = SubsamplingScaleImageView.this.getPaddingLeft() + (SubsamplingScaleImageView.this.getWidth() - SubsamplingScaleImageView.this.getPaddingRight() - SubsamplingScaleImageView.this.getPaddingLeft()) / 2;
            int vyCenter = SubsamplingScaleImageView.this.getPaddingTop() + (SubsamplingScaleImageView.this.getHeight() - SubsamplingScaleImageView.this.getPaddingBottom() - SubsamplingScaleImageView.this.getPaddingTop()) / 2;
            float targetScale = SubsamplingScaleImageView.this.limitedScale(this.targetScale);
            PointF pointF = this.targetSCenter;
            if (pointF == null) {
                Intrinsics.throwNpe();
            }
            PointF targetSCenter = SubsamplingScaleImageView.this.limitedSCenter(pointF.x, this.targetSCenter.y, targetScale, new PointF());
            Anim anim = new Anim();
            SubsamplingScaleImageView subsamplingScaleImageView = SubsamplingScaleImageView.this;
            Anim $receiver = anim;
            $receiver.setScaleStart(SubsamplingScaleImageView.this.getScale());
            $receiver.setScaleEnd(targetScale);
            $receiver.setTime(System.currentTimeMillis());
            $receiver.setSCenterEndRequested(targetSCenter);
            $receiver.setSCenterStart(SubsamplingScaleImageView.this.getCenter());
            $receiver.setSCenterEnd(targetSCenter);
            $receiver.setVFocusStart(SubsamplingScaleImageView.this.sourceToViewCoord(targetSCenter));
            $receiver.setVFocusEnd(new PointF((float)vxCenter, (float)vyCenter));
            $receiver.setTime(System.currentTimeMillis());
            Anim anim2 = anim;
            subsamplingScaleImageView.anim = anim2;
            Anim anim3 = SubsamplingScaleImageView.this.anim;
            if (anim3 == null) {
                Intrinsics.throwNpe();
            }
            anim3.setDuration(this.duration);
            Anim anim4 = SubsamplingScaleImageView.this.anim;
            if (anim4 == null) {
                Intrinsics.throwNpe();
            }
            anim4.setInterruptible(this.interruptible);
            Anim anim5 = SubsamplingScaleImageView.this.anim;
            if (anim5 == null) {
                Intrinsics.throwNpe();
            }
            anim5.setEasing(this.easing);
            Anim anim6 = SubsamplingScaleImageView.this.anim;
            if (anim6 == null) {
                Intrinsics.throwNpe();
            }
            anim6.setOrigin(this.origin);
            if (this.vFocus != null) {
                float f = this.vFocus.x;
                Anim anim7 = SubsamplingScaleImageView.this.anim;
                if (anim7 == null) {
                    Intrinsics.throwNpe();
                }
                PointF pointF2 = anim7.getSCenterStart();
                if (pointF2 == null) {
                    Intrinsics.throwNpe();
                }
                float vTranslateXEnd = f - targetScale * pointF2.x;
                float f2 = this.vFocus.y;
                Anim anim8 = SubsamplingScaleImageView.this.anim;
                if (anim8 == null) {
                    Intrinsics.throwNpe();
                }
                PointF pointF3 = anim8.getSCenterStart();
                if (pointF3 == null) {
                    Intrinsics.throwNpe();
                }
                float vTranslateYEnd = f2 - targetScale * pointF3.y;
                ScaleAndTranslate satEnd = new ScaleAndTranslate(targetScale, new PointF(vTranslateXEnd, vTranslateYEnd));
                SubsamplingScaleImageView.this.fitToBounds(true, satEnd);
                Anim anim9 = SubsamplingScaleImageView.this.anim;
                if (anim9 == null) {
                    Intrinsics.throwNpe();
                }
                anim9.setVFocusEnd(new PointF(this.vFocus.x + (satEnd.getVTranslate().x - vTranslateXEnd), this.vFocus.y + (satEnd.getVTranslate().y - vTranslateYEnd)));
            }
            SubsamplingScaleImageView.this.invalidate();
        }

        public AnimationBuilder(PointF sCenter) {
            Intrinsics.checkParameterIsNotNull((Object)sCenter, (String)"sCenter");
            this.duration = 500L;
            this.easing = 2;
            this.origin = 1;
            this.interruptible = true;
            this.targetScale = SubsamplingScaleImageView.this.getScale();
            this.targetSCenter = sCenter;
            this.vFocus = null;
        }

        public AnimationBuilder(@NotNull float scale, PointF sCenter) {
            Intrinsics.checkParameterIsNotNull((Object)sCenter, (String)"sCenter");
            this.duration = 500L;
            this.easing = 2;
            this.origin = 1;
            this.interruptible = true;
            this.targetScale = scale;
            this.targetSCenter = sCenter;
            this.vFocus = null;
        }

        public AnimationBuilder(@NotNull float scale, @NotNull PointF sCenter, PointF vFocus) {
            Intrinsics.checkParameterIsNotNull((Object)sCenter, (String)"sCenter");
            Intrinsics.checkParameterIsNotNull((Object)vFocus, (String)"vFocus");
            this.duration = 500L;
            this.easing = 2;
            this.origin = 1;
            this.interruptible = true;
            this.targetScale = scale;
            this.targetSCenter = sCenter;
            this.vFocus = vFocus;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H&J\b\u0010\u0007\u001a\u00020\u0003H&J\u0014\u0010\b\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H&J\b\u0010\t\u001a\u00020\u0003H&J\b\u0010\n\u001a\u00020\u0003H&J\u0014\u0010\u000b\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H&\u00a8\u0006\f"}, d2={"Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView$OnImageEventListener;", "", "onImageLoadError", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onImageLoaded", "onPreviewLoadError", "onPreviewReleased", "onReady", "onTileLoadError", "subsampling-scale-image-view_release"})
    public static interface OnImageEventListener {
        public void onReady();

        public void onImageLoaded();

        public void onPreviewLoadError(@NotNull Exception var1);

        public void onImageLoadError(@NotNull Exception var1);

        public void onTileLoadError(@NotNull Exception var1);

        public void onPreviewReleased();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016J\u0014\u0010\t\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\u0014\u0010\f\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView$DefaultOnImageEventListener;", "Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView$OnImageEventListener;", "()V", "onImageLoadError", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onImageLoaded", "onPreviewLoadError", "onPreviewReleased", "onReady", "onTileLoadError", "subsampling-scale-image-view_release"})
    public static final class DefaultOnImageEventListener
    implements OnImageEventListener {
        @Override
        public void onReady() {
        }

        @Override
        public void onImageLoaded() {
        }

        @Override
        public void onPreviewLoadError(@NotNull Exception e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        }

        @Override
        public void onImageLoadError(@NotNull Exception e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        }

        @Override
        public void onTileLoadError(@NotNull Exception e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        }

        @Override
        public void onPreviewReleased() {
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R2\u0010\u0012\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00040\u0004 \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0015\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00040\u0004 \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/davemorrissey/labs/subscaleview/SubsamplingScaleImageView$Companion;", "", "()V", "EASE_IN_OUT_QUAD", "", "EASE_OUT_QUAD", "ORIENTATION_0", "ORIENTATION_180", "ORIENTATION_270", "ORIENTATION_90", "ORIENTATION_USE_EXIF", "ORIGIN_ANIM", "ORIGIN_DOUBLE_TAP_ZOOM", "ORIGIN_FLING", "TAG", "", "kotlin.jvm.PlatformType", "TILE_SIZE_AUTO", "VALID_EASING_STYLES", "", "", "VALID_ORIENTATIONS", "preferredBitmapConfig", "Landroid/graphics/Bitmap$Config;", "getPreferredBitmapConfig", "()Landroid/graphics/Bitmap$Config;", "setPreferredBitmapConfig", "(Landroid/graphics/Bitmap$Config;)V", "subsampling-scale-image-view_release"})
    public static final class Companion {
        @Nullable
        public final Bitmap.Config getPreferredBitmapConfig() {
            return preferredBitmapConfig;
        }

        public final void setPreferredBitmapConfig(@Nullable Bitmap.Config config) {
            preferredBitmapConfig = config;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

