/*
 * Decompiled with CFR 0.152.
 */
package com.davemorrissey.labs.subscaleview;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.net.Uri;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 /2\u00020\u0001:\u0001/B\u0017\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0012\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0012\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010(\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bJ\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010*\u001a\u00020+H\u0002J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0005J\u0006\u0010-\u001a\u00020\u0000J\u0006\u0010.\u001a\u00020\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\fR\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0018\"\u0004\b\"\u0010\fR\u001a\u0010#\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0010\"\u0004\b%\u0010\u0012R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u00060"}, d2={"Lcom/davemorrissey/labs/subscaleview/ImageSource;", "", "bitmap", "Landroid/graphics/Bitmap;", "cached", "", "(Landroid/graphics/Bitmap;Z)V", "uri", "Landroid/net/Uri;", "(Landroid/net/Uri;)V", "resource", "", "(I)V", "getBitmap", "()Landroid/graphics/Bitmap;", "isCached", "()Z", "setCached", "(Z)V", "getResource", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "sHeight", "getSHeight", "()I", "setSHeight", "sRegion", "Landroid/graphics/Rect;", "getSRegion", "()Landroid/graphics/Rect;", "setSRegion", "(Landroid/graphics/Rect;)V", "sWidth", "getSWidth", "setSWidth", "tile", "getTile", "setTile", "getUri", "()Landroid/net/Uri;", "dimensions", "region", "setInvariants", "", "tiling", "tilingDisabled", "tilingEnabled", "Companion", "subsampling-scale-image-view_release"})
public final class ImageSource {
    @Nullable
    private final Uri uri;
    @Nullable
    private final Bitmap bitmap;
    @Nullable
    private final Integer resource;
    private boolean tile;
    private int sWidth;
    private int sHeight;
    private boolean isCached;
    @Nullable
    private Rect sRegion;
    @NotNull
    private static final String FILE_SCHEME = "file:///";
    @NotNull
    private static final String ASSET_SCHEME = "file:///android_asset/";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Uri getUri() {
        return this.uri;
    }

    @Nullable
    public final Bitmap getBitmap() {
        return this.bitmap;
    }

    @Nullable
    public final Integer getResource() {
        return this.resource;
    }

    public final boolean getTile() {
        return this.tile;
    }

    public final void setTile(boolean bl) {
        this.tile = bl;
    }

    public final int getSWidth() {
        return this.sWidth;
    }

    public final void setSWidth(int n) {
        this.sWidth = n;
    }

    public final int getSHeight() {
        return this.sHeight;
    }

    public final void setSHeight(int n) {
        this.sHeight = n;
    }

    public final boolean isCached() {
        return this.isCached;
    }

    public final void setCached(boolean bl) {
        this.isCached = bl;
    }

    @Nullable
    public final Rect getSRegion() {
        return this.sRegion;
    }

    public final void setSRegion(@Nullable Rect rect) {
        this.sRegion = rect;
    }

    @NotNull
    public final ImageSource tilingEnabled() {
        return this.tiling(true);
    }

    @NotNull
    public final ImageSource tilingDisabled() {
        return this.tiling(false);
    }

    @NotNull
    public final ImageSource tiling(boolean tile) {
        this.tile = tile;
        return this;
    }

    @NotNull
    public final ImageSource region(@NotNull Rect sRegion) {
        Intrinsics.checkParameterIsNotNull((Object)sRegion, (String)"sRegion");
        this.sRegion = sRegion;
        this.setInvariants();
        return this;
    }

    @NotNull
    public final ImageSource dimensions(int sWidth, int sHeight) {
        if (this.bitmap == null) {
            this.sWidth = sWidth;
            this.sHeight = sHeight;
        }
        this.setInvariants();
        return this;
    }

    private final void setInvariants() {
        if (this.sRegion != null) {
            this.tile = true;
            Rect rect = this.sRegion;
            if (rect == null) {
                Intrinsics.throwNpe();
            }
            this.sWidth = rect.width();
            Rect rect2 = this.sRegion;
            if (rect2 == null) {
                Intrinsics.throwNpe();
            }
            this.sHeight = rect2.height();
        }
    }

    private ImageSource(Bitmap bitmap, boolean cached) {
        this.bitmap = bitmap;
        this.uri = null;
        this.resource = null;
        this.tile = false;
        this.sWidth = bitmap.getWidth();
        this.sHeight = bitmap.getHeight();
        this.isCached = cached;
    }

    private ImageSource(Uri uri) {
        Uri newUri = uri;
        String string = uri.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uri.toString()");
        String uriString = string;
        if (StringsKt.startsWith$default((String)uriString, (String)FILE_SCHEME, (boolean)false, (int)2, null)) {
            String string2;
            String string3 = uriString;
            int n = FILE_SCHEME.length() - 1;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            String string6 = string2 = string5;
            File uriFile = new File(string6);
            if (!uriFile.exists()) {
                try {
                    Uri uri2 = Uri.parse((String)URLDecoder.decode(uriString, "UTF-8"));
                    Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"Uri.parse(URLDecoder.decode(uriString, \"UTF-8\"))");
                    newUri = uri2;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        this.uri = newUri;
        this.bitmap = null;
        this.resource = null;
        this.tile = true;
    }

    private ImageSource(int resource) {
        this.resource = resource;
        this.bitmap = null;
        this.uri = null;
        this.tile = true;
    }

    static {
        FILE_SCHEME = FILE_SCHEME;
        ASSET_SCHEME = ASSET_SCHEME;
    }

    public /* synthetic */ ImageSource(int resource, DefaultConstructorMarker $constructor_marker) {
        this(resource);
    }

    public /* synthetic */ ImageSource(@NotNull Uri uri, DefaultConstructorMarker $constructor_marker) {
        this(uri);
    }

    public /* synthetic */ ImageSource(@NotNull Bitmap bitmap, boolean cached, DefaultConstructorMarker $constructor_marker) {
        this(bitmap, cached);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/davemorrissey/labs/subscaleview/ImageSource$Companion;", "", "()V", "ASSET_SCHEME", "", "getASSET_SCHEME", "()Ljava/lang/String;", "FILE_SCHEME", "getFILE_SCHEME", "asset", "Lcom/davemorrissey/labs/subscaleview/ImageSource;", "assetName", "bitmap", "Landroid/graphics/Bitmap;", "cachedBitmap", "resource", "resId", "", "uri", "Landroid/net/Uri;", "subsampling-scale-image-view_release"})
    public static final class Companion {
        @NotNull
        public final String getFILE_SCHEME() {
            return FILE_SCHEME;
        }

        @NotNull
        public final String getASSET_SCHEME() {
            return ASSET_SCHEME;
        }

        @NotNull
        public final ImageSource resource(int resId) {
            return new ImageSource(resId, null);
        }

        @NotNull
        public final ImageSource asset(@NotNull String assetName) {
            Intrinsics.checkParameterIsNotNull((Object)assetName, (String)"assetName");
            return this.uri(this.getASSET_SCHEME() + assetName);
        }

        @NotNull
        public final ImageSource uri(@NotNull String uri) {
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            String newUri = uri;
            if (!StringsKt.contains$default((CharSequence)newUri, (CharSequence)"://", (boolean)false, (int)2, null)) {
                if (StringsKt.startsWith$default((String)newUri, (String)"/", (boolean)false, (int)2, null)) {
                    String string = uri;
                    int n = 1;
                    String string2 = string.substring(n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    newUri = string2;
                }
                newUri = this.getFILE_SCHEME() + newUri;
            }
            Uri uri2 = Uri.parse((String)newUri);
            Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"Uri.parse(newUri)");
            return new ImageSource(uri2, null);
        }

        @NotNull
        public final ImageSource uri(@NotNull Uri uri) {
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            return new ImageSource(uri, null);
        }

        @NotNull
        public final ImageSource bitmap(@NotNull Bitmap bitmap) {
            Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
            return new ImageSource(bitmap, false, null);
        }

        @NotNull
        public final ImageSource cachedBitmap(@NotNull Bitmap bitmap) {
            Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
            return new ImageSource(bitmap, true, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

