/*
 * Decompiled with CFR 0.152.
 */
package com.tiagobagni.simplexmlserializerlib.xml;

import com.tiagobagni.simplexmlserializerlib.XmlSerializerLogger;
import com.tiagobagni.simplexmlserializerlib.xml.SimpleXmlParams;
import com.tiagobagni.simplexmlserializerlib.xml.annotation.XmlClass;
import com.tiagobagni.simplexmlserializerlib.xml.annotation.XmlField;
import com.tiagobagni.simplexmlserializerlib.xml.annotation.XmlObject;
import com.tiagobagni.simplexmlserializerlib.xml.annotation.XmlObjectList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;

public class XmlSerializer {
    private static final String NEW_LINE = "\n";
    private static final String INDENTATION = "  ";
    private static final String XML_HEADER = "<?xml version=\"1.0\"?>";
    private StringBuilder xmlBuilder;
    private String spacing;
    private String nestedSpacing;
    private int indentLevels;
    private Object xmlObject;
    private String xmlRootTag;
    private XmlSerializer nestedSerializer;
    private final boolean DBG = SimpleXmlParams.get().isDebugMode();
    private final XmlSerializerLogger LOGGER = SimpleXmlParams.get().getLogger();

    public String serialize(Object xmlObject) throws IllegalAccessException {
        this.initializeFor(xmlObject);
        this.writeXmlHeader();
        this.writeXmlBody(0);
        return this.xmlBuilder.toString();
    }

    private void initializeFor(Object xmlObject) {
        this.ensureValid(xmlObject);
        this.xmlObject = xmlObject;
        this.xmlRootTag = xmlObject.getClass().getSimpleName();
        this.xmlBuilder = new StringBuilder();
        this.nestedSerializer = null;
    }

    private void ensureValid(Object xmlObject) {
        if (xmlObject == null) {
            throw new NullPointerException("Trying to serialize a null object");
        }
        XmlClass annotation = xmlObject.getClass().getAnnotation(XmlClass.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Invalid XmlClass. Missing Xml annotation");
        }
    }

    private void writeXmlHeader() {
        this.xmlBuilder.append(XML_HEADER);
        this.xmlBuilder.append(NEW_LINE);
        if (this.DBG) {
            this.LOGGER.debug("writing xml header");
        }
    }

    private void writeXmlBody(StringBuilder xmlBuilder, int indentLevels) throws IllegalAccessException {
        this.xmlBuilder = xmlBuilder;
        this.writeXmlBody(indentLevels);
    }

    private void writeXmlBody(int indentLevels) throws IllegalAccessException {
        this.setIndentation(indentLevels);
        this.writeOpenTag();
        this.writeFields();
        this.writeCloseTag();
    }

    private void setIndentation(int indentLevels) {
        this.indentLevels = indentLevels;
        this.spacing = this.getSpaces(indentLevels);
        this.nestedSpacing = this.getSpaces(indentLevels + 1);
    }

    private void writeOpenTag() {
        if (this.DBG) {
            this.LOGGER.debug("writing open tag: " + this.xmlRootTag);
        }
        this.xmlBuilder.append(this.spacing);
        this.xmlBuilder.append(this.open(this.xmlRootTag));
        this.xmlBuilder.append(NEW_LINE);
    }

    private void writeFields() throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = this.xmlObject.getClass().getDeclaredFields()) {
            Annotation annotation = this.getAnnotation(field);
            field.setAccessible(true);
            Object value = field.get(this.xmlObject);
            if (annotation instanceof XmlField) {
                this.writeXmlField(((XmlField)annotation).value(), value);
            } else if (annotation instanceof XmlObject) {
                this.writeXmlObject(((XmlObject)annotation).value(), value);
            } else {
                if (!(annotation instanceof XmlObjectList)) continue;
                this.writeXmlList(((XmlObjectList)annotation).value(), (List)value);
            }
            this.xmlBuilder.append(NEW_LINE);
        }
    }

    private void writeXmlField(String tag, Object value) {
        if (this.DBG) {
            this.LOGGER.debug("writing primitive: " + tag + " = " + value);
        }
        this.xmlBuilder.append(this.nestedSpacing);
        this.xmlBuilder.append(this.open(tag));
        this.xmlBuilder.append(value);
        this.xmlBuilder.append(this.close(tag));
    }

    private void writeXmlObject(String tag, Object value) throws IllegalAccessException {
        if (this.DBG) {
            this.LOGGER.debug("writing object: " + tag + " = " + value);
        }
        if (this.nestedSerializer == null) {
            this.nestedSerializer = new XmlSerializer();
        }
        this.nestedSerializer.initializeFor(value);
        this.nestedSerializer.xmlRootTag = tag;
        this.nestedSerializer.writeXmlBody(this.xmlBuilder, this.indentLevels + 1);
    }

    private void writeXmlList(String tag, List items) throws IllegalAccessException {
        if (this.DBG) {
            this.LOGGER.debug("writing list: " + tag);
        }
        this.xmlBuilder.append(this.nestedSpacing);
        this.xmlBuilder.append(this.open(tag));
        this.xmlBuilder.append(NEW_LINE);
        ++this.indentLevels;
        for (Object item : items) {
            this.writeXmlObject(item.getClass().getSimpleName(), item);
            this.xmlBuilder.append(NEW_LINE);
        }
        --this.indentLevels;
        this.xmlBuilder.append(this.nestedSpacing);
        this.xmlBuilder.append(this.close(tag));
    }

    private void writeCloseTag() {
        if (this.DBG) {
            this.LOGGER.debug("writing close tag: " + this.xmlRootTag);
        }
        this.xmlBuilder.append(this.spacing);
        this.xmlBuilder.append(this.close(this.xmlRootTag));
    }

    private Annotation getAnnotation(Field field) {
        Annotation annotation = field.getAnnotation(XmlField.class);
        if (annotation == null) {
            annotation = field.getAnnotation(XmlObject.class);
        }
        if (annotation == null) {
            annotation = field.getAnnotation(XmlObjectList.class);
        }
        return annotation;
    }

    private String open(String tag) {
        return "<" + tag + ">";
    }

    private String close(String tag) {
        return "</" + tag + ">";
    }

    private String getSpaces(int indentLevels) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indentLevels; ++i) {
            sb.append(INDENTATION);
        }
        return sb.toString();
    }
}

