/*
 * Decompiled with CFR 0.152.
 */
package com.tiagobagni.simplexmlserializerlib.xml;

import android.text.TextUtils;
import com.tiagobagni.simplexmlserializerlib.XmlSerializerLogger;
import com.tiagobagni.simplexmlserializerlib.xml.SimpleXmlParams;
import com.tiagobagni.simplexmlserializerlib.xml.XmlDeserializationException;
import com.tiagobagni.simplexmlserializerlib.xml.annotation.XmlClass;
import com.tiagobagni.simplexmlserializerlib.xml.annotation.XmlField;
import com.tiagobagni.simplexmlserializerlib.xml.annotation.XmlObject;
import com.tiagobagni.simplexmlserializerlib.xml.annotation.XmlObjectList;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XmlDeserializer {
    private Object xmlObject;
    private Class xmlClass;
    private HashMap<String, FieldWrapper> xmlPropertiesMap = new HashMap();
    private XmlPullParser xmlPullParser;
    private Stack<String> parsingTags;
    private String lastTagToParse;
    private boolean isParsingList;
    private String listTag;
    private List listOfXmlObjects;
    private Class listItemType;
    private Field listField;
    private final boolean DBG = SimpleXmlParams.get().isDebugMode();
    private final XmlSerializerLogger LOGGER = SimpleXmlParams.get().getLogger();

    public XmlDeserializer(Class xmlClass) {
        try {
            this.ensureValid(xmlClass);
            this.xmlClass = xmlClass;
            this.xmlObject = xmlClass.newInstance();
            this.readClassMembers();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("It was not possible to instantiate " + xmlClass, e);
        }
    }

    private void ensureValid(Class xmlClass) {
        if (xmlClass == null) {
            throw new NullPointerException("Cannot create an XmlDeserializer for a null XmlClass");
        }
        XmlClass annotation = xmlClass.getAnnotation(XmlClass.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Provided Xml Class missing XmlClass annotation");
        }
    }

    private void readClassMembers() {
        Field[] fields;
        for (Field field : fields = this.xmlClass.getDeclaredFields()) {
            Annotation fieldAnnotation = this.getFieldAnnotation(field);
            if (fieldAnnotation == null) continue;
            this.xmlPropertiesMap.put(this.getTagFor(field), new FieldWrapper(field, fieldAnnotation));
        }
    }

    private Annotation getFieldAnnotation(Field field) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = field.getAnnotations()) {
            if (!(annotation instanceof XmlField) && !(annotation instanceof XmlObject) && !(annotation instanceof XmlObjectList)) continue;
            return annotation;
        }
        return null;
    }

    private String getTagFor(Field field) {
        Annotation annotation = field.getAnnotation(XmlField.class);
        if (annotation != null) {
            return annotation.value();
        }
        annotation = field.getAnnotation(XmlObject.class);
        if (annotation != null) {
            return ((XmlObject)annotation).value();
        }
        annotation = field.getAnnotation(XmlObjectList.class);
        if (annotation != null) {
            return ((XmlObjectList)annotation).value();
        }
        throw new IllegalStateException("Called getTagFor on a field without annotation " + field);
    }

    public Object deserialize(String xml) throws XmlDeserializationException {
        this.initialize(new StringReader(xml));
        this.parse();
        return this.xmlObject;
    }

    private void initialize(Reader inputReader) throws XmlDeserializationException {
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            this.xmlPullParser = factory.newPullParser();
            this.xmlPullParser.setInput(inputReader);
            this.parsingTags = new Stack();
        }
        catch (XmlPullParserException e) {
            throw new XmlDeserializationException("It was not possible to initialize the Xml Parser", e);
        }
    }

    private void parse() throws XmlDeserializationException {
        try {
            int eventType = this.xmlPullParser.getEventType();
            while (eventType != 1) {
                switch (eventType) {
                    case 2: {
                        String openTag = this.xmlPullParser.getName();
                        if (this.DBG) {
                            this.LOGGER.debug("Open tag: " + openTag);
                        }
                        this.parsingTags.push(openTag);
                        break;
                    }
                    case 4: {
                        this.handleText();
                        break;
                    }
                    case 3: {
                        String closedTag = this.parsingTags.pop();
                        String endTag = this.xmlPullParser.getName();
                        if (!TextUtils.equals((CharSequence)closedTag, (CharSequence)endTag) && this.DBG && this.DBG) {
                            this.LOGGER.error("End tag is different from the top of the stack! EndTag = " + endTag + " TopStack = " + closedTag);
                        }
                        if (this.DBG) {
                            this.LOGGER.debug("Close tag: " + closedTag);
                        }
                        if (this.isParsingList && closedTag.equals(this.listTag)) {
                            this.finishParseXmlObjectList();
                        }
                        if (!this.shouldAbortParsing(closedTag)) break;
                        if (this.DBG) {
                            this.LOGGER.debug("End Early. Finished parsing nested object");
                        }
                        return;
                    }
                }
                eventType = this.xmlPullParser.next();
            }
        }
        catch (IOException | XmlPullParserException e) {
            throw new XmlDeserializationException("Possibly malformed Xml", e);
        }
    }

    private void finishParseXmlObjectList() {
        this.setField(this.listField, this.listOfXmlObjects);
        if (this.DBG) {
            this.LOGGER.debug("Finished parsing list: " + this.listTag);
        }
        this.isParsingList = false;
        this.listTag = null;
        this.listItemType = null;
        this.listOfXmlObjects = null;
        this.listField = null;
    }

    private void handleText() throws XmlDeserializationException {
        Annotation fieldAnnotation;
        String currentTag = this.parsingTags.peek();
        String value = this.xmlPullParser.getText();
        FieldWrapper fieldWrapper = this.xmlPropertiesMap.get(currentTag);
        if (fieldWrapper == null) {
            if (this.isParsingList) {
                this.parseXmlObjectListItem();
            }
            return;
        }
        Annotation annotation = fieldAnnotation = fieldWrapper == null ? null : fieldWrapper.annotation;
        if (fieldAnnotation instanceof XmlField) {
            this.parsePrimitiveValue(fieldWrapper.field, value);
        } else if (fieldAnnotation instanceof XmlObject) {
            this.parseXmlObject(fieldWrapper.field);
        } else if (fieldAnnotation instanceof XmlObjectList && !this.isParsingList) {
            this.startParseXmlObjectList(fieldWrapper.field);
        }
    }

    private void parsePrimitiveValue(Field field, String value) {
        Object parsedValue;
        if (TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        Class<?> cls = field.getType();
        if (cls == Integer.TYPE || cls == Integer.class) {
            parsedValue = Integer.parseInt(value);
        } else if (cls == Long.TYPE || cls == Long.class) {
            parsedValue = Long.parseLong(value);
        } else if (cls == Double.TYPE || cls == Double.class) {
            parsedValue = Double.parseDouble(value);
        } else if (cls == Float.TYPE || cls == Float.class) {
            parsedValue = Float.valueOf(Float.parseFloat(value));
        } else if (cls == Boolean.TYPE || cls == Boolean.class) {
            parsedValue = Boolean.parseBoolean(value);
        } else if (cls == String.class) {
            parsedValue = value;
        } else {
            throw new IllegalStateException("Trying to parse unsupported type: " + cls);
        }
        this.setField(field, parsedValue);
        if (this.DBG) {
            this.LOGGER.debug("Primitive value found: " + cls + " = " + parsedValue);
        }
    }

    private void parseXmlObject(Field field) throws XmlDeserializationException {
        Class<?> type = field.getType();
        Object object = this.deserializeObject(type);
        this.setField(field, object);
        if (this.DBG) {
            this.LOGGER.debug("Object found: " + type + " = " + object);
        }
    }

    private Object deserializeObject(Class type) throws XmlDeserializationException {
        XmlDeserializer nestedDeserializer = new XmlDeserializer(type);
        nestedDeserializer.lastTagToParse = this.parsingTags.peek();
        nestedDeserializer.xmlPullParser = this.xmlPullParser;
        nestedDeserializer.parsingTags = this.parsingTags;
        nestedDeserializer.parse();
        return nestedDeserializer.xmlObject;
    }

    private void startParseXmlObjectList(Field field) {
        ParameterizedType pType;
        Type[] arr;
        if (field.getType() != List.class) {
            throw new IllegalStateException("A List was expected for " + field.getName());
        }
        if (this.isParsingList) {
            throw new IllegalStateException("Trying to start parsing a list while parsing a list");
        }
        this.isParsingList = true;
        this.listOfXmlObjects = new ArrayList();
        this.listTag = this.parsingTags.peek();
        this.listField = field;
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType && (arr = (pType = (ParameterizedType)type).getActualTypeArguments()) != null && arr.length == 1) {
            this.listItemType = (Class)arr[0];
        }
        if (this.listItemType == null) {
            throw new IllegalStateException("Not possible to read generic type of " + field.getName());
        }
        if (this.DBG) {
            this.LOGGER.debug("Started parsing list: " + this.listTag);
        }
    }

    private void parseXmlObjectListItem() throws XmlDeserializationException {
        Object object = this.deserializeObject(this.listItemType);
        this.listOfXmlObjects.add(object);
        if (this.DBG) {
            this.LOGGER.debug("Object added to list: " + this.listItemType + " = " + object);
        }
    }

    private void setField(Field field, Object value) {
        block2: {
            try {
                field.setAccessible(true);
                field.set(this.xmlObject, value);
            }
            catch (IllegalAccessException e) {
                if (!this.DBG) break block2;
                this.LOGGER.error("An error occurred while trying to set value [" + value + "] to field " + field.getName(), e);
            }
        }
    }

    private boolean shouldAbortParsing(String tag) {
        return this.lastTagToParse != null && this.lastTagToParse.equals(tag);
    }

    private class FieldWrapper {
        public final Field field;
        public final Annotation annotation;

        private FieldWrapper(Field field, Annotation annotation) {
            this.field = field;
            this.annotation = annotation;
        }
    }
}

