/*
 * Decompiled with CFR 0.152.
 */
package com.kingja.loadsir.core;

import androidx.annotation.NonNull;
import com.kingja.loadsir.LoadSirUtil;
import com.kingja.loadsir.callback.Callback;
import com.kingja.loadsir.core.Convertor;
import com.kingja.loadsir.core.LoadLayout;
import com.kingja.loadsir.core.LoadService;
import com.kingja.loadsir.target.ActivityTarget;
import com.kingja.loadsir.target.ITarget;
import com.kingja.loadsir.target.ViewTarget;
import java.util.ArrayList;
import java.util.List;

public class LoadSir {
    private static volatile LoadSir loadSir;
    private Builder builder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoadSir getDefault() {
        if (loadSir != null) return loadSir;
        Class<LoadSir> clazz = LoadSir.class;
        synchronized (LoadSir.class) {
            if (loadSir != null) return loadSir;
            loadSir = new LoadSir();
            // ** MonitorExit[var0] (shouldn't be in output)
            return loadSir;
        }
    }

    private LoadSir() {
        this.builder = new Builder();
    }

    private void setBuilder(@NonNull Builder builder) {
        this.builder = builder;
    }

    private LoadSir(Builder builder) {
        this.builder = builder;
    }

    public LoadService register(@NonNull Object target) {
        return this.register(target, null, null);
    }

    public LoadService register(Object target, Callback.OnReloadListener onReloadListener) {
        return this.register(target, onReloadListener, null);
    }

    public <T> LoadService register(Object target, Callback.OnReloadListener onReloadListener, Convertor<T> convertor) {
        ITarget targetContext = LoadSirUtil.getTargetContext(target, this.builder.getTargetContextList());
        LoadLayout loadLayout = targetContext.replaceView(target, onReloadListener);
        return new LoadService<T>(convertor, loadLayout, this.builder);
    }

    public static Builder beginBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<Callback> callbacks = new ArrayList<Callback>();
        private List<ITarget> targetContextList = new ArrayList<ITarget>();
        private Class<? extends Callback> defaultCallback;

        public Builder() {
            this.targetContextList.add(new ActivityTarget());
            this.targetContextList.add(new ViewTarget());
        }

        public Builder addCallback(@NonNull Callback callback) {
            this.callbacks.add(callback);
            return this;
        }

        public Builder addTargetContext(ITarget targetContext) {
            this.targetContextList.add(targetContext);
            return this;
        }

        public List<ITarget> getTargetContextList() {
            return this.targetContextList;
        }

        public Builder setDefaultCallback(@NonNull Class<? extends Callback> defaultCallback) {
            this.defaultCallback = defaultCallback;
            return this;
        }

        List<Callback> getCallbacks() {
            return this.callbacks;
        }

        Class<? extends Callback> getDefaultCallback() {
            return this.defaultCallback;
        }

        public void commit() {
            LoadSir.getDefault().setBuilder(this);
        }

        public LoadSir build() {
            return new LoadSir(this);
        }
    }
}

