/*
 * Decompiled with CFR 0.152.
 */
package com.kingja.loadsir.core;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.kingja.loadsir.LoadSirUtil;
import com.kingja.loadsir.callback.Callback;
import com.kingja.loadsir.callback.SuccessCallback;
import com.kingja.loadsir.core.Transport;
import java.util.HashMap;
import java.util.Map;

public class LoadLayout
extends FrameLayout {
    private final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private Map<Class<? extends Callback>, Callback> callbacks = new HashMap<Class<? extends Callback>, Callback>();
    private Context context;
    private Callback.OnReloadListener onReloadListener;
    private Class<? extends Callback> preCallback;
    private Class<? extends Callback> curCallback;
    private static final int CALLBACK_CUSTOM_INDEX = 1;

    public LoadLayout(@NonNull Context context) {
        super(context);
    }

    public LoadLayout(@NonNull Context context, Callback.OnReloadListener onReloadListener) {
        this(context);
        this.context = context;
        this.onReloadListener = onReloadListener;
    }

    public void setupSuccessLayout(Callback callback) {
        this.addCallback(callback);
        View successView = callback.getRootView();
        successView.setVisibility(4);
        this.addView(successView, new ViewGroup.LayoutParams(-1, -1));
        this.curCallback = SuccessCallback.class;
    }

    public void setupCallback(Callback callback) {
        Callback cloneCallback = callback.copy();
        cloneCallback.setCallback(this.context, this.onReloadListener);
        this.addCallback(cloneCallback);
    }

    public void addCallback(Callback callback) {
        if (!this.callbacks.containsKey(callback.getClass())) {
            this.callbacks.put(callback.getClass(), callback);
        }
    }

    public void showCallback(Class<? extends Callback> callback) {
        this.checkCallbackExist(callback);
        if (LoadSirUtil.isMainThread()) {
            this.showCallbackView(callback);
        } else {
            this.postToMainThread(callback);
        }
    }

    public Class<? extends Callback> getCurrentCallback() {
        return this.curCallback;
    }

    private void postToMainThread(final Class<? extends Callback> status) {
        this.post(new Runnable(){

            @Override
            public void run() {
                LoadLayout.this.showCallbackView(status);
            }
        });
    }

    private void showCallbackView(Class<? extends Callback> status) {
        if (this.preCallback != null) {
            if (this.preCallback == status) {
                return;
            }
            this.callbacks.get(this.preCallback).onDetach();
        }
        if (this.getChildCount() > 1) {
            this.removeViewAt(1);
        }
        for (Class<? extends Callback> key : this.callbacks.keySet()) {
            if (key != status) continue;
            SuccessCallback successCallback = (SuccessCallback)this.callbacks.get(SuccessCallback.class);
            if (key == SuccessCallback.class) {
                successCallback.show();
            } else {
                successCallback.showWithCallback(this.callbacks.get(key).getSuccessVisible());
                View rootView = this.callbacks.get(key).getRootView();
                this.addView(rootView);
                this.callbacks.get(key).onAttach(this.context, rootView);
            }
            this.preCallback = status;
        }
        this.curCallback = status;
    }

    public void setCallBack(Class<? extends Callback> callback, Transport transport) {
        if (transport == null) {
            return;
        }
        this.checkCallbackExist(callback);
        transport.order(this.context, this.callbacks.get(callback).obtainRootView());
    }

    private void checkCallbackExist(Class<? extends Callback> callback) {
        if (!this.callbacks.containsKey(callback)) {
            throw new IllegalArgumentException(String.format("The Callback (%s) is nonexistent.", callback.getSimpleName()));
        }
    }
}

