/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasdarimont.keycloak.embedded;

import com.github.thomasdarimont.keycloak.embedded.EmbeddedKeycloakApplication;
import com.github.thomasdarimont.keycloak.embedded.EmbeddedKeycloakServer;
import com.github.thomasdarimont.keycloak.embedded.KeycloakCustomProperties;
import com.github.thomasdarimont.keycloak.embedded.KeycloakProperties;
import com.github.thomasdarimont.keycloak.embedded.support.DynamicJndiContextFactoryBuilder;
import com.github.thomasdarimont.keycloak.embedded.support.KeycloakUndertowRequestFilter;
import com.github.thomasdarimont.keycloak.embedded.support.SpringBootConfigProvider;
import com.github.thomasdarimont.keycloak.embedded.support.SpringBootPlatformProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;
import org.keycloak.platform.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration
public class EmbeddedKeycloakConfig {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedKeycloakConfig.class);

    @Bean
    @ConditionalOnMissingBean(name={"embeddedKeycloakServer"})
    protected EmbeddedKeycloakServer embeddedKeycloakServer(ServerProperties serverProperties) {
        return new EmbeddedKeycloakServer(serverProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"springBootPlatform"})
    protected SpringBootPlatformProvider springBootPlatform() {
        return (SpringBootPlatformProvider)Platform.getPlatform();
    }

    @Bean
    @ConditionalOnMissingBean(name={"springBootConfigProvider"})
    protected SpringBootConfigProvider springBootConfigProvider(KeycloakProperties keycloakProperties) {
        return new SpringBootConfigProvider(keycloakProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"springBeansJndiContextFactory"})
    protected DynamicJndiContextFactoryBuilder springBeansJndiContextFactory(DataSource dataSource, DefaultCacheManager cacheManager, @Qualifier(value="fixedThreadPool") ExecutorService executorService) {
        return new DynamicJndiContextFactoryBuilder(dataSource, cacheManager, executorService);
    }

    @Bean(value={"fixedThreadPool"})
    public ExecutorService fixedThreadPool() {
        return Executors.newFixedThreadPool(5);
    }

    @Bean
    @ConditionalOnMissingBean(name={"keycloakInfinispanCacheManager"})
    protected DefaultCacheManager keycloakInfinispanCacheManager(KeycloakCustomProperties customProperties) throws Exception {
        KeycloakCustomProperties.Infinispan infinispan = customProperties.getInfinispan();
        Resource configLocation = infinispan.getConfigLocation();
        log.info("Using infinispan configuration from {}", (Object)configLocation.getURI());
        ConfigurationBuilderHolder configBuilder = new ParserRegistry().parse(configLocation.getURL());
        DefaultCacheManager defaultCacheManager = new DefaultCacheManager(configBuilder, false);
        defaultCacheManager.start();
        return defaultCacheManager;
    }

    @Bean
    @ConditionalOnMissingBean(name={"keycloakJaxRsApplication"})
    protected ServletRegistrationBean<HttpServlet30Dispatcher> keycloakJaxRsApplication(KeycloakCustomProperties customProperties) {
        this.initKeycloakEnvironmentFromProfiles();
        ServletRegistrationBean servlet = new ServletRegistrationBean((Servlet)new HttpServlet30Dispatcher(), new String[0]);
        servlet.addInitParameter("javax.ws.rs.Application", EmbeddedKeycloakApplication.class.getName());
        servlet.addInitParameter("resteasy.allowGzip", "false");
        servlet.addInitParameter("keycloak.embedded", "true");
        servlet.addInitParameter("resteasy.document.expand.entity.references", "false");
        servlet.addInitParameter("resteasy.document.secure.processing.feature", "true");
        servlet.addInitParameter("resteasy.document.secure.disableDTDs", "true");
        servlet.addInitParameter("resteasy.servlet.mapping.prefix", customProperties.getServer().getKeycloakPath());
        servlet.addInitParameter("resteasy.use.container.form.params", "false");
        servlet.addInitParameter("resteasy.disable.html.sanitizer", "true");
        servlet.addUrlMappings(new String[]{customProperties.getServer().getKeycloakPath() + "/*"});
        servlet.setLoadOnStartup(2);
        servlet.setAsyncSupported(true);
        return servlet;
    }

    private void initKeycloakEnvironmentFromProfiles() {
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("profile.properties");){
            if (in == null) {
                log.info("Could not find profile.properties on classpath.");
                return;
            }
            Properties profile = new Properties();
            profile.load(in);
            log.info("Found profile.properties on classpath.");
            String profilePrefix = "keycloak.profile.";
            for (Object key : profile.keySet()) {
                String value = (String)profile.get(key);
                String featureName = key.toString().toLowerCase();
                String currentValue = System.getProperty(profilePrefix + featureName);
                if (currentValue != null) continue;
                System.setProperty(profilePrefix + featureName, value);
            }
        }
        catch (IOException ioe) {
            log.warn("Could not read profile.properties.", (Throwable)ioe);
        }
    }

    @Bean
    @ConditionalOnMissingBean(name={"keycloakSessionManagement"})
    protected FilterRegistrationBean<Filter> keycloakSessionManagement(KeycloakCustomProperties customProperties) {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setName("Keycloak Session Management");
        filter.setFilter((Filter)new KeycloakUndertowRequestFilter());
        filter.addUrlPatterns(new String[]{customProperties.getServer().getKeycloakPath() + "/*"});
        return filter;
    }
}

