/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasdarimont.keycloak.embedded.support;

import com.google.auto.service.AutoService;
import java.io.File;
import org.keycloak.platform.PlatformProvider;
import org.keycloak.services.ServicesLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.context.event.SmartApplicationListener;

@AutoService(value={PlatformProvider.class})
public class SpringBootPlatformProvider
implements PlatformProvider,
SmartApplicationListener {
    private static final Logger log = LoggerFactory.getLogger(SpringBootPlatformProvider.class);
    protected File tmpDir;
    protected Runnable onStartup;
    protected Runnable onShutdown;

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationReadyEvent) {
            this.startup();
        } else if (event instanceof ContextStoppedEvent) {
            this.shutdown();
        }
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ApplicationReadyEvent.class.equals(eventType) || ContextStoppedEvent.class.equals(eventType);
    }

    public String getListenerId() {
        return this.getClass().getName();
    }

    public void onStartup(Runnable onStartup) {
        this.onStartup = onStartup;
    }

    public void onShutdown(Runnable onShutdown) {
        this.onShutdown = onShutdown;
    }

    public void exit(Throwable cause) {
        log.error("exit", cause);
        ServicesLogger.LOGGER.fatal((Object)cause);
        throw new RuntimeException(cause);
    }

    public File getTmpDirectory() {
        return this.tmpDir;
    }

    protected void shutdown() {
        this.onShutdown.run();
    }

    protected void startup() {
        this.tmpDir = this.createTempDir();
        this.onStartup.run();
    }

    protected File createTempDir() {
        String tmpDirBase = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpDirBase, "keycloak-spring-tmp");
        boolean couldCreateDirs = tmpDir.mkdirs();
        if (couldCreateDirs || tmpDir.exists()) {
            log.debug("Using server tmp directory: {}", (Object)tmpDir.getAbsolutePath());
            return tmpDir;
        }
        throw new RuntimeException("Failed to create temp directory: " + tmpDir.getAbsolutePath());
    }
}

