/*
 * Decompiled with CFR 0.152.
 */
package com.thomasbouvier.persistentcookiejar.cache;

import com.thomasbouvier.persistentcookiejar.cache.CookieCache;
import com.thomasbouvier.persistentcookiejar.cache.IdentifiableCookie;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Cookie;

public class SetCookieCache
implements CookieCache {
    private Set<IdentifiableCookie> cookies = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    public void addAll(Collection<Cookie> newCookies) {
        for (IdentifiableCookie cookie : IdentifiableCookie.decorateAll(newCookies)) {
            this.cookies.remove(cookie);
            this.cookies.add(cookie);
        }
    }

    @Override
    public void clear() {
        this.cookies.clear();
    }

    @Override
    public Iterator<Cookie> iterator() {
        return new SetCookieCacheIterator();
    }

    private class SetCookieCacheIterator
    implements Iterator<Cookie> {
        private Iterator<IdentifiableCookie> iterator;

        public SetCookieCacheIterator() {
            this.iterator = SetCookieCache.this.cookies.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Cookie next() {
            return this.iterator.next().getCookie();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

