/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc.scribe;

import com.github.therapi.runtimejavadoc.RetainJavadoc;
import com.github.therapi.runtimejavadoc.internal.RuntimeJavadocHelper;
import com.github.therapi.runtimejavadoc.repack.com.eclipsesource.json.JsonObject;
import com.github.therapi.runtimejavadoc.scribe.JsonJavadocBuilder;
import com.github.therapi.runtimejavadoc.scribe.PackageFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class JavadocAnnotationProcessor
extends AbstractProcessor {
    private static final String PACKAGES_OPTION = "javadoc.packages";
    private JsonJavadocBuilder jsonJavadocBuilder;
    static final Optional<ElementKind> RECORD = JavadocAnnotationProcessor.findValueOf(ElementKind.class, "RECORD");
    private static final EnumSet<ElementKind> elementKindsToInspect = EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ENUM);

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        this.jsonJavadocBuilder = new JsonJavadocBuilder(this.processingEnv);
        Map<String, String> options = this.processingEnv.getOptions();
        String packagesOption = options.get(PACKAGES_OPTION);
        PackageFilter packageFilter = packagesOption == null ? new PackageFilter() : new PackageFilter(packagesOption);
        HashSet<Element> alreadyProcessed = new HashSet<Element>();
        if (!packageFilter.allowAllPackages()) {
            for (TypeElement typeElement : annotations) {
                if (!JavadocAnnotationProcessor.isRetainJavadocAnnotation(typeElement)) continue;
                for (Element element : roundEnvironment.getElementsAnnotatedWith(typeElement)) {
                    this.generateJavadoc(element, alreadyProcessed);
                }
            }
        }
        for (Element element : roundEnvironment.getRootElements()) {
            if (!packageFilter.test(element)) continue;
            this.generateJavadoc(element, alreadyProcessed);
        }
        return false;
    }

    private static boolean isRetainJavadocAnnotation(TypeElement annotation) {
        return annotation.getQualifiedName().toString().equals(RetainJavadoc.class.getName()) || annotation.getAnnotation(RetainJavadoc.class) != null;
    }

    private static <E extends Enum<E>> Optional<E> findValueOf(Class<E> enumClass, String valueName) {
        try {
            return Optional.of(Enum.valueOf(enumClass, valueName));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private void generateJavadoc(Element element, Set<Element> alreadyProcessed) {
        ElementKind kind = element.getKind();
        if (elementKindsToInspect.contains((Object)kind)) {
            try {
                this.generateJavadocForClass(element, alreadyProcessed);
            }
            catch (Exception ex) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Javadoc retention failed; " + ex, element);
                throw new RuntimeException("Javadoc retention failed for " + element, ex);
            }
        }
        for (Element element2 : element.getEnclosedElements()) {
            this.generateJavadoc(element2, alreadyProcessed);
        }
    }

    private void generateJavadocForClass(Element element, Set<Element> alreadyProcessed) throws IOException {
        if (!alreadyProcessed.add(element)) {
            return;
        }
        TypeElement classElement = (TypeElement)element;
        JsonObject maybeClassJsonDoc = this.jsonJavadocBuilder.getClassJavadocAsJsonOrNull(classElement);
        if (maybeClassJsonDoc != null) {
            this.outputJsonDoc(classElement, maybeClassJsonDoc);
        }
    }

    private void outputJsonDoc(TypeElement classElement, JsonObject classJsonDoc) throws IOException {
        String jsonString = classJsonDoc.toString();
        FileObject resource = this.createJavadocResourceFile(classElement);
        try (OutputStream os = resource.openOutputStream();){
            os.write(jsonString.getBytes(StandardCharsets.UTF_8));
        }
    }

    private FileObject createJavadocResourceFile(TypeElement classElement) throws IOException {
        PackageElement packageElement = JavadocAnnotationProcessor.getPackageElement(classElement);
        String packageName = packageElement.getQualifiedName().toString();
        String relativeName = JavadocAnnotationProcessor.getClassName(classElement) + RuntimeJavadocHelper.javadocResourceSuffix();
        return this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, packageName, relativeName, classElement);
    }

    private static PackageElement getPackageElement(Element element) {
        if (element instanceof PackageElement) {
            return (PackageElement)element;
        }
        return JavadocAnnotationProcessor.getPackageElement(element.getEnclosingElement());
    }

    private static String getClassName(TypeElement typeElement) {
        String typeName = typeElement.getQualifiedName().toString();
        String packageName = JavadocAnnotationProcessor.getPackageElement(typeElement).getQualifiedName().toString();
        if (!packageName.isEmpty()) {
            typeName = typeName.substring(packageName.length() + 1);
        }
        typeName = typeName.replace(".", "$");
        return typeName;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Collections.singleton(PACKAGES_OPTION);
    }

    static {
        RECORD.ifPresent(elementKindsToInspect::add);
    }
}

