/*
 * Decompiled with CFR 0.152.
 */
package com.thekhaeng.library.uiadjustment.debug.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import com.thekhaeng.library.uiadjustment.debug.R;
import com.thekhaeng.library.uiadjustment.debug.adapter.model.AdjustColor;

public class SingleColorDrawable
extends Drawable {
    private final int borderWidth;
    private final int minSizeInPx;
    private final Context context;
    private final Paint paintBorder = new Paint();
    private final Paint paintFill = new Paint();
    private Drawable checkMark;
    private AdjustColor colorItem;

    public SingleColorDrawable(Context context) {
        this.context = context;
        this.minSizeInPx = context.getResources().getDimensionPixelSize(R.dimen.color_circle_minimum_size);
        this.borderWidth = context.getResources().getDimensionPixelSize(R.dimen.color_circle_border);
        this.paintBorder.setColor(-12303292);
        this.paintBorder.setStyle(Paint.Style.STROKE);
        this.paintBorder.setStrokeWidth((float)this.borderWidth);
        this.paintBorder.setAntiAlias(true);
        this.paintFill.setStyle(Paint.Style.FILL);
        this.paintFill.setAntiAlias(true);
        this.setBounds(0, 0, this.minSizeInPx, this.minSizeInPx);
    }

    public void setBounds(@NonNull Rect bounds) {
        if (bounds.height() < this.minSizeInPx || bounds.width() < this.minSizeInPx) {
            return;
        }
        super.setBounds(bounds);
    }

    public void setAlpha(int i) {
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -3;
    }

    public void setColorItem(Context context, AdjustColor colorItem) {
        double contrastRatioWithWhite;
        this.colorItem = colorItem;
        double contrastRatioWithBlack = ColorUtils.calculateContrast((int)-16777216, (int)colorItem.getColor());
        int checkMarkId = contrastRatioWithBlack > (contrastRatioWithWhite = ColorUtils.calculateContrast((int)-1, (int)colorItem.getColor())) ? R.drawable.ic_done_black_24dp : R.drawable.ic_done_white_24dp;
        this.checkMark = ContextCompat.getDrawable((Context)context, (int)checkMarkId);
    }

    public AdjustColor getColorItem() {
        return this.colorItem;
    }

    public void draw(@NonNull Canvas canvas) {
        if (this.colorItem == null) {
            return;
        }
        int size = Math.min(this.getBounds().height(), this.getBounds().width());
        float radius = (float)size / 2.0f;
        canvas.drawCircle(radius, radius, radius - (float)this.borderWidth / 2.0f, this.paintBorder);
        this.paintFill.setColor(this.colorItem.getColor());
        canvas.drawCircle(radius, radius, radius - (float)this.borderWidth / 2.0f, this.paintFill);
        if (this.colorItem.isSelected()) {
            int iconHeight = this.checkMark.getIntrinsicHeight();
            int iconWidth = this.checkMark.getIntrinsicWidth();
            int x = (size - iconWidth) / 2;
            int y = (size - iconHeight) / 2;
            this.checkMark.setBounds(x, y, x + iconWidth, y + iconHeight);
            this.checkMark.draw(canvas);
        }
    }
}

