/*
 * Decompiled with CFR 0.152.
 */
package com.thekhaeng.library.uiadjustment.debug.adapter.holder;

import android.annotation.SuppressLint;
import android.support.v7.widget.AppCompatTextView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.SeekBar;
import com.thekhaeng.library.uiadjustment.debug.R;
import com.thekhaeng.library.uiadjustment.debug.adapter.holder.BaseAdjustViewHolder;
import com.thekhaeng.library.uiadjustment.debug.adapter.item.RangeFloatAdjustment;
import com.thekhaeng.library.uiadjustment.debug.widget.FloatSeekBar;

public class RangeFloatAdjustHolder
extends BaseAdjustViewHolder<RangeFloatAdjustment> {
    private AppCompatTextView tvTitle;
    private AppCompatTextView tvCommon;
    private AppCompatTextView tvCurrentValue;
    private FloatSeekBar seekbar;

    public RangeFloatAdjustHolder(ViewGroup parent) {
        super(parent, R.layout.library_holder_adjust_range_float);
    }

    @Override
    public void onBindView(View view) {
        this.tvCommon = (AppCompatTextView)view.findViewById(R.id.library_holder_tv_common);
        this.tvTitle = (AppCompatTextView)view.findViewById(R.id.library_holder_tv_title);
        this.tvCurrentValue = (AppCompatTextView)view.findViewById(R.id.library_holder_tv_current_value);
        this.seekbar = (FloatSeekBar)view.findViewById(R.id.library_holder_seekbar);
    }

    @Override
    public void onBind(RangeFloatAdjustment item) {
        super.onBind(item);
        if (item.isCommon()) {
            this.tvCommon.setVisibility(0);
        } else {
            this.tvCommon.setVisibility(8);
        }
        this.tvTitle.setText((CharSequence)item.getTitle());
        this.seekbar.setBoundaries(item.getValue().getMinValue(), item.getValue().getMaxValue(), item.getValue().getIncrement());
        this.seekbar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            @SuppressLint(value={"DefaultLocale"})
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                RangeFloatAdjustHolder.this.tvCurrentValue.setText((CharSequence)String.format("%.2f", Float.valueOf(RangeFloatAdjustHolder.this.seekbar.getValue())));
                ((RangeFloatAdjustment)RangeFloatAdjustHolder.this.getItem()).getValue().setCurrentValue(RangeFloatAdjustHolder.this.seekbar.getValue());
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.seekbar.setValue(item.getValue().getCurrentValue());
    }
}

