/*
 * Decompiled with CFR 0.152.
 */
package com.thekhaeng.library.uiadjustment.debug.adapter.model;

import android.content.Context;
import android.graphics.Color;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.v4.content.ContextCompat;
import com.thekhaeng.library.uiadjustment.debug.adapter.model.BaseAdjustModel;

public class AdjustColor
extends BaseAdjustModel {
    private String color = "";
    private int id = -1;
    public static final Parcelable.Creator<AdjustColor> CREATOR = new Parcelable.Creator<AdjustColor>(){

        public AdjustColor createFromParcel(Parcel source) {
            return new AdjustColor(source);
        }

        public AdjustColor[] newArray(int size) {
            return new AdjustColor[size];
        }
    };

    private AdjustColor() {
        super(false);
    }

    public AdjustColor(@ColorRes int id2) {
        super(false);
        this.id = id2;
    }

    public AdjustColor(@ColorRes int id2, boolean selected) {
        super(selected);
        this.id = id2;
    }

    public AdjustColor(String color) {
        super(false);
        this.color = color;
    }

    public AdjustColor(String color, boolean selected) {
        super(selected);
        this.color = color;
    }

    public AdjustColor setColor(String color) {
        this.color = color;
        return this;
    }

    public AdjustColor setId(int id2) {
        this.id = id2;
        return this;
    }

    @Override
    public AdjustColor setSelected(boolean selected) {
        return (AdjustColor)super.setSelected(selected);
    }

    public int getId() {
        return this.id;
    }

    @ColorInt
    public int getColor(Context context) {
        if (this.isUseId()) {
            return ContextCompat.getColor((Context)context, (int)this.id);
        }
        return Color.parseColor((String)this.color);
    }

    public AdjustColor copy() {
        return new AdjustColor().setColor(this.color).setId(this.id).setSelected(this.isSelected());
    }

    public boolean isUseId() {
        return this.color == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdjustColor)) {
            return false;
        }
        AdjustColor that = (AdjustColor)o;
        if (this.getId() != that.getId()) {
            return false;
        }
        return this.color.equals(that.color);
    }

    public int hashCode() {
        int result = this.color.hashCode();
        result = 31 * result + this.getId();
        return result;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.color);
        dest.writeInt(this.id);
    }

    protected AdjustColor(Parcel in) {
        super(in);
        this.color = in.readString();
        this.id = in.readInt();
    }
}

