/*
 * Decompiled with CFR 0.152.
 */
package com.thekhaeng.library.uiadjustment.debug.adapter.item;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.view.View;
import com.thekhaeng.library.uiadjustment.debug.adapter.item.BaseAdjustItem;
import com.thekhaeng.library.uiadjustment.debug.adapter.model.AdjustString;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class StringAdjustment
extends BaseAdjustItem<AdjustString> {
    private Map<String, AdjustString> mapString = new HashMap<String, AdjustString>();
    public static final Parcelable.Creator<StringAdjustment> CREATOR = new Parcelable.Creator<StringAdjustment>(){

        public StringAdjustment createFromParcel(Parcel source) {
            return new StringAdjustment(source);
        }

        public StringAdjustment[] newArray(int size) {
            return new StringAdjustment[size];
        }
    };

    public static StringAdjustment create(@NonNull View view, String title, Map<String, AdjustString> map) {
        return StringAdjustment.create(view.getId(), title, map, false);
    }

    public static StringAdjustment create(@IdRes int id2, String title, Map<String, AdjustString> map) {
        return StringAdjustment.create(id2, title, map, false);
    }

    public static StringAdjustment create(@NonNull View view, String title, Map<String, AdjustString> map, boolean isCommon) {
        return StringAdjustment.create(view.getId(), title, map, isCommon);
    }

    public static StringAdjustment create(@IdRes int id2, String title, Map<String, AdjustString> map, boolean isCommon) {
        if (map == null || map.isEmpty()) {
            return new StringAdjustment(id2);
        }
        return new StringAdjustment(id2, title, map, isCommon);
    }

    private StringAdjustment(int id2) {
        super(id2, "EMPTY", 5, false);
    }

    private StringAdjustment(int id2, String title, Map<String, AdjustString> map, boolean isCommon) {
        super(id2, title, 5, isCommon);
        this.mapString = map;
    }

    public void setMapString(Map<String, AdjustString> mapString) {
        this.mapString = mapString;
    }

    public Map<String, AdjustString> getMapString() {
        return this.mapString;
    }

    public int getCurrentIndex() {
        int index = 0;
        for (Map.Entry<String, AdjustString> entry : this.mapString.entrySet()) {
            AdjustString value = entry.getValue();
            if (value.isSelected()) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    public AdjustString getValue() {
        for (Map.Entry<String, AdjustString> entry : this.mapString.entrySet()) {
            AdjustString value = entry.getValue();
            if (!value.isSelected()) continue;
            return value;
        }
        return null;
    }

    public void unSelectAll() {
        for (Map.Entry<String, AdjustString> entry : this.mapString.entrySet()) {
            entry.getValue().setSelected(false);
        }
    }

    @Override
    public Class<AdjustString> getStorageClass() {
        return AdjustString.class;
    }

    @Override
    public StringAdjustment copy() {
        LinkedHashMap<String, AdjustString> copyMapString = new LinkedHashMap<String, AdjustString>();
        for (Map.Entry<String, AdjustString> entry : this.mapString.entrySet()) {
            copyMapString.put(entry.getKey(), entry.getValue().copy());
        }
        return new StringAdjustment(this.getId(), this.getTitle(), copyMapString, this.isCommon());
    }

    @Override
    public void selectValue(Object object) {
        if (object instanceof AdjustString) {
            AdjustString adjustString = (AdjustString)object;
            for (Map.Entry<String, AdjustString> entry : this.mapString.entrySet()) {
                if (!entry.getValue().equals(adjustString)) continue;
                this.unSelectAll();
                entry.getValue().setSelected(true);
                return;
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.mapString.size());
        for (Map.Entry<String, AdjustString> entry : this.mapString.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeParcelable((Parcelable)entry.getValue(), flags);
        }
    }

    protected StringAdjustment(Parcel in) {
        super(in);
        int mapStringSize = in.readInt();
        this.mapString = new HashMap<String, AdjustString>(mapStringSize);
        for (int i = 0; i < mapStringSize; ++i) {
            String key = in.readString();
            AdjustString value = (AdjustString)in.readParcelable(AdjustString.class.getClassLoader());
            this.mapString.put(key, value);
        }
    }
}

