/*
 * Decompiled with CFR 0.152.
 */
package com.thekhaeng.library.uiadjustment.debug;

import android.support.annotation.ColorInt;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.view.View;
import com.thekhaeng.library.uiadjustment.core.UIAdjustmentInterface;
import com.thekhaeng.library.uiadjustment.debug.UIAdjustBottomSheet;
import com.thekhaeng.library.uiadjustment.debug.UIAdjustmentDelegate;
import com.thekhaeng.library.uiadjustment.debug.adapter.item.BaseAdjustItem;
import java.lang.ref.WeakReference;
import java.util.List;

public abstract class UIFragmentAdjustment<A extends Fragment>
implements UIAdjustmentInterface {
    private final WeakReference<A> weakFragment;
    private final WeakReference<View> weakButton;
    private final UIAdjustmentDelegate uiAdjustmentDelegate;
    private UIAdjustBottomSheet.OnDismissBottomSheetListener dismissListener = new UIAdjustBottomSheet.OnDismissBottomSheetListener(){

        @Override
        public void onDone(List<BaseAdjustItem> itemList) {
            UIFragmentAdjustment.this.uiAdjustmentDelegate.bindData(itemList);
        }

        @Override
        public void onCancel() {
        }
    };

    public UIFragmentAdjustment(A fragment, View button) {
        button.setVisibility(0);
        this.weakFragment = new WeakReference<A>(fragment);
        this.weakButton = new WeakReference<View>(button);
        this.uiAdjustmentDelegate = new UIAdjustmentDelegate(fragment.getContext(), this);
        this.setupButton();
    }

    private void setupButton() {
        this.getButton().setOnClickListener(this.setOnButtonClickListener());
    }

    public A getFragment() {
        return (A)((Fragment)this.weakFragment.get());
    }

    public View getButton() {
        return (View)this.weakButton.get();
    }

    public UIAdjustmentInterface setDelayMillisTime(long delay) {
        this.uiAdjustmentDelegate.setDelay(delay);
        return this;
    }

    public UIAdjustmentInterface setUseLocalStorage(boolean useLocalStorage, boolean bindDataImmediately) {
        this.uiAdjustmentDelegate.setUseLocalStorage(useLocalStorage);
        this.uiAdjustmentDelegate.setBindDataImmediately(bindDataImmediately);
        if (bindDataImmediately) {
            this.uiAdjustmentDelegate.bindData(this.uiAdjustmentDelegate.getItemList(this.createAdjustItemList()));
        }
        return this;
    }

    public void onBoolean(@IdRes int id2, boolean value) {
    }

    public void onColor(@IdRes int id2, @ColorInt int value) {
    }

    public void onInteger(@IdRes int id2, int value) {
    }

    public void onRangeFloat(@IdRes int id2, float value) {
    }

    public void onString(@IdRes int id2, String value) {
    }

    @NonNull
    private View.OnClickListener setOnButtonClickListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                List<BaseAdjustItem> itemList = UIFragmentAdjustment.this.createAdjustItemList();
                UIAdjustBottomSheet bottomSheet = UIAdjustBottomSheet.create(UIFragmentAdjustment.this.uiAdjustmentDelegate.copyItemList(itemList), UIFragmentAdjustment.this.uiAdjustmentDelegate.getItemList(itemList));
                bottomSheet.setOnDismissBottomSheetListener(UIFragmentAdjustment.this.dismissListener);
                bottomSheet.setDelayTime(UIFragmentAdjustment.this.uiAdjustmentDelegate.getDelay());
                bottomSheet.show(UIFragmentAdjustment.this.getFragment().getChildFragmentManager(), UIFragmentAdjustment.this.getFragment().getClass().getSimpleName());
            }
        };
    }

    @NonNull
    protected abstract List<BaseAdjustItem> createAdjustItemList();
}

