/*
 * Decompiled with CFR 0.152.
 */
package com.thekhaeng.library.uiadjustment.debug;

import android.content.Context;
import com.thekhaeng.library.uiadjustment.core.UIAdjustmentInterface;
import com.thekhaeng.library.uiadjustment.debug.DefaultLocalStorage;
import com.thekhaeng.library.uiadjustment.debug.adapter.item.BaseAdjustItem;
import com.thekhaeng.library.uiadjustment.debug.adapter.item.BooleanAdjustment;
import com.thekhaeng.library.uiadjustment.debug.adapter.item.ColorAdjustment;
import com.thekhaeng.library.uiadjustment.debug.adapter.item.IntegerAdjustment;
import com.thekhaeng.library.uiadjustment.debug.adapter.item.RangeFloatAdjustment;
import com.thekhaeng.library.uiadjustment.debug.adapter.item.StringAdjustment;
import com.thekhaeng.library.uiadjustment.debug.adapter.model.AdjustColor;
import com.thekhaeng.library.uiadjustment.debug.adapter.model.AdjustInteger;
import com.thekhaeng.library.uiadjustment.debug.adapter.model.AdjustRangeFloat;
import com.thekhaeng.library.uiadjustment.debug.adapter.model.AdjustString;
import java.util.ArrayList;
import java.util.List;

class UIAdjustmentDelegate {
    private final DefaultLocalStorage storage;
    private final UIAdjustmentInterface adjustInterface;
    private final Context context;
    private long delay = 0L;
    private boolean isUseLocalStorage = false;
    private boolean bindDataImmediately = false;

    UIAdjustmentDelegate(Context context, UIAdjustmentInterface adjustInterface) {
        this.context = context;
        this.storage = DefaultLocalStorage.getInstance(context);
        this.adjustInterface = adjustInterface;
    }

    void setDelay(long delay) {
        this.delay = delay;
    }

    void setUseLocalStorage(boolean useLocalStorage) {
        this.isUseLocalStorage = useLocalStorage;
    }

    void setBindDataImmediately(boolean bindDataImmediately) {
        this.bindDataImmediately = bindDataImmediately;
    }

    List<BaseAdjustItem> copyItemList(List<BaseAdjustItem> itemList) {
        ArrayList<BaseAdjustItem> copyItemList = new ArrayList<BaseAdjustItem>();
        for (BaseAdjustItem item : itemList) {
            copyItemList.add(item.copy());
        }
        return copyItemList;
    }

    List<BaseAdjustItem> getItemList(List<BaseAdjustItem> defaultItemList) {
        if (this.isUseLocalStorage) {
            for (BaseAdjustItem item : defaultItemList) {
                Object data = item.isCommon() ? this.storage.load(item.getId() + "", item.getStorageClass()) : this.storage.load(this.getStorageKey(item.getId(), item.getType()), item.getStorageClass());
                if (data == null) continue;
                item.selectValue(data);
            }
        }
        return defaultItemList;
    }

    String getStorageKey(int id2, int type) {
        return this.getClass().getSimpleName() + "_" + id2 + "_" + type;
    }

    void bindData(List<BaseAdjustItem> itemList) {
        if (itemList != null) {
            for (BaseAdjustItem item : itemList) {
                int id2 = item.getId();
                if (item instanceof BooleanAdjustment) {
                    boolean value = ((BooleanAdjustment)item).getValue();
                    if (this.isUseLocalStorage) {
                        if (item.isCommon()) {
                            this.storage.save(id2 + "", value);
                        } else {
                            this.storage.save(this.getStorageKey(id2, 1), value);
                        }
                    }
                    if (this.adjustInterface == null) continue;
                    this.adjustInterface.onBoolean(id2, value);
                    continue;
                }
                if (item instanceof ColorAdjustment) {
                    AdjustColor color = ((ColorAdjustment)item).getValue();
                    if (this.isUseLocalStorage) {
                        if (item.isCommon()) {
                            this.storage.save(id2 + "", color);
                        } else {
                            this.storage.save(this.getStorageKey(id2, 2), color);
                        }
                    }
                    if (color == null || this.adjustInterface == null) continue;
                    this.adjustInterface.onColor(id2, color.getColor(this.context));
                    continue;
                }
                if (item instanceof IntegerAdjustment) {
                    AdjustInteger value = ((IntegerAdjustment)item).getValue();
                    if (this.isUseLocalStorage) {
                        if (item.isCommon()) {
                            this.storage.save(id2 + "", value);
                        } else {
                            this.storage.save(this.getStorageKey(id2, 3), value);
                        }
                    }
                    if (value == null || this.adjustInterface == null) continue;
                    this.adjustInterface.onInteger(id2, value.getValue());
                    continue;
                }
                if (item instanceof RangeFloatAdjustment) {
                    AdjustRangeFloat value = ((RangeFloatAdjustment)item).getValue();
                    if (this.isUseLocalStorage) {
                        if (item.isCommon()) {
                            this.storage.save(id2 + "", value);
                        } else {
                            this.storage.save(this.getStorageKey(id2, 4), value);
                        }
                    }
                    if (this.adjustInterface == null) continue;
                    this.adjustInterface.onRangeFloat(id2, value.getCurrentValue());
                    continue;
                }
                if (!(item instanceof StringAdjustment)) continue;
                AdjustString value = ((StringAdjustment)item).getValue();
                if (this.isUseLocalStorage) {
                    if (item.isCommon()) {
                        this.storage.save(id2 + "", value);
                    } else {
                        this.storage.save(this.getStorageKey(id2, 5), value);
                    }
                }
                if (value == null || this.adjustInterface == null) continue;
                this.adjustInterface.onString(id2, value.getValue());
            }
        }
    }

    long getDelay() {
        return this.delay;
    }

    boolean isUseLocalStorage() {
        return this.isUseLocalStorage;
    }

    boolean isBindDataImmediately() {
        return this.bindDataImmediately;
    }
}

