/*
 * Decompiled with CFR 0.152.
 */
package com.thekhaeng.library.uiadjustment.debug;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.thekhaeng.library.uiadjustment.core.UIAdjustmentInterface;
import com.thekhaeng.library.uiadjustment.debug.UIAdjustBottomSheet;
import com.thekhaeng.library.uiadjustment.debug.UIAdjustmentDelegate;
import com.thekhaeng.library.uiadjustment.debug.adapter.item.BaseAdjustItem;
import java.lang.ref.WeakReference;
import java.util.List;

public abstract class UIActivityAdjustment<A extends FragmentActivity>
implements UIAdjustmentInterface {
    private final WeakReference<A> weakActivity;
    private final WeakReference<View> weakButton;
    private final UIAdjustmentDelegate uiAdjustmentDelegate;
    private UIAdjustBottomSheet.OnDismissBottomSheetListener dismissListener = new UIAdjustBottomSheet.OnDismissBottomSheetListener(){

        @Override
        public void onDone(List<BaseAdjustItem> itemList) {
            UIActivityAdjustment.this.uiAdjustmentDelegate.bindData(itemList);
        }

        @Override
        public void onCancel() {
        }
    };

    public UIActivityAdjustment(A activity, View button) {
        button.setVisibility(0);
        this.weakActivity = new WeakReference<A>(activity);
        this.weakButton = new WeakReference<View>(button);
        this.uiAdjustmentDelegate = new UIAdjustmentDelegate((Context)activity, this);
        this.setupButton();
    }

    private void setupButton() {
        this.getButton().setOnClickListener(this.setOnButtonClickListener());
    }

    public A getActivity() {
        return (A)((FragmentActivity)this.weakActivity.get());
    }

    public View getButton() {
        return (View)this.weakButton.get();
    }

    public UIAdjustmentInterface setDelayMillisTime(long delay) {
        this.uiAdjustmentDelegate.setDelay(delay);
        return this;
    }

    public UIAdjustmentInterface setUseLocalStorage(boolean useLocalStorage, boolean bindDataImmediately) {
        this.uiAdjustmentDelegate.setUseLocalStorage(useLocalStorage);
        this.uiAdjustmentDelegate.setBindDataImmediately(bindDataImmediately);
        if (bindDataImmediately) {
            this.uiAdjustmentDelegate.bindData(this.uiAdjustmentDelegate.getItemList(this.createAdjustItemList()));
        }
        return this;
    }

    public void onBoolean(@IdRes int id2, boolean value) {
    }

    public void onColor(@IdRes int id2, @ColorInt int value) {
    }

    public void onInteger(@IdRes int id2, int value) {
    }

    public void onRangeFloat(@IdRes int id2, float value) {
    }

    public void onString(@IdRes int id2, String value) {
    }

    @NonNull
    private View.OnClickListener setOnButtonClickListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                List<BaseAdjustItem> itemList = UIActivityAdjustment.this.createAdjustItemList();
                UIAdjustBottomSheet bottomSheet = UIAdjustBottomSheet.create(UIActivityAdjustment.this.uiAdjustmentDelegate.copyItemList(itemList), UIActivityAdjustment.this.uiAdjustmentDelegate.getItemList(itemList));
                bottomSheet.setOnDismissBottomSheetListener(UIActivityAdjustment.this.dismissListener);
                bottomSheet.setDelayTime(UIActivityAdjustment.this.uiAdjustmentDelegate.getDelay());
                bottomSheet.show(UIActivityAdjustment.this.getActivity().getSupportFragmentManager(), UIActivityAdjustment.this.getActivity().getClass().getSimpleName());
            }
        };
    }

    @NonNull
    protected abstract List<BaseAdjustItem> createAdjustItemList();
}

