/*
 * Decompiled with CFR 0.152.
 */
package com.thekhaeng.library.uiadjustment.debug;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.thekhaeng.library.uiadjustment.core.UIAdjustmentLocalStorage;

public class DefaultLocalStorage
implements UIAdjustmentLocalStorage {
    private static DefaultLocalStorage instance;
    private Context context;

    public static DefaultLocalStorage getInstance(Context context) {
        if (instance == null) {
            instance = new DefaultLocalStorage(context);
        }
        return instance;
    }

    private DefaultLocalStorage(Context context) {
        this.context = context;
    }

    public void save(String key, Object object) {
        this.persistString(this.context, key, this.convertObjectToString(object), true);
    }

    @Nullable
    public <T> T load(String key, Class<T> clazz) {
        return this.convertStringToObject(this.getPersistString(this.context, key, null, true), clazz);
    }

    private String convertObjectToString(Object object) {
        return this.getDefaultGson().toJson(object);
    }

    private <T> T convertStringToObject(String json, Class<T> clazz) {
        if (json != null) {
            return (T)this.getDefaultGson().fromJson(json, clazz);
        }
        return null;
    }

    private Gson getDefaultGson() {
        return new Gson();
    }

    private boolean persistString(Context context, String key, String value, boolean shouldPersist) {
        if (shouldPersist) {
            if (TextUtils.equals((CharSequence)value, (CharSequence)this.getPersistString(context, key, null, shouldPersist))) {
                return true;
            }
            SharedPreferences.Editor editor = this.getSharedPreferences(context).edit();
            editor.putString(key, value);
            editor.apply();
            return true;
        }
        return false;
    }

    private String getPersistString(Context context, String key, String defaultValue, boolean shouldPersist) {
        if (!shouldPersist) {
            return defaultValue;
        }
        return this.getSharedPreferences(context).getString(key, defaultValue);
    }

    private SharedPreferences getSharedPreferences(Context context) {
        return PreferenceManager.getDefaultSharedPreferences((Context)context);
    }
}

