/*
 * Decompiled with CFR 0.152.
 */
package com.thekhaeng.library.uiadjust.widget;

import android.content.Context;
import android.support.v7.widget.AppCompatSeekBar;
import android.util.AttributeSet;

public class FloatSeekBar
extends AppCompatSeekBar {
    private float min = 0.0f;
    private float max = 1.0f;
    private float stepSize = 0.01f;

    public FloatSeekBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setBoundaries(this.min, this.max, this.stepSize);
    }

    public FloatSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setBoundaries(this.min, this.max, this.stepSize);
    }

    public FloatSeekBar(Context context) {
        super(context);
        this.setBoundaries(this.min, this.max, this.stepSize);
    }

    public void setBoundaries(float min, float max, float stepSize) {
        this.min = min;
        this.max = max;
        this.stepSize = stepSize;
        int numberOfSteps = (int)((max - min) / stepSize);
        this.setMax(numberOfSteps);
    }

    public void setValue(float value) {
        this.setProgress((int)((value - this.min) / this.stepSize));
    }

    public float getValue() {
        return (float)this.getProgress() * this.stepSize + this.min;
    }
}

