/*
 * Decompiled with CFR 0.152.
 */
package com.thekhaeng.library.uiadjust;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.view.View;
import com.thekhaeng.library.uiadjust.DefaultLocalStorage;
import com.thekhaeng.library.uiadjust.UIAdjustBottomSheet;
import com.thekhaeng.library.uiadjust.UIAdjustmentInterface;
import com.thekhaeng.library.uiadjust.UIAdjustmentLocalStorage;
import com.thekhaeng.library.uiadjust.adapter.item.BaseAdjustItem;
import com.thekhaeng.library.uiadjust.adapter.item.BooleanAdjustment;
import com.thekhaeng.library.uiadjust.adapter.item.ColorAdjustment;
import com.thekhaeng.library.uiadjust.adapter.item.IntegerAdjustment;
import com.thekhaeng.library.uiadjust.adapter.item.RangeFloatAdjustment;
import com.thekhaeng.library.uiadjust.adapter.item.StringAdjustment;
import com.thekhaeng.library.uiadjust.adapter.model.AdjustColor;
import com.thekhaeng.library.uiadjust.adapter.model.AdjustInteger;
import com.thekhaeng.library.uiadjust.adapter.model.AdjustRangeFloat;
import com.thekhaeng.library.uiadjust.adapter.model.AdjustString;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class UIFragmentAdjustment<A extends Fragment>
implements UIAdjustmentInterface {
    private final WeakReference<A> weakFragment;
    private final WeakReference<View> weakButton;
    private final UIAdjustmentLocalStorage storage;
    private boolean isUseLocalStorage = false;
    private long delay = 0L;
    private boolean bindDataImmediately = false;
    private UIAdjustBottomSheet.OnDismissBottomSheetListener dismissListener = new UIAdjustBottomSheet.OnDismissBottomSheetListener(){

        @Override
        public void onDone(List<BaseAdjustItem> itemList) {
            UIFragmentAdjustment.this.bindData(itemList);
        }

        @Override
        public void onCancel() {
        }
    };

    public UIFragmentAdjustment(A fragment, View button) {
        button.setVisibility(0);
        this.weakFragment = new WeakReference<A>(fragment);
        this.weakButton = new WeakReference<View>(button);
        this.storage = DefaultLocalStorage.getInstance(fragment.getContext());
        this.setupButton();
    }

    private void setupButton() {
        this.getButton().setOnClickListener(this.setOnButtonClickListener());
    }

    public A getFragment() {
        return (A)((Fragment)this.weakFragment.get());
    }

    public View getButton() {
        return (View)this.weakButton.get();
    }

    public UIAdjustmentInterface setDelayMillisTime(long delay) {
        this.delay = delay;
        return this;
    }

    public UIAdjustmentInterface setUseLocalStorage(boolean useLocalStorage, boolean bindDataImmediately) {
        this.isUseLocalStorage = useLocalStorage;
        if (bindDataImmediately) {
            this.bindData(this.getItemList(this.createAdjustItemList()));
        }
        return this;
    }

    protected String getStorageKey(int id2, int type) {
        return this.getClass().getSimpleName() + "_" + id2 + "_" + type;
    }

    protected void onBoolean(Fragment activity, @IdRes int id2, boolean value) {
    }

    protected void onColor(Fragment activity, @IdRes int id2, @ColorInt int value) {
    }

    protected void onInteger(Fragment activity, @IdRes int id2, int value) {
    }

    protected void onRangeFloat(Fragment activity, @IdRes int id2, float value) {
    }

    protected void onString(Fragment activity, @IdRes int id2, String value) {
    }

    private List<BaseAdjustItem> copyItemList(List<BaseAdjustItem> itemList) {
        ArrayList<BaseAdjustItem> copyItemList = new ArrayList<BaseAdjustItem>();
        for (BaseAdjustItem item : itemList) {
            copyItemList.add(item.copy());
        }
        return copyItemList;
    }

    private List<BaseAdjustItem> getItemList(List<BaseAdjustItem> defaultItemList) {
        if (this.isUseLocalStorage) {
            for (BaseAdjustItem item : defaultItemList) {
                Object data = this.storage.load(this.getStorageKey(item.getId(), item.getType()), item.getStorageClass());
                if (data == null) continue;
                item.selectValue(data);
            }
        }
        return defaultItemList;
    }

    private Context getContext() {
        return this.getFragment().getContext();
    }

    private void bindData(List<BaseAdjustItem> itemList) {
        if (itemList != null) {
            for (BaseAdjustItem item : itemList) {
                int id2 = item.getId();
                if (item instanceof BooleanAdjustment) {
                    boolean value = ((BooleanAdjustment)item).getValue();
                    if (this.isUseLocalStorage) {
                        this.storage.save(this.getStorageKey(id2, 1), (Object)value);
                    }
                    this.onBoolean((Fragment)this.getFragment(), id2, value);
                    continue;
                }
                if (item instanceof ColorAdjustment) {
                    AdjustColor color = ((ColorAdjustment)item).getValue();
                    if (this.isUseLocalStorage) {
                        this.storage.save(this.getStorageKey(id2, 2), (Object)color);
                    }
                    if (color == null) continue;
                    this.onColor((Fragment)this.getFragment(), id2, color.getColor(this.getContext()));
                    continue;
                }
                if (item instanceof IntegerAdjustment) {
                    AdjustInteger value = ((IntegerAdjustment)item).getValue();
                    if (this.isUseLocalStorage) {
                        this.storage.save(this.getStorageKey(id2, 3), (Object)value);
                    }
                    if (value == null) continue;
                    this.onInteger((Fragment)this.getFragment(), id2, value.getValue());
                    continue;
                }
                if (item instanceof RangeFloatAdjustment) {
                    AdjustRangeFloat value = ((RangeFloatAdjustment)item).getValue();
                    if (this.isUseLocalStorage) {
                        this.storage.save(this.getStorageKey(id2, 4), (Object)value);
                    }
                    this.onRangeFloat((Fragment)this.getFragment(), id2, value.getCurrentValue());
                    continue;
                }
                if (!(item instanceof StringAdjustment)) continue;
                AdjustString value = ((StringAdjustment)item).getValue();
                if (this.isUseLocalStorage) {
                    this.storage.save(this.getStorageKey(id2, 5), (Object)value);
                }
                if (value == null) continue;
                this.onString((Fragment)this.getFragment(), id2, value.getValue());
            }
        }
    }

    @NonNull
    private View.OnClickListener setOnButtonClickListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                List<BaseAdjustItem> itemList = UIFragmentAdjustment.this.createAdjustItemList();
                UIAdjustBottomSheet bottomSheet = UIAdjustBottomSheet.create(UIFragmentAdjustment.this.copyItemList(itemList), UIFragmentAdjustment.this.getItemList(itemList));
                bottomSheet.setOnDismissBottomSheetListener(UIFragmentAdjustment.this.dismissListener);
                bottomSheet.setDelayTime(UIFragmentAdjustment.this.delay);
                bottomSheet.show(UIFragmentAdjustment.this.getFragment().getChildFragmentManager(), UIFragmentAdjustment.this.getFragment().getClass().getSimpleName());
            }
        };
    }

    @NonNull
    protected abstract List<BaseAdjustItem> createAdjustItemList();
}

