/*
 * Decompiled with CFR 0.152.
 */
package com.thekhaeng.library.uiadjust;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.thekhaeng.library.uiadjust.DefaultLocalStorage;
import com.thekhaeng.library.uiadjust.UIAdjustBottomSheet;
import com.thekhaeng.library.uiadjust.UIAdjustmentInterface;
import com.thekhaeng.library.uiadjust.UIAdjustmentLocalStorage;
import com.thekhaeng.library.uiadjust.adapter.item.BaseAdjustItem;
import com.thekhaeng.library.uiadjust.adapter.item.BooleanAdjustment;
import com.thekhaeng.library.uiadjust.adapter.item.ColorAdjustment;
import com.thekhaeng.library.uiadjust.adapter.item.IntegerAdjustment;
import com.thekhaeng.library.uiadjust.adapter.item.RangeFloatAdjustment;
import com.thekhaeng.library.uiadjust.adapter.item.StringAdjustment;
import com.thekhaeng.library.uiadjust.adapter.model.AdjustColor;
import com.thekhaeng.library.uiadjust.adapter.model.AdjustInteger;
import com.thekhaeng.library.uiadjust.adapter.model.AdjustRangeFloat;
import com.thekhaeng.library.uiadjust.adapter.model.AdjustString;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class UIActivityAdjustment<A extends FragmentActivity>
implements UIAdjustmentInterface {
    private final WeakReference<A> weakActivity;
    private final WeakReference<View> weakButton;
    private final UIAdjustmentLocalStorage storage;
    private boolean isUseLocalStorage = false;
    private long delay = 0L;
    private boolean bindDataImmediately = false;
    private UIAdjustBottomSheet.OnDismissBottomSheetListener dismissListener = new UIAdjustBottomSheet.OnDismissBottomSheetListener(){

        @Override
        public void onDone(List<BaseAdjustItem> itemList) {
            UIActivityAdjustment.this.bindData(itemList);
        }

        @Override
        public void onCancel() {
        }
    };

    public UIActivityAdjustment(A activity, View button) {
        button.setVisibility(0);
        this.weakActivity = new WeakReference<A>(activity);
        this.weakButton = new WeakReference<View>(button);
        this.storage = DefaultLocalStorage.getInstance(activity);
        this.setupButton();
    }

    private void setupButton() {
        this.getButton().setOnClickListener(this.setOnButtonClickListener());
    }

    public A getActivity() {
        return (A)((FragmentActivity)this.weakActivity.get());
    }

    public View getButton() {
        return (View)this.weakButton.get();
    }

    public UIAdjustmentInterface setDelayMillisTime(long delay) {
        this.delay = delay;
        return this;
    }

    public UIAdjustmentInterface setUseLocalStorage(boolean useLocalStorage, boolean bindDataImmediately) {
        this.isUseLocalStorage = useLocalStorage;
        if (bindDataImmediately) {
            this.bindData(this.getItemList(this.createAdjustItemList()));
        }
        return this;
    }

    protected String getStorageKey(int id2, int type) {
        return this.getClass().getSimpleName() + "_" + id2 + "_" + type;
    }

    protected void onBoolean(Activity activity, @IdRes int id2, boolean value) {
    }

    protected void onColor(Activity activity, @IdRes int id2, @ColorInt int value) {
    }

    protected void onInteger(Activity activity, @IdRes int id2, int value) {
    }

    protected void onRangeFloat(Activity activity, @IdRes int id2, float value) {
    }

    protected void onString(Activity activity, @IdRes int id2, String value) {
    }

    private List<BaseAdjustItem> copyItemList(List<BaseAdjustItem> itemList) {
        ArrayList<BaseAdjustItem> copyItemList = new ArrayList<BaseAdjustItem>();
        for (BaseAdjustItem item : itemList) {
            copyItemList.add(item.copy());
        }
        return copyItemList;
    }

    private List<BaseAdjustItem> getItemList(List<BaseAdjustItem> defaultItemList) {
        if (this.isUseLocalStorage) {
            for (BaseAdjustItem item : defaultItemList) {
                Object data = this.storage.load(this.getStorageKey(item.getId(), item.getType()), item.getStorageClass());
                if (data == null) continue;
                item.selectValue(data);
            }
        }
        return defaultItemList;
    }

    private void bindData(List<BaseAdjustItem> itemList) {
        if (itemList != null) {
            for (BaseAdjustItem item : itemList) {
                int id2 = item.getId();
                if (item instanceof BooleanAdjustment) {
                    boolean value = ((BooleanAdjustment)item).getValue();
                    if (this.isUseLocalStorage) {
                        this.storage.save(this.getStorageKey(id2, 1), (Object)value);
                    }
                    this.onBoolean((Activity)this.getActivity(), id2, value);
                    continue;
                }
                if (item instanceof ColorAdjustment) {
                    AdjustColor color = ((ColorAdjustment)item).getValue();
                    if (this.isUseLocalStorage) {
                        this.storage.save(this.getStorageKey(id2, 2), (Object)color);
                    }
                    if (color == null) continue;
                    this.onColor((Activity)this.getActivity(), id2, color.getColor((Context)this.getActivity()));
                    continue;
                }
                if (item instanceof IntegerAdjustment) {
                    AdjustInteger value = ((IntegerAdjustment)item).getValue();
                    if (this.isUseLocalStorage) {
                        this.storage.save(this.getStorageKey(id2, 3), (Object)value);
                    }
                    if (value == null) continue;
                    this.onInteger((Activity)this.getActivity(), id2, value.getValue());
                    continue;
                }
                if (item instanceof RangeFloatAdjustment) {
                    AdjustRangeFloat value = ((RangeFloatAdjustment)item).getValue();
                    if (this.isUseLocalStorage) {
                        this.storage.save(this.getStorageKey(id2, 4), (Object)value);
                    }
                    this.onRangeFloat((Activity)this.getActivity(), id2, value.getCurrentValue());
                    continue;
                }
                if (!(item instanceof StringAdjustment)) continue;
                AdjustString value = ((StringAdjustment)item).getValue();
                if (this.isUseLocalStorage) {
                    this.storage.save(this.getStorageKey(id2, 5), (Object)value);
                }
                if (value == null) continue;
                this.onString((Activity)this.getActivity(), id2, value.getValue());
            }
        }
    }

    @NonNull
    private View.OnClickListener setOnButtonClickListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                List<BaseAdjustItem> itemList = UIActivityAdjustment.this.createAdjustItemList();
                UIAdjustBottomSheet bottomSheet = UIAdjustBottomSheet.create(UIActivityAdjustment.this.copyItemList(itemList), UIActivityAdjustment.this.getItemList(itemList));
                bottomSheet.setOnDismissBottomSheetListener(UIActivityAdjustment.this.dismissListener);
                bottomSheet.setDelayTime(UIActivityAdjustment.this.delay);
                bottomSheet.show(UIActivityAdjustment.this.getActivity().getSupportFragmentManager(), UIActivityAdjustment.this.getActivity().getClass().getSimpleName());
            }
        };
    }

    @NonNull
    protected abstract List<BaseAdjustItem> createAdjustItemList();
}

