/*
 * Decompiled with CFR 0.152.
 */
package com.thekhaeng.library.uiadjustment.debug;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.thekhaeng.library.uiadjustment.core.UIAdjustmentLocalStorage;

public class DefaultLocalStorage
implements UIAdjustmentLocalStorage {
    private static DefaultLocalStorage instance;
    private Context context;

    public static DefaultLocalStorage getInstance(Context context) {
        if (instance == null) {
            instance = new DefaultLocalStorage(context);
        }
        return instance;
    }

    private DefaultLocalStorage(Context context) {
        this.context = context;
    }

    public void save(String key, Object object) {
        if (object instanceof Integer) {
            this.persistInt(this.context, key, (Integer)object, true);
        } else if (object instanceof String) {
            this.persistString(this.context, key, (String)object, true);
        } else if (object instanceof Float) {
            this.persistFloat(this.context, key, ((Float)object).floatValue(), true);
        } else if (object instanceof Boolean) {
            this.persistBoolean(this.context, key, (Boolean)object, true);
        } else {
            this.persistString(this.context, key, this.convertObjectToString(object), true);
        }
    }

    @Nullable
    public <T> Object load(String key, Class<T> clazz) {
        if (clazz == Integer.class) {
            return this.getPersistedInt(this.context, key, -1, true);
        }
        if (clazz == String.class) {
            return this.getPersistedString(this.context, key, null, true);
        }
        if (clazz == Float.class) {
            return Float.valueOf(this.getPersistedFloat(this.context, key, 0.0f, true));
        }
        if (clazz == Boolean.class) {
            return this.getPersistedBoolean(this.context, key, false, true);
        }
        return this.convertStringToObject(this.getPersistedString(this.context, key, null, true), clazz);
    }

    private String convertObjectToString(Object object) {
        return this.getDefaultGson().toJson(object);
    }

    private <T> T convertStringToObject(String json, Class<T> clazz) {
        if (json != null) {
            return (T)this.getDefaultGson().fromJson(json, clazz);
        }
        return null;
    }

    private Gson getDefaultGson() {
        return new Gson();
    }

    private boolean persistInt(Context context, String key, int value, boolean shouldPersist) {
        if (shouldPersist) {
            if (value == this.getPersistedInt(context, key, ~value, shouldPersist)) {
                return true;
            }
            SharedPreferences.Editor editor = this.getSharedPreferences(context).edit();
            editor.putInt(key, value);
            editor.apply();
            return true;
        }
        return false;
    }

    private int getPersistedInt(Context context, String key, int defaultValue, boolean shouldPersist) {
        if (!shouldPersist) {
            return defaultValue;
        }
        return this.getSharedPreferences(context).getInt(key, defaultValue);
    }

    private boolean persistString(Context context, String key, String value, boolean shouldPersist) {
        if (shouldPersist) {
            if (TextUtils.equals((CharSequence)value, (CharSequence)this.getPersistedString(context, key, null, shouldPersist))) {
                return true;
            }
            SharedPreferences.Editor editor = this.getSharedPreferences(context).edit();
            editor.putString(key, value);
            editor.apply();
            return true;
        }
        return false;
    }

    private String getPersistedString(Context context, String key, String defaultValue, boolean shouldPersist) {
        if (!shouldPersist) {
            return defaultValue;
        }
        return this.getSharedPreferences(context).getString(key, defaultValue);
    }

    private boolean persistFloat(Context context, String key, float value, boolean shouldPersist) {
        if (shouldPersist) {
            if (value == this.getPersistedFloat(context, key, Float.NaN, shouldPersist)) {
                return true;
            }
            SharedPreferences.Editor editor = this.getSharedPreferences(context).edit();
            editor.putFloat(key, value);
            editor.apply();
            return true;
        }
        return false;
    }

    private float getPersistedFloat(Context context, String key, float defaultReturnValue, boolean shouldPersist) {
        if (!shouldPersist) {
            return defaultReturnValue;
        }
        return this.getSharedPreferences(context).getFloat(key, defaultReturnValue);
    }

    private boolean persistBoolean(Context context, String key, boolean value, boolean shouldPersist) {
        if (shouldPersist) {
            if (value == this.getPersistedBoolean(context, key, !value, shouldPersist)) {
                return true;
            }
            SharedPreferences.Editor editor = this.getSharedPreferences(context).edit();
            editor.putBoolean(key, value);
            editor.apply();
            return true;
        }
        return false;
    }

    private boolean getPersistedBoolean(Context context, String key, boolean defaultValue, boolean shouldPersist) {
        if (!shouldPersist) {
            return defaultValue;
        }
        return this.getSharedPreferences(context).getBoolean(key, defaultValue);
    }

    private SharedPreferences getSharedPreferences(Context context) {
        return PreferenceManager.getDefaultSharedPreferences((Context)context);
    }
}

