/*
 * Decompiled with CFR 0.152.
 */
package com.thekhaeng.pushdownanim;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;

public class PushDownAnim {
    public static final float DEFAULT_PUSH_SCALE = 0.97f;
    public static final long DEFAULT_PUSH_DURATION = 50L;
    public static final long DEFAULT_RELEASE_DURATION = 125L;
    public static final AccelerateDecelerateInterpolator DEFAULT_INTERPOLATOR = new AccelerateDecelerateInterpolator();
    private final float defaultScale;
    private float scale = 0.97f;
    private long durationPush = 50L;
    private long durationRelease = 125L;
    private AccelerateDecelerateInterpolator interpolatorPush = DEFAULT_INTERPOLATOR;
    private AccelerateDecelerateInterpolator interpolatorRelease = DEFAULT_INTERPOLATOR;
    private View view;
    private AnimatorSet scaleAnimSet;

    private PushDownAnim(View view) {
        this.view = view;
        this.view.setClickable(true);
        this.defaultScale = view.getScaleX();
    }

    public static PushDownAnim setOnTouchPushDownAnim(View view, View.OnTouchListener eventListener) {
        PushDownAnim pushAnim = new PushDownAnim(view);
        pushAnim.setOnTouchEvent(eventListener);
        return pushAnim;
    }

    public static PushDownAnim setOnTouchPushDownAnim(View view) {
        PushDownAnim pushAnim = new PushDownAnim(view);
        pushAnim.setOnTouchEvent(null);
        return pushAnim;
    }

    public PushDownAnim setScale(float scale) {
        this.scale = scale;
        return this;
    }

    public PushDownAnim setDurationPush(long duration) {
        this.durationPush = duration;
        return this;
    }

    public PushDownAnim setDurationRelease(long duration) {
        this.durationRelease = duration;
        return this;
    }

    public PushDownAnim setInterpolatorPush(AccelerateDecelerateInterpolator interpolatorPush) {
        this.interpolatorPush = interpolatorPush;
        return this;
    }

    public PushDownAnim setInterpolatorRelease(AccelerateDecelerateInterpolator interpolatorRelease) {
        this.interpolatorRelease = interpolatorRelease;
        return this;
    }

    public PushDownAnim setOnClickListener(View.OnClickListener clickListener) {
        if (this.view != null) {
            this.view.setOnClickListener(clickListener);
        }
        return this;
    }

    private PushDownAnim setOnTouchEvent(final View.OnTouchListener eventListener) {
        if (this.view != null) {
            this.view.setOnTouchListener(new View.OnTouchListener(){
                boolean isOutSide;
                Rect rect;

                public boolean onTouch(View view, MotionEvent motionEvent) {
                    int i = motionEvent.getAction();
                    if (i == 0) {
                        this.isOutSide = false;
                        this.rect = new Rect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
                        PushDownAnim.this.animScale(view, PushDownAnim.this.scale, PushDownAnim.this.durationPush, (TimeInterpolator)PushDownAnim.this.interpolatorPush);
                    } else if (i == 2) {
                        if (this.rect != null && !this.isOutSide && !this.rect.contains(view.getLeft() + (int)motionEvent.getX(), view.getTop() + (int)motionEvent.getY())) {
                            this.isOutSide = true;
                            PushDownAnim.this.animScale(view, PushDownAnim.this.defaultScale, PushDownAnim.this.durationRelease, (TimeInterpolator)PushDownAnim.this.interpolatorRelease);
                        }
                    } else if (i == 3) {
                        PushDownAnim.this.animScale(view, PushDownAnim.this.defaultScale, PushDownAnim.this.durationRelease, (TimeInterpolator)PushDownAnim.this.interpolatorRelease);
                    } else if (i == 1) {
                        PushDownAnim.this.animScale(view, PushDownAnim.this.defaultScale, PushDownAnim.this.durationRelease, (TimeInterpolator)PushDownAnim.this.interpolatorRelease);
                    }
                    if (eventListener != null) {
                        return eventListener.onTouch(view, motionEvent);
                    }
                    return false;
                }
            });
        }
        return this;
    }

    private void animScale(final View view, float scale, long duration, TimeInterpolator interpolator) {
        view.animate().cancel();
        if (this.scaleAnimSet != null) {
            this.scaleAnimSet.cancel();
        }
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{scale});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{scale});
        scaleX.setInterpolator(interpolator);
        scaleX.setDuration(duration);
        scaleY.setInterpolator(interpolator);
        scaleY.setDuration(duration);
        this.scaleAnimSet = new AnimatorSet();
        this.scaleAnimSet.play((Animator)scaleX).with((Animator)scaleY);
        scaleX.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
            }
        });
        scaleX.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                View p = (View)view.getParent();
                p.invalidate();
            }
        });
        this.scaleAnimSet.start();
    }
}

