/*
 * Decompiled with CFR 0.152.
 */
package com.thejuki.kformmaster.widget.datepicker;

import android.content.Context;
import android.util.AttributeSet;
import com.aigestudio.wheelpicker.WheelPicker;
import com.thejuki.kformmaster.extensions.DateKt;
import com.thejuki.kformmaster.widget.datepicker.IKFWheelExtendedDatePicker;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.threeten.bp.LocalDate;
import org.threeten.bp.format.DateTimeFormatter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\b\u0007\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010#H\u0016J\b\u0010$\u001a\u00020!H\u0002J\b\u0010%\u001a\u00020!H\u0002R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00108V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR(\u0010\u001d\u001a\u0004\u0018\u00010\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u00108V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001c\u00a8\u0006&"}, d2={"Lcom/thejuki/kformmaster/widget/datepicker/KFWheelExtendedDatePicker;", "Lcom/aigestudio/wheelpicker/WheelPicker;", "Lcom/thejuki/kformmaster/widget/datepicker/IKFWheelExtendedDatePicker;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "dateTimeFormatter", "Lorg/threeten/bp/format/DateTimeFormatter;", "getDateTimeFormatter", "()Lorg/threeten/bp/format/DateTimeFormatter;", "setDateTimeFormatter", "(Lorg/threeten/bp/format/DateTimeFormatter;)V", "dates", "", "Lorg/threeten/bp/LocalDate;", "getDates", "()Ljava/util/List;", "setDates", "(Ljava/util/List;)V", "mSelectedDate", "mStartDate", "date", "selectedDate", "getSelectedDate", "()Lorg/threeten/bp/LocalDate;", "setSelectedDate", "(Lorg/threeten/bp/LocalDate;)V", "startDate", "getStartDate", "setStartDate", "setData", "", "data", "", "updateDates", "updateSelectedDate", "form_release"})
public final class KFWheelExtendedDatePicker
extends WheelPicker
implements IKFWheelExtendedDatePicker {
    @NotNull
    private LocalDate mSelectedDate;
    @Nullable
    private LocalDate mStartDate;
    @NotNull
    private DateTimeFormatter dateTimeFormatter;
    @NotNull
    private List<LocalDate> dates;

    @JvmOverloads
    public KFWheelExtendedDatePicker(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        LocalDate localDate = LocalDate.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"now()");
        this.mSelectedDate = localDate;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_DATE;
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ISO_DATE");
        this.dateTimeFormatter = dateTimeFormatter;
        this.dates = new ArrayList();
    }

    public /* synthetic */ KFWheelExtendedDatePicker(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    @NotNull
    public final DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public final void setDateTimeFormatter(@NotNull DateTimeFormatter dateTimeFormatter) {
        Intrinsics.checkNotNullParameter((Object)dateTimeFormatter, (String)"<set-?>");
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @NotNull
    public final List<LocalDate> getDates() {
        return this.dates;
    }

    public final void setDates(@NotNull List<LocalDate> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.dates = list;
    }

    private final void updateDates() {
        LocalDate localDate;
        if (this.getStartDate() != null) {
            LocalDate localDate2 = this.getStartDate();
            localDate = localDate2;
            Intrinsics.checkNotNull((Object)localDate2);
        } else {
            LocalDate localDate3 = LocalDate.now().minusYears(100L);
            localDate = localDate3;
            Intrinsics.checkNotNullExpressionValue((Object)localDate3, (String)"now().minusYears(100)");
        }
        LocalDate startDate = localDate;
        LocalDate endDate = LocalDate.now().plusYears(100L);
        List data = new ArrayList();
        this.dates.clear();
        Intrinsics.checkNotNullExpressionValue((Object)endDate, (String)"endDate");
        for (LocalDate date : DateKt.rangeTo(startDate, endDate).step(1L)) {
            String formattedDate = date.format(this.dateTimeFormatter);
            data.add(formattedDate);
            this.dates.add(date);
        }
        super.setData(data);
    }

    private final void updateSelectedDate() {
        this.setSelectedItemPosition(this.dates.indexOf(this.mSelectedDate));
    }

    public void setData(@Nullable List<?> data) {
        throw new UnsupportedOperationException("You can not invoke setData in KFWheelExtendedDatePicker");
    }

    @Override
    @NotNull
    public LocalDate getSelectedDate() {
        return this.mSelectedDate;
    }

    @Override
    public void setSelectedDate(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.mSelectedDate = date;
        this.updateSelectedDate();
    }

    @Override
    @Nullable
    public LocalDate getStartDate() {
        return this.mStartDate;
    }

    @Override
    public void setStartDate(@Nullable LocalDate date) {
        this.mStartDate = date;
        this.updateDates();
        this.updateSelectedDate();
    }

    @JvmOverloads
    public KFWheelExtendedDatePicker(@Nullable Context context) {
        this(context, null, 2, null);
    }
}

