/*
 * Decompiled with CFR 0.152.
 */
package com.thegrizzlylabs.sardineandroid.util;

import android.os.Build;
import com.thegrizzlylabs.sardineandroid.model.Prop;
import com.thegrizzlylabs.sardineandroid.model.Property;
import com.thegrizzlylabs.sardineandroid.model.Resourcetype;
import com.thegrizzlylabs.sardineandroid.util.EntityWithAnyElementConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.convert.Registry;
import org.simpleframework.xml.convert.RegistryStrategy;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.stream.Format;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class SardineUtil {
    private static final String[] SUPPORTED_DATE_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss'Z'", "EEE, dd MMM yyyy HH:mm:ss zzz", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ssZ", "EEE MMM dd HH:mm:ss zzz yyyy", "EEEEEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMMM d HH:mm:ss yyyy"};
    public static final String CUSTOM_NAMESPACE_PREFIX = "s";
    public static final String CUSTOM_NAMESPACE_URI = "SAR:";
    public static final String DEFAULT_NAMESPACE_PREFIX = "D";
    public static final String DEFAULT_NAMESPACE_URI = "DAV:";
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static final List<ThreadLocal<SimpleDateFormat>> DATETIME_FORMATS;

    private SardineUtil() {
    }

    public static Date parseDate(String value) {
        if (value == null) {
            return null;
        }
        Date date = null;
        for (int i = 0; i < DATETIME_FORMATS.size(); ++i) {
            ThreadLocal<SimpleDateFormat> format = DATETIME_FORMATS.get(i);
            SimpleDateFormat sdf = format.get();
            if (sdf == null) {
                sdf = new SimpleDateFormat(SUPPORTED_DATE_FORMATS[i], Locale.US);
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                format.set(sdf);
            }
            try {
                date = sdf.parse(value);
                break;
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return date;
    }

    private static Serializer getSerializer() throws Exception {
        Format format = new Format("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        Registry registry = new Registry();
        RegistryStrategy strategy = new RegistryStrategy(registry);
        Persister serializer = new Persister((Strategy)strategy, format);
        registry.bind(Prop.class, new EntityWithAnyElementConverter<Prop>((Serializer)serializer, Prop.class));
        registry.bind(Resourcetype.class, new EntityWithAnyElementConverter<Resourcetype>((Serializer)serializer, Resourcetype.class));
        registry.bind(Property.class, Property.PropertyConverter.class);
        return serializer;
    }

    public static <T> T unmarshal(Class<? extends T> type, InputStream in) throws IOException {
        try {
            return (T)SardineUtil.getSerializer().read(type, in);
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new IOException("Not a valid DAV response", e);
        }
    }

    public static String toXml(Object jaxbElement) {
        StringWriter writer = new StringWriter();
        try {
            SardineUtil.getSerializer().write(jaxbElement, (Writer)writer);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return writer.toString();
    }

    private static Document createDocument() {
        DocumentBuilder builder;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return builder.newDocument();
    }

    public static Map<QName, String> toQName(Map<String, String> setProps) {
        if (setProps == null) {
            return Collections.emptyMap();
        }
        HashMap<QName, String> result = new HashMap<QName, String>(setProps.size());
        for (Map.Entry<String, String> entry : setProps.entrySet()) {
            result.put(SardineUtil.createQNameWithCustomNamespace(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public static List<QName> toQName(List<String> removeProps) {
        if (removeProps == null) {
            return Collections.emptyList();
        }
        ArrayList<QName> result = new ArrayList<QName>(removeProps.size());
        for (String entry : removeProps) {
            result.add(SardineUtil.createQNameWithCustomNamespace(entry));
        }
        return result;
    }

    public static QName toQName(Element element) {
        String namespace = element.getNamespaceURI();
        if (namespace == null) {
            return new QName(DEFAULT_NAMESPACE_URI, element.getLocalName(), DEFAULT_NAMESPACE_PREFIX);
        }
        if (element.getPrefix() == null) {
            return new QName(element.getNamespaceURI(), element.getLocalName());
        }
        return new QName(element.getNamespaceURI(), element.getLocalName(), element.getPrefix());
    }

    public static QName createQNameWithCustomNamespace(String key) {
        return new QName(CUSTOM_NAMESPACE_URI, key, CUSTOM_NAMESPACE_PREFIX);
    }

    public static QName createQNameWithDefaultNamespace(String key) {
        return new QName(DEFAULT_NAMESPACE_URI, key, DEFAULT_NAMESPACE_PREFIX);
    }

    public static Element createElement(QName key) {
        return SardineUtil.createDocument().createElementNS(key.getNamespaceURI(), key.getPrefix() + ":" + key.getLocalPart());
    }

    public static Element createElement(Element parent, QName key) {
        return parent.getOwnerDocument().createElementNS(key.getNamespaceURI(), key.getPrefix() + ":" + key.getLocalPart());
    }

    public static Charset standardUTF8() {
        if (Build.VERSION.SDK_INT >= 19) {
            return StandardCharsets.UTF_8;
        }
        return Charset.forName("UTF-8");
    }

    static {
        ArrayList l = new ArrayList(SUPPORTED_DATE_FORMATS.length);
        for (int i = 0; i < SUPPORTED_DATE_FORMATS.length; ++i) {
            l.add(new ThreadLocal());
        }
        DATETIME_FORMATS = Collections.unmodifiableList(l);
    }
}

