/*
 * Decompiled with CFR 0.152.
 */
package com.thegrizzlylabs.sardineandroid.util;

import com.thegrizzlylabs.sardineandroid.model.EntityWithAnyElement;
import com.thegrizzlylabs.sardineandroid.util.ElementConverter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.convert.Converter;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.w3c.dom.Element;

public class EntityWithAnyElementConverter<T extends EntityWithAnyElement>
implements Converter<T> {
    private Class<T> entityClass;
    private Serializer serializer;

    public EntityWithAnyElementConverter(Serializer serializer, Class<T> entityClass) {
        this.serializer = serializer;
        this.entityClass = entityClass;
    }

    private Map<String, Field> getEntityFields() {
        HashMap<String, Field> elementsFields = new HashMap<String, Field>();
        for (Field field : this.entityClass.getDeclaredFields()) {
            org.simpleframework.xml.Element fieldAnnotation = field.getAnnotation(org.simpleframework.xml.Element.class);
            if (fieldAnnotation == null) continue;
            String name = fieldAnnotation.name().equals("") ? field.getName() : fieldAnnotation.name();
            elementsFields.put(name, field);
        }
        return elementsFields;
    }

    private Method getSetterForField(Field field) throws NoSuchMethodException {
        String fieldName = field.getName();
        String capitalizedFieldName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        return this.entityClass.getMethod("set" + capitalizedFieldName, field.getType());
    }

    private Method getGetterForField(Field field) throws NoSuchMethodException {
        String fieldName = field.getName();
        String capitalizedFieldName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        return this.entityClass.getMethod("get" + capitalizedFieldName, new Class[0]);
    }

    public T read(InputNode node) throws Exception {
        InputNode childNode;
        Map<String, Field> entityFields = this.getEntityFields();
        EntityWithAnyElement entity = (EntityWithAnyElement)this.entityClass.newInstance();
        List<Element> anyElements = entity.getAny();
        while ((childNode = node.getNext()) != null) {
            if (entityFields.containsKey(childNode.getName())) {
                Field field = entityFields.get(childNode.getName());
                this.getSetterForField(field).invoke((Object)entity, this.serializer.read(field.getType(), childNode));
                continue;
            }
            if (childNode.getPrefix() != null && !childNode.getPrefix().isEmpty()) {
                Element element = ElementConverter.read(childNode);
                anyElements.add(element);
                continue;
            }
            this.skipChildrenOfNode(childNode);
        }
        return (T)entity;
    }

    private void skipChildrenOfNode(InputNode node) throws Exception {
        while (node.getNext() != null) {
        }
    }

    public void write(OutputNode node, T entity) throws Exception {
        for (Element domElement : entity.getAny()) {
            ElementConverter.write(node, domElement);
        }
        Map<String, Field> entityFields = this.getEntityFields();
        for (String fieldName : entityFields.keySet()) {
            Field field = entityFields.get(fieldName);
            Object value = this.getGetterForField(field).invoke(entity, new Object[0]);
            if (value == null) continue;
            if (value instanceof String) {
                OutputNode childNode = node.getChild(fieldName);
                childNode.setReference("DAV:");
                childNode.setValue((String)value);
                continue;
            }
            this.serializer.write(value, node);
        }
    }
}

