/*
 * Decompiled with CFR 0.152.
 */
package com.thegrizzlylabs.sardineandroid;

import com.thegrizzlylabs.sardineandroid.DavAce;
import com.thegrizzlylabs.sardineandroid.model.Ace;
import com.thegrizzlylabs.sardineandroid.model.Acl;
import com.thegrizzlylabs.sardineandroid.model.Group;
import com.thegrizzlylabs.sardineandroid.model.Owner;
import com.thegrizzlylabs.sardineandroid.model.Propstat;
import com.thegrizzlylabs.sardineandroid.model.Response;
import java.util.ArrayList;
import java.util.List;

public class DavAcl {
    private final String owner;
    private final String group;
    private List<DavAce> aces;

    public DavAcl(Response response) {
        this.owner = this.getOwner(response);
        this.group = this.getGroup(response);
        this.aces = this.getAces(response);
    }

    public String getGroup() {
        return this.group;
    }

    public String getOwner() {
        return this.owner;
    }

    public List<DavAce> getAces() {
        return this.aces;
    }

    private String getOwner(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        for (Propstat propstat : list) {
            Owner o = propstat.getProp().getOwner();
            if (o == null) continue;
            if (o.getUnauthenticated() != null) {
                return "unauthenticated";
            }
            if (o.getHref() == null) continue;
            return o.getHref();
        }
        return null;
    }

    private String getGroup(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        for (Propstat propstat : list) {
            Group o = propstat.getProp().getGroup();
            if (o == null || o.getHref() == null) continue;
            return o.getHref();
        }
        return null;
    }

    private List<DavAce> getAces(Response response) {
        ArrayList<DavAce> result = new ArrayList<DavAce>();
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        for (Propstat propstat : list) {
            Acl a = propstat.getProp().getAcl();
            if (a == null || a.getAce() == null) continue;
            for (Ace ace : a.getAce()) {
                result.add(new DavAce(ace));
            }
        }
        return result;
    }
}

