/*
 * Decompiled with CFR 0.152.
 */
package at.pollux.thymeleaf.shiro.processor.attribute;

import at.pollux.thymeleaf.shiro.dialect.ShiroFacade;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.attr.AbstractConditionalVisibilityAttrProcessor;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public class HasAnyRolesAttrProcessor
extends AbstractConditionalVisibilityAttrProcessor {
    private static final String ROLES_DELIMITER = ",";
    private static final String ATTRIBUTE_NAME = "hasAnyRoles";
    private static final int PRECEDENCE = 300;

    public static HasAnyRolesAttrProcessor create() {
        return new HasAnyRolesAttrProcessor();
    }

    protected HasAnyRolesAttrProcessor() {
        super(ATTRIBUTE_NAME);
    }

    public int getPrecedence() {
        return 300;
    }

    protected boolean isVisible(Arguments arguments, Element element, String attributeName) {
        Validate.notNull((Object)element, (String)"element must not be null");
        Validate.notEmpty((String)attributeName, (String)"attributeName must not be empty");
        String rawRoles = StringUtils.trim((Object)element.getAttributeValue(attributeName));
        Validate.notEmpty((String)rawRoles, (String)("value of '" + attributeName + "' must not be empty"));
        return ShiroFacade.hasAnyRoles(StringUtils.split((Object)rawRoles, (String)ROLES_DELIMITER));
    }
}

