/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;

public class TimeUtils {
    public static boolean timeHasElapsedSince(Instant then, Callable<Duration> threshold) {
        if (threshold == null) {
            return false;
        }
        Duration result = null;
        try {
            result = threshold.call();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (result == null) {
            return false;
        }
        return Duration.between(then, Instant.now()).getSeconds() > result.getSeconds();
    }

    public static boolean isSecondsSince(Date date, long seconds) {
        return CompletableFuture.supplyAsync(() -> TimeUtils.timeHasElapsedSince(date.toInstant(), () -> Duration.ofSeconds(seconds))).join();
    }

    public static boolean isMinutesSince(Date date, long minutes) {
        return CompletableFuture.supplyAsync(() -> TimeUtils.timeHasElapsedSince(date.toInstant(), () -> Duration.ofMinutes(minutes))).join();
    }

    public static boolean isHoursSince(Date date, long hours) {
        return CompletableFuture.supplyAsync(() -> TimeUtils.timeHasElapsedSince(date.toInstant(), () -> Duration.ofHours(hours))).join();
    }

    public static boolean isDaysSince(Date date, long days) {
        return CompletableFuture.supplyAsync(() -> TimeUtils.timeHasElapsedSince(date.toInstant(), () -> Duration.ofDays(days))).join();
    }
}

