/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import com.github.sanctum.labyrinth.data.Config;
import com.github.sanctum.labyrinth.library.HFEncoded;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public abstract class Cooldown
implements Serializable {
    public abstract String getId();

    public abstract long getCooldown();

    protected long getTimePassed() {
        return (System.currentTimeMillis() - this.getCooldown()) / 1000L;
    }

    protected int getTimeLeft() {
        return Integer.parseInt(String.valueOf(this.getTimePassed()).replace("-", ""));
    }

    public int getDaysLeft() {
        return (int)TimeUnit.SECONDS.toDays(this.getTimeLeft());
    }

    public long getHoursLeft() {
        return TimeUnit.SECONDS.toHours(this.getTimeLeft()) - (long)(this.getDaysLeft() * 24);
    }

    public long getMinutesLeft() {
        return TimeUnit.SECONDS.toMinutes(this.getTimeLeft()) - TimeUnit.SECONDS.toHours(this.getTimeLeft()) * 60L;
    }

    public long getSecondsLeft() {
        return TimeUnit.SECONDS.toSeconds(this.getTimeLeft()) - TimeUnit.SECONDS.toMinutes(this.getTimeLeft()) * 60L;
    }

    public boolean isComplete() {
        Config cooldowns = Config.get("Storage", "Cooldowns");
        Long a = cooldowns.getConfig().getLong(this.getId() + ".expiration");
        Long b = System.currentTimeMillis();
        int compareNum = a.compareTo(b);
        if (!cooldowns.getConfig().isLong(this.getId() + ".expiration")) {
            return true;
        }
        return compareNum <= 0;
    }

    public String fullTimeLeft() {
        return "(S)" + this.getSecondsLeft() + " : (M)" + this.getMinutesLeft() + " : (H)" + this.getHoursLeft() + " : (D)" + this.getDaysLeft();
    }

    public void save() {
        Config cooldowns = Config.get("Storage", "Cooldowns");
        cooldowns.getConfig().set(this.getId() + ".expiration", (Object)this.getCooldown());
        try {
            cooldowns.getConfig().set(this.getId() + ".instance", (Object)new HFEncoded(this).serialize());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        cooldowns.saveConfig();
    }

    protected long abv(int seconds) {
        return System.currentTimeMillis() + (long)(seconds * 1000);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cooldown)) {
            return false;
        }
        Cooldown cooldown = (Cooldown)o;
        return Objects.equals(this.getId(), cooldown.getId()) && Objects.equals(this.getCooldown(), cooldown.getCooldown());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getCooldown());
    }

    public static Cooldown getById(String id) {
        Config cooldowns = Config.get("Storage", "Cooldowns");
        Cooldown result = null;
        try {
            result = (Cooldown)new HFEncoded(cooldowns.getConfig().getString(id + ".instance")).deserialized();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void remove(Cooldown c) {
        Config cooldowns = Config.get("Storage", "Cooldowns");
        cooldowns.getConfig().set(c.getId(), null);
        cooldowns.saveConfig();
    }
}

