/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.gui.builder;

import com.github.sanctum.labyrinth.gui.builder.InventoryClick;
import com.github.sanctum.labyrinth.gui.builder.PaginatedBuilder;
import java.util.function.Supplier;
import org.bukkit.inventory.ItemStack;

public class SpareElement {
    private final PaginatedBuilder builder;

    protected SpareElement(PaginatedBuilder paginatedBuilder) {
        this.builder = paginatedBuilder;
    }

    public SpareElement invoke(ItemStack item, InventoryClick inventoryClick) {
        this.builder.actions.putIfAbsent(item, inventoryClick);
        this.builder.contents.add(item);
        this.builder.additional.putIfAbsent(item, -1);
        return this;
    }

    public SpareElement invoke(ItemStack item, int slot, InventoryClick inventoryClick) {
        this.builder.actions.putIfAbsent(item, inventoryClick);
        this.builder.contents.add(item);
        this.builder.additional.putIfAbsent(item, slot);
        return this;
    }

    public SpareElement invoke(Supplier<ItemStack> supplier, InventoryClick inventoryClick) {
        ItemStack item = supplier.get();
        this.builder.actions.putIfAbsent(item, inventoryClick);
        this.builder.contents.add(item);
        this.builder.additional.putIfAbsent(item, -1);
        return this;
    }

    public SpareElement invoke(Supplier<ItemStack> supplier, int slot, InventoryClick inventoryClick) {
        ItemStack item = supplier.get();
        this.builder.actions.putIfAbsent(item, inventoryClick);
        this.builder.contents.add(item);
        this.builder.additional.putIfAbsent(item, slot);
        return this;
    }

    public PaginatedBuilder add() {
        return this.builder;
    }
}

