/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.formatting.string;

import com.github.sanctum.labyrinth.Labyrinth;
import com.github.sanctum.labyrinth.formatting.SortedDoubleMap;
import com.github.sanctum.labyrinth.formatting.SortedLongMap;
import com.github.sanctum.labyrinth.formatting.component.Text;
import com.github.sanctum.labyrinth.formatting.component.Text_R2;
import com.github.sanctum.labyrinth.formatting.string.ColoredString;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PaginatedAssortment {
    private Collection<String> targetList;
    private Map<String, Long> targetMap;
    private Map<String, Double> targetMapDouble;
    private MapType type;
    private int linesPerPage;
    private String navigateCommand;
    private Player p;
    private String listTitle = "&o-- [Specify the returned list's title here] --";
    private String listBorder = "&7&o&m\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac";
    private String normalText = "";
    private String hoverText = "#%placement %holder : %amount";
    private String hoverTextMessage = "%holder places %placement on page %page";
    private String commandToRun = "command <#index>";

    protected double format(String amount) {
        BigDecimal b1 = new BigDecimal(amount);
        MathContext m = new MathContext(3);
        BigDecimal b2 = b1.round(m);
        return b2.doubleValue();
    }

    public PaginatedAssortment(Player p, Collection<String> targetList) {
        this.targetList = targetList;
        this.p = p;
    }

    public PaginatedAssortment(Player p, Map<String, Long> targetMap, Map<String, Double> targetMap2) {
        this.p = p;
        this.targetMap = targetMap;
        if (targetMap2 != null) {
            this.targetMapDouble = targetMap2;
        }
    }

    public PaginatedAssortment setLinesPerPage(int linesPerPage) {
        this.linesPerPage = linesPerPage;
        return this;
    }

    public PaginatedAssortment setNavigateCommand(String navigateCommand) {
        this.navigateCommand = navigateCommand;
        return this;
    }

    public PaginatedAssortment setNormalText(String normalText) {
        this.normalText = normalText;
        return this;
    }

    public PaginatedAssortment setHoverText(String hoverText) {
        this.hoverText = hoverText;
        return this;
    }

    public PaginatedAssortment setHoverTextMessage(String hoverTextMessage) {
        this.hoverTextMessage = hoverTextMessage;
        return this;
    }

    public PaginatedAssortment setListBorder(String listBorder) {
        this.listBorder = listBorder;
        return this;
    }

    public PaginatedAssortment setListTitle(String listTitle) {
        this.listTitle = listTitle;
        return this;
    }

    public PaginatedAssortment setCommandToRun(String commandToRun) {
        this.commandToRun = commandToRun;
        return this;
    }

    public void export(int page) {
        this.p.sendMessage(new ColoredString(this.listTitle, ColoredString.ColorType.MC).toString());
        int totalPageCount = 1;
        if (this.targetList.size() % this.linesPerPage == 0) {
            if (this.targetList.size() > 0) {
                totalPageCount = this.targetList.size() / this.linesPerPage;
            }
        } else {
            totalPageCount = this.targetList.size() / this.linesPerPage + 1;
        }
        if (page <= totalPageCount) {
            if (this.targetList.isEmpty()) {
                this.p.sendMessage(new ColoredString("&fThe list is empty!", ColoredString.ColorType.MC).toString());
            } else {
                int i = 0;
                int k = 0;
                --page;
                for (String entry : this.targetList) {
                    if (page * this.linesPerPage + i + 1 != ++k || k == page * this.linesPerPage + this.linesPerPage + 1) continue;
                    ++i;
                    if (Bukkit.getVersion().contains("1.16")) {
                        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                            this.p.sendMessage(new ColoredString(PlaceholderAPI.setPlaceholders((Player)this.p, (String)entry), ColoredString.ColorType.HEX).toString());
                            continue;
                        }
                        this.p.sendMessage(new ColoredString(entry, ColoredString.ColorType.HEX).toString());
                        continue;
                    }
                    if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                        this.p.sendMessage(new ColoredString(PlaceholderAPI.setPlaceholders((Player)this.p, (String)entry), ColoredString.ColorType.MC).toString());
                        continue;
                    }
                    this.p.sendMessage(new ColoredString(entry, ColoredString.ColorType.MC).toString());
                }
                int point = page + 1;
                if (page >= 1) {
                    int last = point - 1;
                    ++point;
                    this.p.sendMessage(new ColoredString(this.listBorder, ColoredString.ColorType.MC).toString());
                    if (page < totalPageCount - 1) {
                        if (Bukkit.getVersion().contains("1.16") || Bukkit.getVersion().contains("1.17")) {
                            this.p.spigot().sendMessage((BaseComponent)new Text().textRunnable("&7Navigate &b&o&m--&b> &7[", "&c&oBACK&7]", "&7 : [", "&b&oNEXT&7]", "&b&oClick to go &d&oback a page", "&b&oClick to goto the &5&onext page", this.navigateCommand + " " + last, this.navigateCommand + " " + point));
                        } else {
                            this.p.spigot().sendMessage((BaseComponent)Text_R2.textRunnable("&7Navigate &b&o&m--&b> &7[", "&c&oBACK&7]", "&7 : [", "&b&oNEXT&7]", "&b&oClick to go &d&oback a page", "&b&oClick to goto the &5&onext page", this.navigateCommand + " " + last, this.navigateCommand + " " + point));
                        }
                    }
                    if (page == totalPageCount - 1) {
                        if (Bukkit.getVersion().contains("1.16") || Bukkit.getVersion().contains("1.17")) {
                            this.p.spigot().sendMessage((BaseComponent)new Text().textRunnable("&7Navigate &b&o&m--&b> &7[", "&c&oBACK", "&7]", "&b&oClick to go &d&oback a page", this.navigateCommand + " " + last));
                        } else {
                            this.p.spigot().sendMessage((BaseComponent)Text_R2.textRunnable("&7Navigate &b&o&m--&b> &7[", "&c&oBACK", "&7]", "&b&oClick to go &d&oback a page", this.navigateCommand + " " + last));
                        }
                    }
                }
                if (page == 0) {
                    point = page + 1 + 1;
                    this.p.sendMessage(new ColoredString(this.listBorder, ColoredString.ColorType.MC).toString());
                    if (Bukkit.getVersion().contains("1.16") || Bukkit.getVersion().contains("1.17")) {
                        this.p.spigot().sendMessage((BaseComponent)new Text().textRunnable("&7Navigate &b&o&m--&b> &7[", "&b&oNEXT", "&7]", "&b&oClick to goto the &5&onext page", this.navigateCommand + " " + point));
                    } else {
                        this.p.spigot().sendMessage((BaseComponent)Text_R2.textRunnable("&7Navigate &b&o&m--&b> &7[", "&b&oNEXT", "&7]", "&b&oClick to goto the &5&onext page", this.navigateCommand + " " + point));
                    }
                }
            }
        } else {
            this.p.sendMessage(new ColoredString("&eThere are only &f" + totalPageCount + " &epages!", ColoredString.ColorType.MC).toString());
        }
    }

    public void exportFancy(int page) {
        this.p.sendMessage(new ColoredString(this.listTitle, ColoredString.ColorType.MC).toString());
        int totalPageCount = 1;
        if (this.targetList.size() % this.linesPerPage == 0) {
            if (this.targetList.size() > 0) {
                totalPageCount = this.targetList.size() / this.linesPerPage;
            }
        } else {
            totalPageCount = this.targetList.size() / this.linesPerPage + 1;
        }
        if (page <= totalPageCount) {
            if (this.targetList.isEmpty()) {
                this.p.sendMessage(new ColoredString("&fThe list is empty!", ColoredString.ColorType.MC).toString());
            } else {
                int i = 0;
                int k = 0;
                --page;
                for (String entry : this.targetList) {
                    if (page * this.linesPerPage + i + 1 != ++k || k == page * this.linesPerPage + this.linesPerPage + 1) continue;
                    ++i;
                    if (Bukkit.getServer().getVersion().contains("1.16")) {
                        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                            this.p.spigot().sendMessage((BaseComponent)new Text().textRunnable(String.format(this.normalText, PlaceholderAPI.setBracketPlaceholders((Player)this.p, (String)entry)), String.format(this.hoverText, PlaceholderAPI.setBracketPlaceholders((Player)this.p, (String)entry)), String.format(this.hoverTextMessage, PlaceholderAPI.setBracketPlaceholders((Player)this.p, (String)entry)), String.format(this.commandToRun, PlaceholderAPI.setBracketPlaceholders((Player)this.p, (String)entry))));
                            continue;
                        }
                        this.p.spigot().sendMessage((BaseComponent)new Text().textRunnable(String.format(this.normalText, entry), String.format(this.hoverText, entry), String.format(this.hoverTextMessage, entry), String.format(this.commandToRun, entry)));
                        continue;
                    }
                    if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                        this.p.spigot().sendMessage((BaseComponent)Text_R2.textRunnable(String.format(this.normalText, PlaceholderAPI.setBracketPlaceholders((Player)this.p, (String)entry)), String.format(this.hoverText, PlaceholderAPI.setBracketPlaceholders((Player)this.p, (String)entry)), String.format(this.hoverTextMessage, PlaceholderAPI.setBracketPlaceholders((Player)this.p, (String)entry)), String.format(this.commandToRun, PlaceholderAPI.setBracketPlaceholders((Player)this.p, (String)entry))));
                        continue;
                    }
                    this.p.spigot().sendMessage((BaseComponent)Text_R2.textRunnable(String.format(this.normalText, entry), String.format(this.hoverText, entry), String.format(this.hoverTextMessage, entry), String.format(this.commandToRun, entry)));
                }
                int point = page + 1;
                if (page >= 1) {
                    int last = point - 1;
                    ++point;
                    this.p.sendMessage(new ColoredString(this.listBorder, ColoredString.ColorType.MC).toString());
                    if (page < totalPageCount - 1) {
                        if (Bukkit.getVersion().contains("1.16") || Bukkit.getVersion().contains("1.17")) {
                            this.p.spigot().sendMessage((BaseComponent)new Text().textRunnable("&7Navigate &b&o&m--&b> &7[", "&c&oBACK&7]", "&7 : [", "&b&oNEXT&7]", "&b&oClick to go &d&oback a page", "&b&oClick to goto the &5&onext page", this.navigateCommand + " " + last, this.navigateCommand + " " + point));
                        } else {
                            this.p.spigot().sendMessage((BaseComponent)Text_R2.textRunnable("&7Navigate &b&o&m--&b> &7[", "&c&oBACK&7]", "&7 : [", "&b&oNEXT&7]", "&b&oClick to go &d&oback a page", "&b&oClick to goto the &5&onext page", this.navigateCommand + " " + last, this.navigateCommand + " " + point));
                        }
                    }
                    if (page == totalPageCount - 1) {
                        if (Bukkit.getVersion().contains("1.16") || Bukkit.getVersion().contains("1.17")) {
                            this.p.spigot().sendMessage((BaseComponent)new Text().textRunnable("&7Navigate &b&o&m--&b> &7[", "&c&oBACK", "&7]", "&b&oClick to go &d&oback a page", this.navigateCommand + " " + last));
                        } else {
                            this.p.spigot().sendMessage((BaseComponent)Text_R2.textRunnable("&7Navigate &b&o&m--&b> &7[", "&c&oBACK", "&7]", "&b&oClick to go &d&oback a page", this.navigateCommand + " " + last));
                        }
                    }
                }
                if (page == 0) {
                    point = page + 1 + 1;
                    this.p.sendMessage(new ColoredString(this.listBorder, ColoredString.ColorType.MC).toString());
                    if (Bukkit.getVersion().contains("1.16") || Bukkit.getVersion().contains("1.17")) {
                        this.p.spigot().sendMessage((BaseComponent)new Text().textRunnable("&7Navigate &b&o&m--&b> &7[", "&b&oNEXT", "&7]", "&b&oClick to goto the &5&onext page", this.navigateCommand + " " + point));
                    } else {
                        this.p.spigot().sendMessage((BaseComponent)Text_R2.textRunnable("&7Navigate &b&o&m--&b> &7[", "&b&oNEXT", "&7]", "&b&oClick to goto the &5&onext page", this.navigateCommand + " " + point));
                    }
                }
            }
        } else {
            this.p.sendMessage(new ColoredString("&eThere are only &f" + totalPageCount + " &epages!", ColoredString.ColorType.MC).toString());
        }
    }

    public void exportSorted(MapType type, int pageNum) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Labyrinth.getInstance(), () -> {
            int page = pageNum;
            int o = this.linesPerPage;
            if (type.equals((Object)MapType.DOUBLE)) {
                HashMap<String, Double> tempMap = new HashMap<String, Double>(this.targetMapDouble);
                this.p.sendMessage(new ColoredString(this.listTitle, ColoredString.ColorType.MC).toString());
                int totalPageCount = 1;
                if (tempMap.size() % o == 0) {
                    if (tempMap.size() > 0) {
                        totalPageCount = tempMap.size() / o;
                    }
                } else {
                    totalPageCount = tempMap.size() / o + 1;
                }
                String nextTop = "";
                double nextTopAmount = 0.0;
                if (page <= totalPageCount) {
                    if (tempMap.isEmpty()) {
                        this.p.sendMessage(ChatColor.WHITE + "The list is empty!");
                    } else {
                        int i1 = 0;
                        int k = 0;
                        --page;
                        SortedDoubleMap comp = new SortedDoubleMap(tempMap);
                        TreeMap<String, Double> sorted_map = new TreeMap<String, Double>(comp);
                        sorted_map.putAll(tempMap);
                        for (Map.Entry map : sorted_map.entrySet()) {
                            int pageExact = page + 1;
                            if ((Double)map.getValue() > nextTopAmount) {
                                nextTop = map.getKey();
                                nextTopAmount = (Double)map.getValue();
                            }
                            if (page * o + i1 + 1 == ++k && k != page * o + o + 1) {
                                ++i1;
                                if (Bukkit.getServer().getVersion().contains("1.16")) {
                                    this.p.spigot().sendMessage((BaseComponent)new Text().textRunnable(String.format(this.normalText, k, nextTop, this.format(String.valueOf(nextTopAmount))), String.format(this.hoverText, k, nextTop, this.format(String.valueOf(nextTopAmount))), String.format(this.hoverTextMessage, nextTop, k, pageExact), String.format(this.commandToRun, nextTop)));
                                } else {
                                    this.p.spigot().sendMessage((BaseComponent)Text_R2.textRunnable(String.format(this.normalText, k, nextTop, this.format(String.valueOf(nextTopAmount))), String.format(this.hoverText, k, nextTop, this.format(String.valueOf(nextTopAmount))), String.format(this.hoverTextMessage, nextTop, k, pageExact), String.format(this.commandToRun, nextTop)));
                                }
                            }
                            tempMap.remove(nextTop);
                            nextTop = "";
                            nextTopAmount = 0.0;
                        }
                        int point = page + 1;
                        if (page >= 1) {
                            this.p.sendMessage(new ColoredString(this.listBorder, ColoredString.ColorType.MC).toString());
                            int last = point - 1;
                            ++point;
                            if (Bukkit.getServer().getVersion().contains("1.16")) {
                                this.p.spigot().sendMessage((BaseComponent)new Text().textRunnable("&b&oNavigate &7[", "&3&lCLICK", "&7] : &7[", "&c&lCLICK&7]", "&b&oClick this to goto the &5&onext page.", "&b&oClick this to go &d&oback a page.", this.navigateCommand + " " + point, this.navigateCommand + " " + last));
                            } else {
                                this.p.spigot().sendMessage((BaseComponent)Text_R2.textRunnable("&b&oNavigate &7[", "&3&lCLICK", "&7] : &7[", "&c&lCLICK&7]", "&b&oClick this to goto the &5&onext page.", "&b&oClick this to go &d&oback a page.", this.navigateCommand + " " + point, this.navigateCommand + " " + last));
                            }
                        }
                        if (page == 0) {
                            point = page + 2;
                            this.p.sendMessage(new ColoredString(this.listBorder, ColoredString.ColorType.MC).toString());
                            if (Bukkit.getServer().getVersion().contains("1.16")) {
                                this.p.spigot().sendMessage((BaseComponent)new Text().textRunnable("&b&oNavigate &7[", "&3&lCLICK", "&7]", "&b&oClick this to goto the &5&onext page.", this.navigateCommand + " " + point));
                            } else {
                                this.p.spigot().sendMessage((BaseComponent)Text_R2.textRunnable("&b&oNavigate &7[", "&3&lCLICK", "&7]", "&b&oClick this to goto the &5&onext page.", this.navigateCommand + " " + point));
                            }
                        }
                    }
                } else {
                    this.p.sendMessage(ChatColor.DARK_AQUA + "There are only " + ChatColor.GRAY + totalPageCount + ChatColor.DARK_AQUA + " pages!");
                }
            } else if (type.equals((Object)MapType.LONG)) {
                HashMap<String, Long> tempMap = new HashMap<String, Long>(this.targetMap);
                this.p.sendMessage(new ColoredString(this.listTitle, ColoredString.ColorType.MC).toString());
                int totalPageCount = 1;
                if (tempMap.size() % o == 0) {
                    if (tempMap.size() > 0) {
                        totalPageCount = tempMap.size() / o;
                    }
                } else {
                    totalPageCount = tempMap.size() / o + 1;
                }
                String nextTop = "";
                Long nextTopAmount = 0L;
                if (page <= totalPageCount) {
                    if (tempMap.isEmpty()) {
                        this.p.sendMessage(ChatColor.WHITE + "The list is empty!");
                    } else {
                        int i1 = 0;
                        int k = 0;
                        --page;
                        SortedLongMap comp = new SortedLongMap(tempMap);
                        TreeMap<String, Long> sorted_map = new TreeMap<String, Long>(comp);
                        sorted_map.putAll(tempMap);
                        for (Map.Entry map : sorted_map.entrySet()) {
                            int pageExact = page + 1;
                            if ((Long)map.getValue() > nextTopAmount) {
                                nextTop = map.getKey();
                                nextTopAmount = (Long)map.getValue();
                            }
                            if (page * o + i1 + 1 == ++k && k != page * o + o + 1) {
                                ++i1;
                                if (Bukkit.getServer().getVersion().contains("1.16")) {
                                    this.p.spigot().sendMessage((BaseComponent)new Text().textRunnable(String.format(this.normalText, k, nextTop, this.format(String.valueOf(nextTopAmount))), String.format(this.hoverText, k, nextTop, this.format(String.valueOf(nextTopAmount))), String.format(this.hoverTextMessage, nextTop, k, pageExact), String.format(this.commandToRun, nextTop)));
                                } else {
                                    this.p.spigot().sendMessage((BaseComponent)Text_R2.textRunnable(String.format(this.normalText, k, nextTop, this.format(String.valueOf(nextTopAmount))), String.format(this.hoverText, k, nextTop, this.format(String.valueOf(nextTopAmount))), String.format(this.hoverTextMessage, nextTop, k, pageExact), String.format(this.commandToRun, nextTop)));
                                }
                            }
                            tempMap.remove(nextTop);
                            nextTop = "";
                            nextTopAmount = 0L;
                        }
                        int point = page + 1;
                        if (page >= 1) {
                            this.p.sendMessage(new ColoredString(this.listBorder, ColoredString.ColorType.MC).toString());
                            int last = point - 1;
                            ++point;
                            if (Bukkit.getServer().getVersion().contains("1.16")) {
                                this.p.spigot().sendMessage((BaseComponent)new Text().textRunnable("&b&oNavigate &7[", "&3&lCLICK", "&7] : &7[", "&c&lCLICK&7]", "&b&oClick this to goto the &5&onext page.", "&b&oClick this to go &d&oback a page.", this.navigateCommand + " " + point, this.navigateCommand + " " + last));
                            } else {
                                this.p.spigot().sendMessage((BaseComponent)Text_R2.textRunnable("&b&oNavigate &7[", "&3&lCLICK", "&7] : &7[", "&c&lCLICK&7]", "&b&oClick this to goto the &5&onext page.", "&b&oClick this to go &d&oback a page.", this.navigateCommand + " " + point, this.navigateCommand + " " + last));
                            }
                        }
                        if (page == 0) {
                            point = page + 2;
                            this.p.sendMessage(new ColoredString(this.listBorder, ColoredString.ColorType.MC).toString());
                            if (Bukkit.getServer().getVersion().contains("1.16")) {
                                this.p.spigot().sendMessage((BaseComponent)new Text().textRunnable("&b&oNavigate &7[", "&3&lCLICK", "&7]", "&b&oClick this to goto the &5&onext page.", this.navigateCommand + " " + point));
                            } else {
                                this.p.spigot().sendMessage((BaseComponent)Text_R2.textRunnable("&b&oNavigate &7[", "&3&lCLICK", "&7]", "&b&oClick this to goto the &5&onext page.", this.navigateCommand + " " + point));
                            }
                        }
                    }
                } else {
                    this.p.sendMessage(ChatColor.DARK_AQUA + "There are only " + ChatColor.GRAY + totalPageCount + ChatColor.DARK_AQUA + " pages!");
                }
            }
        }, 2L);
    }

    public TreeMap<String, Long> longMapSorted() {
        HashMap<String, Long> tempMap = new HashMap<String, Long>(this.targetMap);
        SortedLongMap comp = new SortedLongMap(tempMap);
        return new TreeMap<String, Long>(comp);
    }

    public TreeMap<String, Double> doubleMapSorted() {
        HashMap<String, Double> tempMap = new HashMap<String, Double>(this.targetMapDouble);
        SortedDoubleMap comp = new SortedDoubleMap(tempMap);
        return new TreeMap<String, Double>(comp);
    }

    public Collection<String> getTargetList() {
        return this.targetList;
    }

    public String getNormalText() {
        return this.normalText;
    }

    public String getCommandToRun() {
        return this.commandToRun;
    }

    public String getListTitle() {
        return this.listTitle;
    }

    public String getListBorder() {
        return this.listBorder;
    }

    public String getHoverText() {
        return this.hoverText;
    }

    public String getHoverTextMessage() {
        return this.hoverTextMessage;
    }

    public String getNavigateCommand() {
        return this.navigateCommand;
    }

    public int getLinesPerPage() {
        return this.linesPerPage;
    }

    public MapType getType() {
        return this.type;
    }

    public PaginatedAssortment setType(MapType type) {
        this.type = type;
        return this;
    }

    public PaginatedAssortment setPlayer(Player p) {
        this.p = p;
        return this;
    }

    public PaginatedAssortment setTargetList(Collection<String> targetList) {
        this.targetList = targetList;
        return this;
    }

    public static enum MapType {
        LONG,
        DOUBLE;

    }
}

