/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.event;

import com.github.sanctum.labyrinth.Labyrinth;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class EventBuilder {
    Plugin plugin;

    public EventBuilder(Plugin instance) {
        this.plugin = instance;
    }

    public void compileFields(String packageName) {
        HashSet classes = Sets.newHashSet();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(URLDecoder.decode(this.plugin.getClass().getProtectionDomain().getCodeSource().getLocation().getFile(), "UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (JarEntry jarEntry : Collections.list(jarFile.entries())) {
            Class<?> clazz;
            String className = jarEntry.getName().replace("/", ".");
            if (!className.startsWith(packageName) || !className.endsWith(".class")) continue;
            try {
                clazz = Class.forName(className.substring(0, className.length() - 6));
            }
            catch (ClassNotFoundException e) {
                Labyrinth.getInstance().getLogger().severe("- Unable to find class" + className + "! Double check package location. See the error below for more information.");
                e.printStackTrace();
                break;
            }
            if (!Listener.class.isAssignableFrom(clazz)) continue;
            classes.add(clazz);
        }
        for (Class aClass : classes) {
            try {
                Bukkit.getPluginManager().registerEvents((Listener)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), this.plugin);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                Labyrinth.getInstance().getLogger().severe("- Unable to cast Listener to the class " + aClass.getName() + ". This likely means you are not implementing the Listener interface for your event class.");
                e.printStackTrace();
                break;
            }
        }
    }
}

