/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data.container;

import com.github.sanctum.labyrinth.Labyrinth;
import com.github.sanctum.labyrinth.data.Config;
import com.github.sanctum.labyrinth.data.container.DataStream;
import com.github.sanctum.labyrinth.library.HFEncoded;
import com.github.sanctum.labyrinth.library.HUID;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;

public class DataContainer
extends DataStream
implements Serializable {
    private static final Map<HUID, DataStream> metaDataContainer = new HashMap<HUID, DataStream>();
    private final String metaId;
    private final HUID huid;
    private String value;
    private final DataContainer instance;
    private static boolean debugging;
    private final List<String> values = new ArrayList<String>();

    public DataContainer(String metaId) {
        this.metaId = metaId;
        this.instance = this;
        this.huid = HUID.randomID();
    }

    @Override
    public HUID getId() {
        return this.huid;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public String value(int index) {
        return this.values.get(index);
    }

    @Override
    public String getMetaId() {
        return this.metaId;
    }

    public void setValue(Object o) {
        try {
            this.value = new HFEncoded(o).serialize();
        }
        catch (IOException e) {
            Bukkit.getServer().getLogger().severe("Unable to parse object.");
            e.printStackTrace();
        }
    }

    public void setValue(Object o, int index) {
        try {
            this.values.add(index, new HFEncoded(o).serialize());
        }
        catch (IOException e) {
            Bukkit.getServer().getLogger().severe("Unable to parse object.");
            e.printStackTrace();
        }
    }

    public static HUID[] get() {
        ArrayList<HUID> array = new ArrayList<HUID>();
        for (Map.Entry<HUID, DataStream> entry : metaDataContainer.entrySet()) {
            array.add(entry.getKey());
        }
        return array.toArray(new HUID[0]);
    }

    public void setDebugging(boolean b) {
        debugging = b;
    }

    public static HUID getHuid(String metaId) {
        Config data = Config.get("Meta", "Persistent");
        HUID result = null;
        try {
            for (String d : data.getConfig().getConfigurationSection("Data").getKeys(false)) {
                if (!data.getConfig().getString("Data." + d).equals("core:" + metaId)) continue;
                result = HUID.fromString(d);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return result;
    }

    public static DataStream loadInstance(HUID huid, boolean persist) {
        DataStream meta = null;
        for (HUID entry : DataContainer.get()) {
            if (!entry.equals(huid)) continue;
            meta = metaDataContainer.get(entry);
        }
        if (meta == null && persist) {
            Config file = Config.get(huid.toString(), "Container");
            DataContainer dataContainer = null;
            if (file.exists()) {
                try {
                    DataContainer instance = (DataContainer)new HFEncoded(file.getConfig().getString("Data")).deserialized();
                    metaDataContainer.put(huid, instance);
                    dataContainer = instance;
                }
                catch (IOException | ClassNotFoundException e) {
                    Bukkit.getServer().getLogger().severe("[Labyrinth] - Instance not loadable. One or more values changed or object location changed.");
                    e.printStackTrace();
                }
            } else {
                Bukkit.getServer().getLogger().severe("[Labyrinth] - No saved meta data can be found. Are you sure you saved it?");
            }
            if (dataContainer == null) {
                Bukkit.getServer().getLogger().severe("[Labyrinth] - Failed attempt at loading non existent instance of HUID link");
            } else {
                meta = dataContainer;
            }
        }
        return meta;
    }

    public static void deleteInstance(HUID huid) {
        Arrays.stream(DataContainer.get()).forEach(I -> {
            if (I.toString().equals(huid.toString())) {
                Config data = Config.get("Meta", "Persistent");
                if (!data.getConfig().isConfigurationSection("Data")) {
                    throw new NullPointerException("[Labyrinth] - No data is currently saved.");
                }
                for (String d : data.getConfig().getConfigurationSection("Data").getKeys(false)) {
                    if (!d.equals(huid.toString())) continue;
                    data.getConfig().set("Data." + d, null);
                    data.saveConfig();
                    break;
                }
                Config meta = Config.get(I.toString(), "Container");
                meta.delete();
                if (debugging) {
                    Bukkit.getServer().getLogger().info("[Labyrinth] - Instance for ID #" + I.toString() + " deleted.");
                }
                metaDataContainer.remove(I);
            }
        });
    }

    public static void querySaved() {
        File dir = new File(Config.class.getProtectionDomain().getCodeSource().getLocation().getPath().replaceAll("%20", " "));
        File file = new File(dir.getParentFile().getPath(), Labyrinth.getInstance().getName() + "/Container/");
        Arrays.stream(file.listFiles()).forEach(f -> {
            HUID id = HUID.fromString(f.getName().replace(".yml", ""));
            DataContainer m = DataContainer.loadSavedInstance(id);
            metaDataContainer.put(id, m);
        });
    }

    private static DataContainer loadSavedInstance(HUID huid) {
        Config file = Config.get(huid.toString(), "Container");
        DataContainer dataContainer = null;
        if (file.exists()) {
            try {
                DataContainer instance = (DataContainer)new HFEncoded(file.getConfig().getString("Data")).deserialized();
                metaDataContainer.put(huid, instance);
                dataContainer = instance;
            }
            catch (IOException | ClassNotFoundException e) {
                Bukkit.getServer().getLogger().severe("[Labyrinth] - Instance not loadable. One or more values changed or object location changed.");
                e.printStackTrace();
            }
        } else {
            Bukkit.getServer().getLogger().severe("[Labyrinth] - No saved meta data can be found. Are you sure you saved it?");
        }
        if (dataContainer == null) {
            Bukkit.getServer().getLogger().severe("[Labyrinth] - Failed attempt at loading non existent instance of HUID link");
        }
        return dataContainer;
    }

    public void storeTemp() {
        metaDataContainer.put(this.huid, this.instance);
        if (debugging) {
            Bukkit.getServer().getLogger().info("[Labyrinth] - Instance for ID #" + this.instance.huid.toString() + " cached.");
        }
    }

    public void saveMeta() {
        Config data = Config.get("Meta", "Persistent");
        data.getConfig().set("Data." + this.instance.huid.toString(), (Object)("core:" + this.metaId));
        data.saveConfig();
        Config meta = Config.get(this.huid.toString(), "Container");
        try {
            meta.getConfig().set("Data", (Object)new HFEncoded(this.instance).serialize());
            meta.saveConfig();
            if (debugging) {
                Bukkit.getServer().getLogger().info("[Labyrinth] - Instance for ID #" + this.instance.huid.toString() + " saved.");
                if (this.value != null) {
                    Bukkit.getServer().getLogger().info("[Labyrinth] - Object value for ID #" + this.instance.huid.toString() + " saved.");
                }
            }
        }
        catch (IOException e) {
            Bukkit.getServer().getLogger().severe("[Labyrinth] - Unable to parse object.");
            e.printStackTrace();
        }
    }
}

