/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data;

import com.github.sanctum.economy.construct.implement.AdvancedEconomy;
import com.github.sanctum.labyrinth.Labyrinth;
import org.bukkit.plugin.RegisteredServiceProvider;

public class AdvancedHook {
    private static AdvancedEconomy econ = null;
    private final Labyrinth instance;

    public AdvancedHook(Labyrinth instance) {
        this.instance = instance;
        if (!this.economyFound()) {
            instance.getLogger().warning("- No enterprise economy provider found.");
            instance.getLogger().warning("- Enterprise economy implementations from Labyrinth will not work.");
        }
    }

    private boolean economyFound() {
        if (this.instance.getServer().getPluginManager().getPlugin("Enterprise") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.instance.getServer().getServicesManager().getRegistration(AdvancedEconomy.class);
        if (rsp == null) {
            return false;
        }
        econ = (AdvancedEconomy)rsp.getProvider();
        this.instance.getLogger().info("- Enterprise economy provider found. Now using: " + ((AdvancedEconomy)rsp.getProvider()).getPlugin().getName());
        return true;
    }

    public static AdvancedEconomy getEconomy() {
        return econ;
    }
}

