/*
 * Decompiled with CFR 0.152.
 */
package com.github.testpress.mikephil.charting.renderer.scatter;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.github.testpress.mikephil.charting.buffer.ScatterBuffer;
import com.github.testpress.mikephil.charting.interfaces.datasets.IScatterDataSet;
import com.github.testpress.mikephil.charting.renderer.scatter.ShapeRenderer;
import com.github.testpress.mikephil.charting.utils.Utils;
import com.github.testpress.mikephil.charting.utils.ViewPortHandler;

public class CrossShapeRenderer
implements ShapeRenderer {
    @Override
    public void renderShape(Canvas c, IScatterDataSet dataSet, ViewPortHandler viewPortHandler, ScatterBuffer buffer, Paint renderPaint, float shapeSize) {
        float shapeHalf = shapeSize / 2.0f;
        renderPaint.setStyle(Paint.Style.STROKE);
        renderPaint.setStrokeWidth(Utils.convertDpToPixel(1.0f));
        for (int i = 0; i < buffer.size() && viewPortHandler.isInBoundsRight(buffer.buffer[i]); i += 2) {
            if (!viewPortHandler.isInBoundsLeft(buffer.buffer[i]) || !viewPortHandler.isInBoundsY(buffer.buffer[i + 1])) continue;
            renderPaint.setColor(dataSet.getColor(i / 2));
            c.drawLine(buffer.buffer[i] - shapeHalf, buffer.buffer[i + 1], buffer.buffer[i] + shapeHalf, buffer.buffer[i + 1], renderPaint);
            c.drawLine(buffer.buffer[i], buffer.buffer[i + 1] - shapeHalf, buffer.buffer[i], buffer.buffer[i + 1] + shapeHalf, renderPaint);
        }
    }
}

